/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.waiters;

import javax.annotation.Generated;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.waiters.SdkFunction;
import software.amazon.awssdk.services.ses.model.GetIdentityVerificationAttributesRequest;
import software.amazon.awssdk.services.ses.model.GetIdentityVerificationAttributesResponse;
import software.amazon.awssdk.services.ses.SESClient;

@SdkInternalApi
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class GetIdentityVerificationAttributesFunction implements
        SdkFunction<GetIdentityVerificationAttributesRequest, GetIdentityVerificationAttributesResponse> {

    /**
     * Represents the service client
     */
    private final SESClient client;

    /**
     * Constructs a new GetIdentityVerificationAttributesFunction with the given client
     * 
     * @param client
     *        Service client
     */
    public GetIdentityVerificationAttributesFunction(SESClient client) {
        this.client = client;
    }

    /**
     * Makes a call to the operation specified by the waiter by taking the corresponding request and returns the
     * corresponding result
     * 
     * @param getIdentityVerificationAttributesRequest
     *        Corresponding request for the operation
     * @return Corresponding result of the operation
     */
    @Override
    public GetIdentityVerificationAttributesResponse apply(
            GetIdentityVerificationAttributesRequest getIdentityVerificationAttributesRequest) {
        return client.getIdentityVerificationAttributes(getIdentityVerificationAttributesRequest);
    }
}
