/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * VerifyDomainDkimResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class VerifyDomainDkimResponseUnmarshaller implements Unmarshaller<VerifyDomainDkimResponse, StaxUnmarshallerContext> {

    public VerifyDomainDkimResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        VerifyDomainDkimResponse.Builder verifyDomainDkimResponse = VerifyDomainDkimResponse.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("DkimTokens", targetDepth)) {
                    verifyDomainDkimResponse.dkimTokens(new ArrayList<String>());
                    continue;
                }

                if (context.testExpression("DkimTokens/member", targetDepth)) {
                    verifyDomainDkimResponse.dkimTokens(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    break;
                }
            }
        }
        return verifyDomainDkimResponse.build();
    }

    private static VerifyDomainDkimResponseUnmarshaller INSTANCE;

    public static VerifyDomainDkimResponseUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new VerifyDomainDkimResponseUnmarshaller();
        return INSTANCE;
    }
}