/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.util.StringUtils;

/**
 * SendEmailRequest Marshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class SendEmailRequestMarshaller implements Marshaller<Request<SendEmailRequest>, SendEmailRequest> {

    public Request<SendEmailRequest> marshall(SendEmailRequest sendEmailRequest) {

        if (sendEmailRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        Request<SendEmailRequest> request = new DefaultRequest<SendEmailRequest>(sendEmailRequest, "SESClient");
        request.addParameter("Action", "SendEmail");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);

        if (sendEmailRequest.source() != null) {
            request.addParameter("Source", StringUtils.fromString(sendEmailRequest.source()));
        }

        Destination destination = sendEmailRequest.destination();
        if (destination != null) {

            software.amazon.awssdk.runtime.SdkInternalList<String> toAddressesList = (software.amazon.awssdk.runtime.SdkInternalList<String>) destination
                    .toAddresses();
            if (!toAddressesList.isEmpty() || !toAddressesList.isAutoConstruct()) {
                int toAddressesListIndex = 1;

                for (String toAddressesListValue : toAddressesList) {
                    if (toAddressesListValue != null) {
                        request.addParameter("Destination.ToAddresses.member." + toAddressesListIndex,
                                StringUtils.fromString(toAddressesListValue));
                    }
                    toAddressesListIndex++;
                }
            }

            software.amazon.awssdk.runtime.SdkInternalList<String> ccAddressesList = (software.amazon.awssdk.runtime.SdkInternalList<String>) destination
                    .ccAddresses();
            if (!ccAddressesList.isEmpty() || !ccAddressesList.isAutoConstruct()) {
                int ccAddressesListIndex = 1;

                for (String ccAddressesListValue : ccAddressesList) {
                    if (ccAddressesListValue != null) {
                        request.addParameter("Destination.CcAddresses.member." + ccAddressesListIndex,
                                StringUtils.fromString(ccAddressesListValue));
                    }
                    ccAddressesListIndex++;
                }
            }

            software.amazon.awssdk.runtime.SdkInternalList<String> bccAddressesList = (software.amazon.awssdk.runtime.SdkInternalList<String>) destination
                    .bccAddresses();
            if (!bccAddressesList.isEmpty() || !bccAddressesList.isAutoConstruct()) {
                int bccAddressesListIndex = 1;

                for (String bccAddressesListValue : bccAddressesList) {
                    if (bccAddressesListValue != null) {
                        request.addParameter("Destination.BccAddresses.member." + bccAddressesListIndex,
                                StringUtils.fromString(bccAddressesListValue));
                    }
                    bccAddressesListIndex++;
                }
            }
        }

        Message message = sendEmailRequest.message();
        if (message != null) {

            Content subject = message.subject();
            if (subject != null) {

                if (subject.data() != null) {
                    request.addParameter("Message.Subject.Data", StringUtils.fromString(subject.data()));
                }

                if (subject.charset() != null) {
                    request.addParameter("Message.Subject.Charset", StringUtils.fromString(subject.charset()));
                }
            }

            Body body = message.body();
            if (body != null) {

                Content text = body.text();
                if (text != null) {

                    if (text.data() != null) {
                        request.addParameter("Message.Body.Text.Data", StringUtils.fromString(text.data()));
                    }

                    if (text.charset() != null) {
                        request.addParameter("Message.Body.Text.Charset", StringUtils.fromString(text.charset()));
                    }
                }

                Content html = body.html();
                if (html != null) {

                    if (html.data() != null) {
                        request.addParameter("Message.Body.Html.Data", StringUtils.fromString(html.data()));
                    }

                    if (html.charset() != null) {
                        request.addParameter("Message.Body.Html.Charset", StringUtils.fromString(html.charset()));
                    }
                }
            }
        }

        software.amazon.awssdk.runtime.SdkInternalList<String> replyToAddressesList = (software.amazon.awssdk.runtime.SdkInternalList<String>) sendEmailRequest
                .replyToAddresses();
        if (!replyToAddressesList.isEmpty() || !replyToAddressesList.isAutoConstruct()) {
            int replyToAddressesListIndex = 1;

            for (String replyToAddressesListValue : replyToAddressesList) {
                if (replyToAddressesListValue != null) {
                    request.addParameter("ReplyToAddresses.member." + replyToAddressesListIndex,
                            StringUtils.fromString(replyToAddressesListValue));
                }
                replyToAddressesListIndex++;
            }
        }

        if (sendEmailRequest.returnPath() != null) {
            request.addParameter("ReturnPath", StringUtils.fromString(sendEmailRequest.returnPath()));
        }

        if (sendEmailRequest.sourceArn() != null) {
            request.addParameter("SourceArn", StringUtils.fromString(sendEmailRequest.sourceArn()));
        }

        if (sendEmailRequest.returnPathArn() != null) {
            request.addParameter("ReturnPathArn", StringUtils.fromString(sendEmailRequest.returnPathArn()));
        }

        software.amazon.awssdk.runtime.SdkInternalList<MessageTag> tagsList = (software.amazon.awssdk.runtime.SdkInternalList<MessageTag>) sendEmailRequest
                .tags();
        if (!tagsList.isEmpty() || !tagsList.isAutoConstruct()) {
            int tagsListIndex = 1;

            for (MessageTag tagsListValue : tagsList) {

                if (tagsListValue.name() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Name", StringUtils.fromString(tagsListValue.name()));
                }

                if (tagsListValue.value() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.value()));
                }
                tagsListIndex++;
            }
        }

        if (sendEmailRequest.configurationSetName() != null) {
            request.addParameter("ConfigurationSetName", StringUtils.fromString(sendEmailRequest.configurationSetName()));
        }

        return request;
    }

}
