/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * IdentityNotificationAttributes StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class IdentityNotificationAttributesUnmarshaller implements
        Unmarshaller<IdentityNotificationAttributes, StaxUnmarshallerContext> {

    public IdentityNotificationAttributes unmarshall(StaxUnmarshallerContext context) throws Exception {
        IdentityNotificationAttributes.Builder identityNotificationAttributes = IdentityNotificationAttributes.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("BounceTopic", targetDepth)) {
                    identityNotificationAttributes.bounceTopic(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ComplaintTopic", targetDepth)) {
                    identityNotificationAttributes.complaintTopic(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("DeliveryTopic", targetDepth)) {
                    identityNotificationAttributes.deliveryTopic(StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("ForwardingEnabled", targetDepth)) {
                    identityNotificationAttributes.forwardingEnabled(BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("HeadersInBounceNotificationsEnabled", targetDepth)) {
                    identityNotificationAttributes.headersInBounceNotificationsEnabled(BooleanUnmarshaller.getInstance()
                            .unmarshall(context));
                    continue;
                }

                if (context.testExpression("HeadersInComplaintNotificationsEnabled", targetDepth)) {
                    identityNotificationAttributes.headersInComplaintNotificationsEnabled(BooleanUnmarshaller.getInstance()
                            .unmarshall(context));
                    continue;
                }

                if (context.testExpression("HeadersInDeliveryNotificationsEnabled", targetDepth)) {
                    identityNotificationAttributes.headersInDeliveryNotificationsEnabled(BooleanUnmarshaller.getInstance()
                            .unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    break;
                }
            }
        }
        return identityNotificationAttributes.build();
    }

    private static IdentityNotificationAttributesUnmarshaller INSTANCE;

    public static IdentityNotificationAttributesUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new IdentityNotificationAttributesUnmarshaller();
        return INSTANCE;
    }
}