/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import software.amazon.awssdk.services.ses.model.*;
import software.amazon.awssdk.runtime.transform.Unmarshaller;

import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * DescribeActiveReceiptRuleSetResponse StAX Unmarshaller
 */

@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class DescribeActiveReceiptRuleSetResponseUnmarshaller implements
        Unmarshaller<DescribeActiveReceiptRuleSetResponse, StaxUnmarshallerContext> {

    public DescribeActiveReceiptRuleSetResponse unmarshall(StaxUnmarshallerContext context) throws Exception {
        DescribeActiveReceiptRuleSetResponse.Builder describeActiveReceiptRuleSetResponse = DescribeActiveReceiptRuleSetResponse
                .builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 2;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument()) {
                break;
            }

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("Metadata", targetDepth)) {
                    describeActiveReceiptRuleSetResponse.metadata(ReceiptRuleSetMetadataUnmarshaller.getInstance().unmarshall(
                            context));
                    continue;
                }

                if (context.testExpression("Rules", targetDepth)) {
                    describeActiveReceiptRuleSetResponse.rules(new ArrayList<ReceiptRule>());
                    continue;
                }

                if (context.testExpression("Rules/member", targetDepth)) {
                    describeActiveReceiptRuleSetResponse.rules(ReceiptRuleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    break;
                }
            }
        }
        return describeActiveReceiptRuleSetResponse.build();
    }

    private static DescribeActiveReceiptRuleSetResponseUnmarshaller INSTANCE;

    public static DescribeActiveReceiptRuleSetResponseUnmarshaller getInstance() {
        if (INSTANCE == null)
            INSTANCE = new DescribeActiveReceiptRuleSetResponseUnmarshaller();
        return INSTANCE;
    }
}