/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * When included in a receipt rule, this action calls Amazon WorkMail and, optionally, publishes a notification to
 * Amazon Simple Notification Service (Amazon SNS). You will typically not use this action directly because Amazon
 * WorkMail adds the rule automatically during its setup procedure.
 * </p>
 * <p>
 * For information using a receipt rule to call Amazon WorkMail, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-action-workmail.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class WorkmailAction implements ToCopyableBuilder<WorkmailAction.Builder, WorkmailAction> {
    private final String topicArn;

    private final String organizationArn;

    private WorkmailAction(BuilderImpl builder) {
        this.topicArn = builder.topicArn;
        this.organizationArn = builder.organizationArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the WorkMail action is called. An example
     * of an Amazon SNS topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more information about
     * Amazon SNS topics, see the <a href="http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS
     * Developer Guide</a>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the WorkMail action is called. An
     *         example of an Amazon SNS topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more
     *         information about Amazon SNS topics, see the <a
     *         href="http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.
     */
    public String topicArn() {
        return topicArn;
    }

    /**
     * <p>
     * The ARN of the Amazon WorkMail organization. An example of an Amazon WorkMail organization ARN is
     * <code>arn:aws:workmail:us-west-2:123456789012:organization/m-68755160c4cb4e29a2b2f8fb58f359d7</code>. For
     * information about Amazon WorkMail organizations, see the <a
     * href="http://docs.aws.amazon.com/workmail/latest/adminguide/organizations_overview.html">Amazon WorkMail
     * Administrator Guide</a>.
     * </p>
     * 
     * @return The ARN of the Amazon WorkMail organization. An example of an Amazon WorkMail organization ARN is
     *         <code>arn:aws:workmail:us-west-2:123456789012:organization/m-68755160c4cb4e29a2b2f8fb58f359d7</code>. For
     *         information about Amazon WorkMail organizations, see the <a
     *         href="http://docs.aws.amazon.com/workmail/latest/adminguide/organizations_overview.html">Amazon WorkMail
     *         Administrator Guide</a>.
     */
    public String organizationArn() {
        return organizationArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((topicArn() == null) ? 0 : topicArn().hashCode());
        hashCode = 31 * hashCode + ((organizationArn() == null) ? 0 : organizationArn().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkmailAction)) {
            return false;
        }
        WorkmailAction other = (WorkmailAction) obj;
        if (other.topicArn() == null ^ this.topicArn() == null) {
            return false;
        }
        if (other.topicArn() != null && !other.topicArn().equals(this.topicArn())) {
            return false;
        }
        if (other.organizationArn() == null ^ this.organizationArn() == null) {
            return false;
        }
        if (other.organizationArn() != null && !other.organizationArn().equals(this.organizationArn())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (topicArn() != null) {
            sb.append("TopicArn: ").append(topicArn()).append(",");
        }
        if (organizationArn() != null) {
            sb.append("OrganizationArn: ").append(organizationArn()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, WorkmailAction> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the WorkMail action is called. An
         * example of an Amazon SNS topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For more
         * information about Amazon SNS topics, see the <a
         * href="http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.
         * </p>
         * 
         * @param topicArn
         *        The Amazon Resource Name (ARN) of the Amazon SNS topic to notify when the WorkMail action is called.
         *        An example of an Amazon SNS topic ARN is <code>arn:aws:sns:us-west-2:123456789012:MyTopic</code>. For
         *        more information about Amazon SNS topics, see the <a
         *        href="http://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html">Amazon SNS Developer Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder topicArn(String topicArn);

        /**
         * <p>
         * The ARN of the Amazon WorkMail organization. An example of an Amazon WorkMail organization ARN is
         * <code>arn:aws:workmail:us-west-2:123456789012:organization/m-68755160c4cb4e29a2b2f8fb58f359d7</code>. For
         * information about Amazon WorkMail organizations, see the <a
         * href="http://docs.aws.amazon.com/workmail/latest/adminguide/organizations_overview.html">Amazon WorkMail
         * Administrator Guide</a>.
         * </p>
         * 
         * @param organizationArn
         *        The ARN of the Amazon WorkMail organization. An example of an Amazon WorkMail organization ARN is
         *        <code>arn:aws:workmail:us-west-2:123456789012:organization/m-68755160c4cb4e29a2b2f8fb58f359d7</code>.
         *        For information about Amazon WorkMail organizations, see the <a
         *        href="http://docs.aws.amazon.com/workmail/latest/adminguide/organizations_overview.html">Amazon
         *        WorkMail Administrator Guide</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationArn(String organizationArn);
    }

    private static final class BuilderImpl implements Builder {
        private String topicArn;

        private String organizationArn;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkmailAction model) {
            setTopicArn(model.topicArn);
            setOrganizationArn(model.organizationArn);
        }

        public final String getTopicArn() {
            return topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        public final String getOrganizationArn() {
            return organizationArn;
        }

        @Override
        public final Builder organizationArn(String organizationArn) {
            this.organizationArn = organizationArn;
            return this;
        }

        public final void setOrganizationArn(String organizationArn) {
            this.organizationArn = organizationArn;
        }

        @Override
        public WorkmailAction build() {
            return new WorkmailAction(this);
        }
    }
}
