/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to update a receipt rule. You use receipt rules to receive email with Amazon SES. For more
 * information, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateReceiptRuleRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<UpdateReceiptRuleRequest.Builder, UpdateReceiptRuleRequest> {
    private final String ruleSetName;

    private final ReceiptRule rule;

    private UpdateReceiptRuleRequest(BuilderImpl builder) {
        this.ruleSetName = builder.ruleSetName;
        this.rule = builder.rule;
    }

    /**
     * <p>
     * The name of the receipt rule set to which the receipt rule belongs.
     * </p>
     * 
     * @return The name of the receipt rule set to which the receipt rule belongs.
     */
    public String ruleSetName() {
        return ruleSetName;
    }

    /**
     * <p>
     * A data structure that contains the updated receipt rule information.
     * </p>
     * 
     * @return A data structure that contains the updated receipt rule information.
     */
    public ReceiptRule rule() {
        return rule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((ruleSetName() == null) ? 0 : ruleSetName().hashCode());
        hashCode = 31 * hashCode + ((rule() == null) ? 0 : rule().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateReceiptRuleRequest)) {
            return false;
        }
        UpdateReceiptRuleRequest other = (UpdateReceiptRuleRequest) obj;
        if (other.ruleSetName() == null ^ this.ruleSetName() == null) {
            return false;
        }
        if (other.ruleSetName() != null && !other.ruleSetName().equals(this.ruleSetName())) {
            return false;
        }
        if (other.rule() == null ^ this.rule() == null) {
            return false;
        }
        if (other.rule() != null && !other.rule().equals(this.rule())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (ruleSetName() != null) {
            sb.append("RuleSetName: ").append(ruleSetName()).append(",");
        }
        if (rule() != null) {
            sb.append("Rule: ").append(rule()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, UpdateReceiptRuleRequest> {
        /**
         * <p>
         * The name of the receipt rule set to which the receipt rule belongs.
         * </p>
         * 
         * @param ruleSetName
         *        The name of the receipt rule set to which the receipt rule belongs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSetName(String ruleSetName);

        /**
         * <p>
         * A data structure that contains the updated receipt rule information.
         * </p>
         * 
         * @param rule
         *        A data structure that contains the updated receipt rule information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rule(ReceiptRule rule);
    }

    private static final class BuilderImpl implements Builder {
        private String ruleSetName;

        private ReceiptRule rule;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateReceiptRuleRequest model) {
            setRuleSetName(model.ruleSetName);
            setRule(model.rule);
        }

        public final String getRuleSetName() {
            return ruleSetName;
        }

        @Override
        public final Builder ruleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
            return this;
        }

        public final void setRuleSetName(String ruleSetName) {
            this.ruleSetName = ruleSetName;
        }

        public final ReceiptRule getRule() {
            return rule;
        }

        @Override
        public final Builder rule(ReceiptRule rule) {
            this.rule = rule;
            return this;
        }

        public final void setRule(ReceiptRule rule) {
            this.rule = rule;
        }

        @Override
        public UpdateReceiptRuleRequest build() {
            return new UpdateReceiptRuleRequest(this);
        }
    }
}
