/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A receipt IP address filter enables you to specify whether to accept or reject mail originating from an IP address or
 * range of IP addresses.
 * </p>
 * <p>
 * For information about setting up IP address filters, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-ip-filters.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ReceiptFilter implements ToCopyableBuilder<ReceiptFilter.Builder, ReceiptFilter> {
    private final String name;

    private final ReceiptIpFilter ipFilter;

    private ReceiptFilter(BuilderImpl builder) {
        this.name = builder.name;
        this.ipFilter = builder.ipFilter;
    }

    /**
     * <p>
     * The name of the IP address filter. The name must:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-).
     * </p>
     * </li>
     * <li>
     * <p>
     * Start and end with a letter or number.
     * </p>
     * </li>
     * <li>
     * <p>
     * Contain less than 64 characters.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The name of the IP address filter. The name must:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Start and end with a letter or number.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Contain less than 64 characters.
     *         </p>
     *         </li>
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A structure that provides the IP addresses to block or allow, and whether to block or allow incoming mail from
     * them.
     * </p>
     * 
     * @return A structure that provides the IP addresses to block or allow, and whether to block or allow incoming mail
     *         from them.
     */
    public ReceiptIpFilter ipFilter() {
        return ipFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((ipFilter() == null) ? 0 : ipFilter().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReceiptFilter)) {
            return false;
        }
        ReceiptFilter other = (ReceiptFilter) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.ipFilter() == null ^ this.ipFilter() == null) {
            return false;
        }
        if (other.ipFilter() != null && !other.ipFilter().equals(this.ipFilter())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (ipFilter() != null) {
            sb.append("IpFilter: ").append(ipFilter()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ReceiptFilter> {
        /**
         * <p>
         * The name of the IP address filter. The name must:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-).
         * </p>
         * </li>
         * <li>
         * <p>
         * Start and end with a letter or number.
         * </p>
         * </li>
         * <li>
         * <p>
         * Contain less than 64 characters.
         * </p>
         * </li>
         * </ul>
         * 
         * @param name
         *        The name of the IP address filter. The name must:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Start and end with a letter or number.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Contain less than 64 characters.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A structure that provides the IP addresses to block or allow, and whether to block or allow incoming mail
         * from them.
         * </p>
         * 
         * @param ipFilter
         *        A structure that provides the IP addresses to block or allow, and whether to block or allow incoming
         *        mail from them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipFilter(ReceiptIpFilter ipFilter);
    }

    private static final class BuilderImpl implements Builder {
        private String name;

        private ReceiptIpFilter ipFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ReceiptFilter model) {
            setName(model.name);
            setIpFilter(model.ipFilter);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final ReceiptIpFilter getIpFilter() {
            return ipFilter;
        }

        @Override
        public final Builder ipFilter(ReceiptIpFilter ipFilter) {
            this.ipFilter = ipFilter;
            return this;
        }

        public final void setIpFilter(ReceiptIpFilter ipFilter) {
            this.ipFilter = ipFilter;
        }

        @Override
        public ReceiptFilter build() {
            return new ReceiptFilter(this);
        }
    }
}
