/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the message to be sent, composed of a subject and a body.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Message implements ToCopyableBuilder<Message.Builder, Message> {
    private final Content subject;

    private final Body body;

    private Message(BuilderImpl builder) {
        this.subject = builder.subject;
        this.body = builder.body;
    }

    /**
     * <p>
     * The subject of the message: A short summary of the content, which will appear in the recipient's inbox.
     * </p>
     * 
     * @return The subject of the message: A short summary of the content, which will appear in the recipient's inbox.
     */
    public Content subject() {
        return subject;
    }

    /**
     * <p>
     * The message body.
     * </p>
     * 
     * @return The message body.
     */
    public Body body() {
        return body;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((subject() == null) ? 0 : subject().hashCode());
        hashCode = 31 * hashCode + ((body() == null) ? 0 : body().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Message)) {
            return false;
        }
        Message other = (Message) obj;
        if (other.subject() == null ^ this.subject() == null) {
            return false;
        }
        if (other.subject() != null && !other.subject().equals(this.subject())) {
            return false;
        }
        if (other.body() == null ^ this.body() == null) {
            return false;
        }
        if (other.body() != null && !other.body().equals(this.body())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (subject() != null) {
            sb.append("Subject: ").append(subject()).append(",");
        }
        if (body() != null) {
            sb.append("Body: ").append(body()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, Message> {
        /**
         * <p>
         * The subject of the message: A short summary of the content, which will appear in the recipient's inbox.
         * </p>
         * 
         * @param subject
         *        The subject of the message: A short summary of the content, which will appear in the recipient's
         *        inbox.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subject(Content subject);

        /**
         * <p>
         * The message body.
         * </p>
         * 
         * @param body
         *        The message body.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder body(Body body);
    }

    private static final class BuilderImpl implements Builder {
        private Content subject;

        private Body body;

        private BuilderImpl() {
        }

        private BuilderImpl(Message model) {
            setSubject(model.subject);
            setBody(model.body);
        }

        public final Content getSubject() {
            return subject;
        }

        @Override
        public final Builder subject(Content subject) {
            this.subject = subject;
            return this;
        }

        public final void setSubject(Content subject) {
            this.subject = subject;
        }

        public final Body getBody() {
            return body;
        }

        @Override
        public final Builder body(Body body) {
            this.body = body;
            return this;
        }

        public final void setBody(Body body) {
            this.body = body;
        }

        @Override
        public Message build() {
            return new Message(this);
        }
    }
}
