/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.runtime.SdkInternalMap;
import software.amazon.awssdk.runtime.StandardMemberCopier;

@Generated("software.amazon.awssdk:codegen")
final class MailFromDomainAttributesCopier {
    static Map<String, IdentityMailFromDomainAttributes> copy(
            Map<String, IdentityMailFromDomainAttributes> mailFromDomainAttributesParam) {
        if (mailFromDomainAttributesParam == null) {
            return null;
        }
        Map<String, IdentityMailFromDomainAttributes> mailFromDomainAttributesParamCopy = new SdkInternalMap<>(
                mailFromDomainAttributesParam.size());
        for (Map.Entry<String, IdentityMailFromDomainAttributes> e : mailFromDomainAttributesParam.entrySet()) {
            mailFromDomainAttributesParamCopy.put(StandardMemberCopier.copy(e.getKey()), e.getValue());
        }
        return mailFromDomainAttributesParamCopy;
    }
}
