/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of receipt rule sets that exist under your AWS account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListReceiptRuleSetsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListReceiptRuleSetsResponse.Builder, ListReceiptRuleSetsResponse> {
    private final List<ReceiptRuleSetMetadata> ruleSets;

    private final String nextToken;

    private ListReceiptRuleSetsResponse(BuilderImpl builder) {
        this.ruleSets = builder.ruleSets;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The metadata for the currently active receipt rule set. The metadata consists of the rule set name and the
     * timestamp of when the rule set was created.
     * </p>
     * 
     * @return The metadata for the currently active receipt rule set. The metadata consists of the rule set name and
     *         the timestamp of when the rule set was created.
     */
    public List<ReceiptRuleSetMetadata> ruleSets() {
        return ruleSets;
    }

    /**
     * <p>
     * A token indicating that there are additional receipt rule sets available to be listed. Pass this token to
     * successive calls of <code>ListReceiptRuleSets</code> to retrieve up to 100 receipt rule sets at a time.
     * </p>
     * 
     * @return A token indicating that there are additional receipt rule sets available to be listed. Pass this token to
     *         successive calls of <code>ListReceiptRuleSets</code> to retrieve up to 100 receipt rule sets at a time.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((ruleSets() == null) ? 0 : ruleSets().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListReceiptRuleSetsResponse)) {
            return false;
        }
        ListReceiptRuleSetsResponse other = (ListReceiptRuleSetsResponse) obj;
        if (other.ruleSets() == null ^ this.ruleSets() == null) {
            return false;
        }
        if (other.ruleSets() != null && !other.ruleSets().equals(this.ruleSets())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (ruleSets() != null) {
            sb.append("RuleSets: ").append(ruleSets()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListReceiptRuleSetsResponse> {
        /**
         * <p>
         * The metadata for the currently active receipt rule set. The metadata consists of the rule set name and the
         * timestamp of when the rule set was created.
         * </p>
         * 
         * @param ruleSets
         *        The metadata for the currently active receipt rule set. The metadata consists of the rule set name and
         *        the timestamp of when the rule set was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSets(Collection<ReceiptRuleSetMetadata> ruleSets);

        /**
         * <p>
         * The metadata for the currently active receipt rule set. The metadata consists of the rule set name and the
         * timestamp of when the rule set was created.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setRuleSets(java.util.Collection)} or {@link #withRuleSets(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param ruleSets
         *        The metadata for the currently active receipt rule set. The metadata consists of the rule set name and
         *        the timestamp of when the rule set was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ruleSets(ReceiptRuleSetMetadata... ruleSets);

        /**
         * <p>
         * A token indicating that there are additional receipt rule sets available to be listed. Pass this token to
         * successive calls of <code>ListReceiptRuleSets</code> to retrieve up to 100 receipt rule sets at a time.
         * </p>
         * 
         * @param nextToken
         *        A token indicating that there are additional receipt rule sets available to be listed. Pass this token
         *        to successive calls of <code>ListReceiptRuleSets</code> to retrieve up to 100 receipt rule sets at a
         *        time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<ReceiptRuleSetMetadata> ruleSets = new SdkInternalList<>();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListReceiptRuleSetsResponse model) {
            setRuleSets(model.ruleSets);
            setNextToken(model.nextToken);
        }

        public final Collection<ReceiptRuleSetMetadata> getRuleSets() {
            return ruleSets;
        }

        @Override
        public final Builder ruleSets(Collection<ReceiptRuleSetMetadata> ruleSets) {
            this.ruleSets = ReceiptRuleSetsListsCopier.copy(ruleSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleSets(ReceiptRuleSetMetadata... ruleSets) {
            if (this.ruleSets == null) {
                this.ruleSets = new SdkInternalList<>(ruleSets.length);
            }
            for (ReceiptRuleSetMetadata e : ruleSets) {
                this.ruleSets.add(e);
            }
            return this;
        }

        public final void setRuleSets(Collection<ReceiptRuleSetMetadata> ruleSets) {
            this.ruleSets = ReceiptRuleSetsListsCopier.copy(ruleSets);
        }

        @SafeVarargs
        public final void setRuleSets(ReceiptRuleSetMetadata... ruleSets) {
            if (this.ruleSets == null) {
                this.ruleSets = new SdkInternalList<>(ruleSets.length);
            }
            for (ReceiptRuleSetMetadata e : ruleSets) {
                this.ruleSets.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListReceiptRuleSetsResponse build() {
            return new ListReceiptRuleSetsResponse(this);
        }
    }
}
