/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of configuration sets associated with your AWS account. Configuration sets enable you to publish email sending
 * events. For information about using configuration sets, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ListConfigurationSetsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ListConfigurationSetsResponse.Builder, ListConfigurationSetsResponse> {
    private final List<ConfigurationSet> configurationSets;

    private final String nextToken;

    private ListConfigurationSetsResponse(BuilderImpl builder) {
        this.configurationSets = builder.configurationSets;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A list of configuration sets.
     * </p>
     * 
     * @return A list of configuration sets.
     */
    public List<ConfigurationSet> configurationSets() {
        return configurationSets;
    }

    /**
     * <p>
     * A token indicating that there are additional configuration sets available to be listed. Pass this token to
     * successive calls of <code>ListConfigurationSets</code>.
     * </p>
     * 
     * @return A token indicating that there are additional configuration sets available to be listed. Pass this token
     *         to successive calls of <code>ListConfigurationSets</code>.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((configurationSets() == null) ? 0 : configurationSets().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListConfigurationSetsResponse)) {
            return false;
        }
        ListConfigurationSetsResponse other = (ListConfigurationSetsResponse) obj;
        if (other.configurationSets() == null ^ this.configurationSets() == null) {
            return false;
        }
        if (other.configurationSets() != null && !other.configurationSets().equals(this.configurationSets())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (configurationSets() != null) {
            sb.append("ConfigurationSets: ").append(configurationSets()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ListConfigurationSetsResponse> {
        /**
         * <p>
         * A list of configuration sets.
         * </p>
         * 
         * @param configurationSets
         *        A list of configuration sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSets(Collection<ConfigurationSet> configurationSets);

        /**
         * <p>
         * A list of configuration sets.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setConfigurationSets(java.util.Collection)} or {@link #withConfigurationSets(java.util.Collection)}
         * if you want to override the existing values.
         * </p>
         * 
         * @param configurationSets
         *        A list of configuration sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationSets(ConfigurationSet... configurationSets);

        /**
         * <p>
         * A token indicating that there are additional configuration sets available to be listed. Pass this token to
         * successive calls of <code>ListConfigurationSets</code>.
         * </p>
         * 
         * @param nextToken
         *        A token indicating that there are additional configuration sets available to be listed. Pass this
         *        token to successive calls of <code>ListConfigurationSets</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<ConfigurationSet> configurationSets = new SdkInternalList<>();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListConfigurationSetsResponse model) {
            setConfigurationSets(model.configurationSets);
            setNextToken(model.nextToken);
        }

        public final Collection<ConfigurationSet> getConfigurationSets() {
            return configurationSets;
        }

        @Override
        public final Builder configurationSets(Collection<ConfigurationSet> configurationSets) {
            this.configurationSets = ConfigurationSetsCopier.copy(configurationSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder configurationSets(ConfigurationSet... configurationSets) {
            if (this.configurationSets == null) {
                this.configurationSets = new SdkInternalList<>(configurationSets.length);
            }
            for (ConfigurationSet e : configurationSets) {
                this.configurationSets.add(e);
            }
            return this;
        }

        public final void setConfigurationSets(Collection<ConfigurationSet> configurationSets) {
            this.configurationSets = ConfigurationSetsCopier.copy(configurationSets);
        }

        @SafeVarargs
        public final void setConfigurationSets(ConfigurationSet... configurationSets) {
            if (this.configurationSets == null) {
                this.configurationSets = new SdkInternalList<>(configurationSets.length);
            }
            for (ConfigurationSet e : configurationSets) {
                this.configurationSets.add(e);
            }
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListConfigurationSetsResponse build() {
            return new ListConfigurationSetsResponse(this);
        }
    }
}
