/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents your Amazon SES daily sending quota, maximum send rate, and the number of emails you have sent in the last
 * 24 hours.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetSendQuotaResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetSendQuotaResponse.Builder, GetSendQuotaResponse> {
    private final Double max24HourSend;

    private final Double maxSendRate;

    private final Double sentLast24Hours;

    private GetSendQuotaResponse(BuilderImpl builder) {
        this.max24HourSend = builder.max24HourSend;
        this.maxSendRate = builder.maxSendRate;
        this.sentLast24Hours = builder.sentLast24Hours;
    }

    /**
     * <p>
     * The maximum number of emails the user is allowed to send in a 24-hour interval. A value of -1 signifies an
     * unlimited quota.
     * </p>
     * 
     * @return The maximum number of emails the user is allowed to send in a 24-hour interval. A value of -1 signifies
     *         an unlimited quota.
     */
    public Double max24HourSend() {
        return max24HourSend;
    }

    /**
     * <p>
     * The maximum number of emails that Amazon SES can accept from the user's account per second.
     * </p>
     * <note>
     * <p>
     * The rate at which Amazon SES accepts the user's messages might be less than the maximum send rate.
     * </p>
     * </note>
     * 
     * @return The maximum number of emails that Amazon SES can accept from the user's account per second.</p> <note>
     *         <p>
     *         The rate at which Amazon SES accepts the user's messages might be less than the maximum send rate.
     *         </p>
     */
    public Double maxSendRate() {
        return maxSendRate;
    }

    /**
     * <p>
     * The number of emails sent during the previous 24 hours.
     * </p>
     * 
     * @return The number of emails sent during the previous 24 hours.
     */
    public Double sentLast24Hours() {
        return sentLast24Hours;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((max24HourSend() == null) ? 0 : max24HourSend().hashCode());
        hashCode = 31 * hashCode + ((maxSendRate() == null) ? 0 : maxSendRate().hashCode());
        hashCode = 31 * hashCode + ((sentLast24Hours() == null) ? 0 : sentLast24Hours().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSendQuotaResponse)) {
            return false;
        }
        GetSendQuotaResponse other = (GetSendQuotaResponse) obj;
        if (other.max24HourSend() == null ^ this.max24HourSend() == null) {
            return false;
        }
        if (other.max24HourSend() != null && !other.max24HourSend().equals(this.max24HourSend())) {
            return false;
        }
        if (other.maxSendRate() == null ^ this.maxSendRate() == null) {
            return false;
        }
        if (other.maxSendRate() != null && !other.maxSendRate().equals(this.maxSendRate())) {
            return false;
        }
        if (other.sentLast24Hours() == null ^ this.sentLast24Hours() == null) {
            return false;
        }
        if (other.sentLast24Hours() != null && !other.sentLast24Hours().equals(this.sentLast24Hours())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (max24HourSend() != null) {
            sb.append("Max24HourSend: ").append(max24HourSend()).append(",");
        }
        if (maxSendRate() != null) {
            sb.append("MaxSendRate: ").append(maxSendRate()).append(",");
        }
        if (sentLast24Hours() != null) {
            sb.append("SentLast24Hours: ").append(sentLast24Hours()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetSendQuotaResponse> {
        /**
         * <p>
         * The maximum number of emails the user is allowed to send in a 24-hour interval. A value of -1 signifies an
         * unlimited quota.
         * </p>
         * 
         * @param max24HourSend
         *        The maximum number of emails the user is allowed to send in a 24-hour interval. A value of -1
         *        signifies an unlimited quota.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder max24HourSend(Double max24HourSend);

        /**
         * <p>
         * The maximum number of emails that Amazon SES can accept from the user's account per second.
         * </p>
         * <note>
         * <p>
         * The rate at which Amazon SES accepts the user's messages might be less than the maximum send rate.
         * </p>
         * </note>
         * 
         * @param maxSendRate
         *        The maximum number of emails that Amazon SES can accept from the user's account per second.</p> <note>
         *        <p>
         *        The rate at which Amazon SES accepts the user's messages might be less than the maximum send rate.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSendRate(Double maxSendRate);

        /**
         * <p>
         * The number of emails sent during the previous 24 hours.
         * </p>
         * 
         * @param sentLast24Hours
         *        The number of emails sent during the previous 24 hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sentLast24Hours(Double sentLast24Hours);
    }

    private static final class BuilderImpl implements Builder {
        private Double max24HourSend;

        private Double maxSendRate;

        private Double sentLast24Hours;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSendQuotaResponse model) {
            setMax24HourSend(model.max24HourSend);
            setMaxSendRate(model.maxSendRate);
            setSentLast24Hours(model.sentLast24Hours);
        }

        public final Double getMax24HourSend() {
            return max24HourSend;
        }

        @Override
        public final Builder max24HourSend(Double max24HourSend) {
            this.max24HourSend = max24HourSend;
            return this;
        }

        public final void setMax24HourSend(Double max24HourSend) {
            this.max24HourSend = max24HourSend;
        }

        public final Double getMaxSendRate() {
            return maxSendRate;
        }

        @Override
        public final Builder maxSendRate(Double maxSendRate) {
            this.maxSendRate = maxSendRate;
            return this;
        }

        public final void setMaxSendRate(Double maxSendRate) {
            this.maxSendRate = maxSendRate;
        }

        public final Double getSentLast24Hours() {
            return sentLast24Hours;
        }

        @Override
        public final Builder sentLast24Hours(Double sentLast24Hours) {
            this.sentLast24Hours = sentLast24Hours;
            return this;
        }

        public final void setSentLast24Hours(Double sentLast24Hours) {
            this.sentLast24Hours = sentLast24Hours;
        }

        @Override
        public GetSendQuotaResponse build() {
            return new GetSendQuotaResponse(this);
        }
    }
}
