/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.runtime.SdkInternalMap;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the requested sending authorization policies.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetIdentityPoliciesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetIdentityPoliciesResponse.Builder, GetIdentityPoliciesResponse> {
    private final Map<String, String> policies;

    private GetIdentityPoliciesResponse(BuilderImpl builder) {
        this.policies = builder.policies;
    }

    /**
     * <p>
     * A map of policy names to policies.
     * </p>
     * 
     * @return A map of policy names to policies.
     */
    public Map<String, String> policies() {
        return policies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((policies() == null) ? 0 : policies().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityPoliciesResponse)) {
            return false;
        }
        GetIdentityPoliciesResponse other = (GetIdentityPoliciesResponse) obj;
        if (other.policies() == null ^ this.policies() == null) {
            return false;
        }
        if (other.policies() != null && !other.policies().equals(this.policies())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (policies() != null) {
            sb.append("Policies: ").append(policies()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetIdentityPoliciesResponse> {
        /**
         * <p>
         * A map of policy names to policies.
         * </p>
         * 
         * @param policies
         *        A map of policy names to policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policies(Map<String, String> policies);
    }

    private static final class BuilderImpl implements Builder {
        private Map<String, String> policies = new SdkInternalMap<>();

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityPoliciesResponse model) {
            setPolicies(model.policies);
        }

        public final Map<String, String> getPolicies() {
            return policies;
        }

        @Override
        public final Builder policies(Map<String, String> policies) {
            this.policies = PolicyMapCopier.copy(policies);
            return this;
        }

        public final void setPolicies(Map<String, String> policies) {
            this.policies = PolicyMapCopier.copy(policies);
        }

        @Override
        public GetIdentityPoliciesResponse build() {
            return new GetIdentityPoliciesResponse(this);
        }
    }
}
