/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to return the notification attributes for a list of identities you verified with Amazon SES. For
 * information about Amazon SES notifications, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/notifications.html">Amazon SES Developer Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetIdentityNotificationAttributesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<GetIdentityNotificationAttributesRequest.Builder, GetIdentityNotificationAttributesRequest> {
    private final List<String> identities;

    private GetIdentityNotificationAttributesRequest(BuilderImpl builder) {
        this.identities = builder.identities;
    }

    /**
     * <p>
     * A list of one or more identities. You can specify an identity by using its name or by using its Amazon Resource
     * Name (ARN). Examples: <code>user@example.com</code>, <code>example.com</code>,
     * <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.
     * </p>
     * 
     * @return A list of one or more identities. You can specify an identity by using its name or by using its Amazon
     *         Resource Name (ARN). Examples: <code>user@example.com</code>, <code>example.com</code>,
     *         <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.
     */
    public List<String> identities() {
        return identities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((identities() == null) ? 0 : identities().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetIdentityNotificationAttributesRequest)) {
            return false;
        }
        GetIdentityNotificationAttributesRequest other = (GetIdentityNotificationAttributesRequest) obj;
        if (other.identities() == null ^ this.identities() == null) {
            return false;
        }
        if (other.identities() != null && !other.identities().equals(this.identities())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (identities() != null) {
            sb.append("Identities: ").append(identities()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetIdentityNotificationAttributesRequest> {
        /**
         * <p>
         * A list of one or more identities. You can specify an identity by using its name or by using its Amazon
         * Resource Name (ARN). Examples: <code>user@example.com</code>, <code>example.com</code>,
         * <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.
         * </p>
         * 
         * @param identities
         *        A list of one or more identities. You can specify an identity by using its name or by using its Amazon
         *        Resource Name (ARN). Examples: <code>user@example.com</code>, <code>example.com</code>,
         *        <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identities(Collection<String> identities);

        /**
         * <p>
         * A list of one or more identities. You can specify an identity by using its name or by using its Amazon
         * Resource Name (ARN). Examples: <code>user@example.com</code>, <code>example.com</code>,
         * <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setIdentities(java.util.Collection)} or {@link #withIdentities(java.util.Collection)} if you want to
         * override the existing values.
         * </p>
         * 
         * @param identities
         *        A list of one or more identities. You can specify an identity by using its name or by using its Amazon
         *        Resource Name (ARN). Examples: <code>user@example.com</code>, <code>example.com</code>,
         *        <code>arn:aws:ses:us-east-1:123456789012:identity/example.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identities(String... identities);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> identities = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(GetIdentityNotificationAttributesRequest model) {
            setIdentities(model.identities);
        }

        public final Collection<String> getIdentities() {
            return identities;
        }

        @Override
        public final Builder identities(Collection<String> identities) {
            this.identities = IdentityListCopier.copy(identities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identities(String... identities) {
            if (this.identities == null) {
                this.identities = new SdkInternalList<>(identities.length);
            }
            for (String e : identities) {
                this.identities.add(e);
            }
            return this;
        }

        public final void setIdentities(Collection<String> identities) {
            this.identities = IdentityListCopier.copy(identities);
        }

        @SafeVarargs
        public final void setIdentities(String... identities) {
            if (this.identities == null) {
                this.identities = new SdkInternalList<>(identities.length);
            }
            for (String e : identities) {
                this.identities.add(e);
            }
        }

        @Override
        public GetIdentityNotificationAttributesRequest build() {
            return new GetIdentityNotificationAttributesRequest(this);
        }
    }
}
