/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a request to delete one of your Amazon SES identities (an email address or domain).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteIdentityRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteIdentityRequest.Builder, DeleteIdentityRequest> {
    private final String identity;

    private DeleteIdentityRequest(BuilderImpl builder) {
        this.identity = builder.identity;
    }

    /**
     * <p>
     * The identity to be removed from the list of identities for the AWS Account.
     * </p>
     * 
     * @return The identity to be removed from the list of identities for the AWS Account.
     */
    public String identity() {
        return identity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((identity() == null) ? 0 : identity().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteIdentityRequest)) {
            return false;
        }
        DeleteIdentityRequest other = (DeleteIdentityRequest) obj;
        if (other.identity() == null ^ this.identity() == null) {
            return false;
        }
        if (other.identity() != null && !other.identity().equals(this.identity())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (identity() != null) {
            sb.append("Identity: ").append(identity()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteIdentityRequest> {
        /**
         * <p>
         * The identity to be removed from the list of identities for the AWS Account.
         * </p>
         * 
         * @param identity
         *        The identity to be removed from the list of identities for the AWS Account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identity(String identity);
    }

    private static final class BuilderImpl implements Builder {
        private String identity;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteIdentityRequest model) {
            setIdentity(model.identity);
        }

        public final String getIdentity() {
            return identity;
        }

        @Override
        public final Builder identity(String identity) {
            this.identity = identity;
            return this;
        }

        public final void setIdentity(String identity) {
            this.identity = identity;
        }

        @Override
        public DeleteIdentityRequest build() {
            return new DeleteIdentityRequest(this);
        }
    }
}
