/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ses.model;

import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information associated with an Amazon CloudWatch event destination to which email sending events are
 * published.
 * </p>
 * <p>
 * Event destinations, such as Amazon CloudWatch, are associated with configuration sets, which enable you to publish
 * email sending events. For information about using configuration sets, see the <a
 * href="http://docs.aws.amazon.com/ses/latest/DeveloperGuide/monitor-sending-activity.html">Amazon SES Developer
 * Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CloudWatchDestination implements ToCopyableBuilder<CloudWatchDestination.Builder, CloudWatchDestination> {
    private final List<CloudWatchDimensionConfiguration> dimensionConfigurations;

    private CloudWatchDestination(BuilderImpl builder) {
        this.dimensionConfigurations = builder.dimensionConfigurations;
    }

    /**
     * <p>
     * A list of dimensions upon which to categorize your emails when you publish email sending events to Amazon
     * CloudWatch.
     * </p>
     * 
     * @return A list of dimensions upon which to categorize your emails when you publish email sending events to Amazon
     *         CloudWatch.
     */
    public List<CloudWatchDimensionConfiguration> dimensionConfigurations() {
        return dimensionConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((dimensionConfigurations() == null) ? 0 : dimensionConfigurations().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchDestination)) {
            return false;
        }
        CloudWatchDestination other = (CloudWatchDestination) obj;
        if (other.dimensionConfigurations() == null ^ this.dimensionConfigurations() == null) {
            return false;
        }
        if (other.dimensionConfigurations() != null && !other.dimensionConfigurations().equals(this.dimensionConfigurations())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (dimensionConfigurations() != null) {
            sb.append("DimensionConfigurations: ").append(dimensionConfigurations()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CloudWatchDestination> {
        /**
         * <p>
         * A list of dimensions upon which to categorize your emails when you publish email sending events to Amazon
         * CloudWatch.
         * </p>
         * 
         * @param dimensionConfigurations
         *        A list of dimensions upon which to categorize your emails when you publish email sending events to
         *        Amazon CloudWatch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionConfigurations(Collection<CloudWatchDimensionConfiguration> dimensionConfigurations);

        /**
         * <p>
         * A list of dimensions upon which to categorize your emails when you publish email sending events to Amazon
         * CloudWatch.
         * </p>
         * <p>
         * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
         * {@link #setDimensionConfigurations(java.util.Collection)} or
         * {@link #withDimensionConfigurations(java.util.Collection)} if you want to override the existing values.
         * </p>
         * 
         * @param dimensionConfigurations
         *        A list of dimensions upon which to categorize your emails when you publish email sending events to
         *        Amazon CloudWatch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dimensionConfigurations(CloudWatchDimensionConfiguration... dimensionConfigurations);
    }

    private static final class BuilderImpl implements Builder {
        private List<CloudWatchDimensionConfiguration> dimensionConfigurations = new SdkInternalList<>();

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchDestination model) {
            setDimensionConfigurations(model.dimensionConfigurations);
        }

        public final Collection<CloudWatchDimensionConfiguration> getDimensionConfigurations() {
            return dimensionConfigurations;
        }

        @Override
        public final Builder dimensionConfigurations(Collection<CloudWatchDimensionConfiguration> dimensionConfigurations) {
            this.dimensionConfigurations = CloudWatchDimensionConfigurationsCopier.copy(dimensionConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensionConfigurations(CloudWatchDimensionConfiguration... dimensionConfigurations) {
            if (this.dimensionConfigurations == null) {
                this.dimensionConfigurations = new SdkInternalList<>(dimensionConfigurations.length);
            }
            for (CloudWatchDimensionConfiguration e : dimensionConfigurations) {
                this.dimensionConfigurations.add(e);
            }
            return this;
        }

        public final void setDimensionConfigurations(Collection<CloudWatchDimensionConfiguration> dimensionConfigurations) {
            this.dimensionConfigurations = CloudWatchDimensionConfigurationsCopier.copy(dimensionConfigurations);
        }

        @SafeVarargs
        public final void setDimensionConfigurations(CloudWatchDimensionConfiguration... dimensionConfigurations) {
            if (this.dimensionConfigurations == null) {
                this.dimensionConfigurations = new SdkInternalList<>(dimensionConfigurations.length);
            }
            for (CloudWatchDimensionConfiguration e : dimensionConfigurations) {
                this.dimensionConfigurations.add(e);
            }
        }

        @Override
        public CloudWatchDestination build() {
            return new CloudWatchDestination(this);
        }
    }
}
