/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicequotas.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.servicequotas.model.MetricDimensionsMapDefinitionCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricInfo> {
    private static final SdkField<String> METRIC_NAMESPACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricNamespace").getter(MetricInfo.getter(MetricInfo::metricNamespace)).setter(MetricInfo.setter(Builder::metricNamespace)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricNamespace").build()}).build();
    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricName").getter(MetricInfo.getter(MetricInfo::metricName)).setter(MetricInfo.setter(Builder::metricName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()}).build();
    private static final SdkField<Map<String, String>> METRIC_DIMENSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("MetricDimensions").getter(MetricInfo.getter(MetricInfo::metricDimensions)).setter(MetricInfo.setter(Builder::metricDimensions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricDimensions").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> METRIC_STATISTIC_RECOMMENDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetricStatisticRecommendation").getter(MetricInfo.getter(MetricInfo::metricStatisticRecommendation)).setter(MetricInfo.setter(Builder::metricStatisticRecommendation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricStatisticRecommendation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAMESPACE_FIELD, METRIC_NAME_FIELD, METRIC_DIMENSIONS_FIELD, METRIC_STATISTIC_RECOMMENDATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MetricInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String metricNamespace;
    private final String metricName;
    private final Map<String, String> metricDimensions;
    private final String metricStatisticRecommendation;

    private MetricInfo(BuilderImpl builder) {
        this.metricNamespace = builder.metricNamespace;
        this.metricName = builder.metricName;
        this.metricDimensions = builder.metricDimensions;
        this.metricStatisticRecommendation = builder.metricStatisticRecommendation;
    }

    public final String metricNamespace() {
        return this.metricNamespace;
    }

    public final String metricName() {
        return this.metricName;
    }

    public final boolean hasMetricDimensions() {
        return this.metricDimensions != null && !(this.metricDimensions instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> metricDimensions() {
        return this.metricDimensions;
    }

    public final String metricStatisticRecommendation() {
        return this.metricStatisticRecommendation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metricNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetricDimensions() ? this.metricDimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.metricStatisticRecommendation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricInfo)) {
            return false;
        }
        MetricInfo other = (MetricInfo)obj;
        return Objects.equals(this.metricNamespace(), other.metricNamespace()) && Objects.equals(this.metricName(), other.metricName()) && this.hasMetricDimensions() == other.hasMetricDimensions() && Objects.equals(this.metricDimensions(), other.metricDimensions()) && Objects.equals(this.metricStatisticRecommendation(), other.metricStatisticRecommendation());
    }

    public final String toString() {
        return ToString.builder((String)"MetricInfo").add("MetricNamespace", (Object)this.metricNamespace()).add("MetricName", (Object)this.metricName()).add("MetricDimensions", this.hasMetricDimensions() ? this.metricDimensions() : null).add("MetricStatisticRecommendation", (Object)this.metricStatisticRecommendation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricNamespace": {
                return Optional.ofNullable(clazz.cast(this.metricNamespace()));
            }
            case "MetricName": {
                return Optional.ofNullable(clazz.cast(this.metricName()));
            }
            case "MetricDimensions": {
                return Optional.ofNullable(clazz.cast(this.metricDimensions()));
            }
            case "MetricStatisticRecommendation": {
                return Optional.ofNullable(clazz.cast(this.metricStatisticRecommendation()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MetricNamespace", METRIC_NAMESPACE_FIELD);
        map.put("MetricName", METRIC_NAME_FIELD);
        map.put("MetricDimensions", METRIC_DIMENSIONS_FIELD);
        map.put("MetricStatisticRecommendation", METRIC_STATISTIC_RECOMMENDATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricInfo, T> g) {
        return obj -> g.apply((MetricInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String metricNamespace;
        private String metricName;
        private Map<String, String> metricDimensions = DefaultSdkAutoConstructMap.getInstance();
        private String metricStatisticRecommendation;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricInfo model) {
            this.metricNamespace(model.metricNamespace);
            this.metricName(model.metricName);
            this.metricDimensions(model.metricDimensions);
            this.metricStatisticRecommendation(model.metricStatisticRecommendation);
        }

        public final String getMetricNamespace() {
            return this.metricNamespace;
        }

        public final void setMetricNamespace(String metricNamespace) {
            this.metricNamespace = metricNamespace;
        }

        @Override
        public final Builder metricNamespace(String metricNamespace) {
            this.metricNamespace = metricNamespace;
            return this;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final Map<String, String> getMetricDimensions() {
            if (this.metricDimensions instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.metricDimensions;
        }

        public final void setMetricDimensions(Map<String, String> metricDimensions) {
            this.metricDimensions = MetricDimensionsMapDefinitionCopier.copy(metricDimensions);
        }

        @Override
        public final Builder metricDimensions(Map<String, String> metricDimensions) {
            this.metricDimensions = MetricDimensionsMapDefinitionCopier.copy(metricDimensions);
            return this;
        }

        public final String getMetricStatisticRecommendation() {
            return this.metricStatisticRecommendation;
        }

        public final void setMetricStatisticRecommendation(String metricStatisticRecommendation) {
            this.metricStatisticRecommendation = metricStatisticRecommendation;
        }

        @Override
        public final Builder metricStatisticRecommendation(String metricStatisticRecommendation) {
            this.metricStatisticRecommendation = metricStatisticRecommendation;
            return this;
        }

        public MetricInfo build() {
            return new MetricInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricInfo> {
        public Builder metricNamespace(String var1);

        public Builder metricName(String var1);

        public Builder metricDimensions(Map<String, String> var1);

        public Builder metricStatisticRecommendation(String var1);
    }
}

