/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicequotas.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the CloudWatch metric that reflects quota usage.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MetricInfo implements SdkPojo, Serializable, ToCopyableBuilder<MetricInfo.Builder, MetricInfo> {
    private static final SdkField<String> METRIC_NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricNamespace").getter(getter(MetricInfo::metricNamespace)).setter(setter(Builder::metricNamespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricNamespace").build()).build();

    private static final SdkField<String> METRIC_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricName").getter(getter(MetricInfo::metricName)).setter(setter(Builder::metricName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricName").build()).build();

    private static final SdkField<Map<String, String>> METRIC_DIMENSIONS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("MetricDimensions")
            .getter(getter(MetricInfo::metricDimensions))
            .setter(setter(Builder::metricDimensions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricDimensions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> METRIC_STATISTIC_RECOMMENDATION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("MetricStatisticRecommendation")
            .getter(getter(MetricInfo::metricStatisticRecommendation))
            .setter(setter(Builder::metricStatisticRecommendation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricStatisticRecommendation")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_NAMESPACE_FIELD,
            METRIC_NAME_FIELD, METRIC_DIMENSIONS_FIELD, METRIC_STATISTIC_RECOMMENDATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String metricNamespace;

    private final String metricName;

    private final Map<String, String> metricDimensions;

    private final String metricStatisticRecommendation;

    private MetricInfo(BuilderImpl builder) {
        this.metricNamespace = builder.metricNamespace;
        this.metricName = builder.metricName;
        this.metricDimensions = builder.metricDimensions;
        this.metricStatisticRecommendation = builder.metricStatisticRecommendation;
    }

    /**
     * <p>
     * The namespace of the metric.
     * </p>
     * 
     * @return The namespace of the metric.
     */
    public final String metricNamespace() {
        return metricNamespace;
    }

    /**
     * <p>
     * The name of the metric.
     * </p>
     * 
     * @return The name of the metric.
     */
    public final String metricName() {
        return metricName;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetricDimensions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetricDimensions() {
        return metricDimensions != null && !(metricDimensions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The metric dimension. This is a name/value pair that is part of the identity of a metric.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetricDimensions} method.
     * </p>
     * 
     * @return The metric dimension. This is a name/value pair that is part of the identity of a metric.
     */
    public final Map<String, String> metricDimensions() {
        return metricDimensions;
    }

    /**
     * <p>
     * The metric statistic that we recommend you use when determining quota usage.
     * </p>
     * 
     * @return The metric statistic that we recommend you use when determining quota usage.
     */
    public final String metricStatisticRecommendation() {
        return metricStatisticRecommendation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metricNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(metricName());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetricDimensions() ? metricDimensions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(metricStatisticRecommendation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricInfo)) {
            return false;
        }
        MetricInfo other = (MetricInfo) obj;
        return Objects.equals(metricNamespace(), other.metricNamespace()) && Objects.equals(metricName(), other.metricName())
                && hasMetricDimensions() == other.hasMetricDimensions()
                && Objects.equals(metricDimensions(), other.metricDimensions())
                && Objects.equals(metricStatisticRecommendation(), other.metricStatisticRecommendation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MetricInfo").add("MetricNamespace", metricNamespace()).add("MetricName", metricName())
                .add("MetricDimensions", hasMetricDimensions() ? metricDimensions() : null)
                .add("MetricStatisticRecommendation", metricStatisticRecommendation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricNamespace":
            return Optional.ofNullable(clazz.cast(metricNamespace()));
        case "MetricName":
            return Optional.ofNullable(clazz.cast(metricName()));
        case "MetricDimensions":
            return Optional.ofNullable(clazz.cast(metricDimensions()));
        case "MetricStatisticRecommendation":
            return Optional.ofNullable(clazz.cast(metricStatisticRecommendation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("MetricNamespace", METRIC_NAMESPACE_FIELD);
        map.put("MetricName", METRIC_NAME_FIELD);
        map.put("MetricDimensions", METRIC_DIMENSIONS_FIELD);
        map.put("MetricStatisticRecommendation", METRIC_STATISTIC_RECOMMENDATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MetricInfo, T> g) {
        return obj -> g.apply((MetricInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MetricInfo> {
        /**
         * <p>
         * The namespace of the metric.
         * </p>
         * 
         * @param metricNamespace
         *        The namespace of the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricNamespace(String metricNamespace);

        /**
         * <p>
         * The name of the metric.
         * </p>
         * 
         * @param metricName
         *        The name of the metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricName(String metricName);

        /**
         * <p>
         * The metric dimension. This is a name/value pair that is part of the identity of a metric.
         * </p>
         * 
         * @param metricDimensions
         *        The metric dimension. This is a name/value pair that is part of the identity of a metric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricDimensions(Map<String, String> metricDimensions);

        /**
         * <p>
         * The metric statistic that we recommend you use when determining quota usage.
         * </p>
         * 
         * @param metricStatisticRecommendation
         *        The metric statistic that we recommend you use when determining quota usage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metricStatisticRecommendation(String metricStatisticRecommendation);
    }

    static final class BuilderImpl implements Builder {
        private String metricNamespace;

        private String metricName;

        private Map<String, String> metricDimensions = DefaultSdkAutoConstructMap.getInstance();

        private String metricStatisticRecommendation;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricInfo model) {
            metricNamespace(model.metricNamespace);
            metricName(model.metricName);
            metricDimensions(model.metricDimensions);
            metricStatisticRecommendation(model.metricStatisticRecommendation);
        }

        public final String getMetricNamespace() {
            return metricNamespace;
        }

        public final void setMetricNamespace(String metricNamespace) {
            this.metricNamespace = metricNamespace;
        }

        @Override
        public final Builder metricNamespace(String metricNamespace) {
            this.metricNamespace = metricNamespace;
            return this;
        }

        public final String getMetricName() {
            return metricName;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final Map<String, String> getMetricDimensions() {
            if (metricDimensions instanceof SdkAutoConstructMap) {
                return null;
            }
            return metricDimensions;
        }

        public final void setMetricDimensions(Map<String, String> metricDimensions) {
            this.metricDimensions = MetricDimensionsMapDefinitionCopier.copy(metricDimensions);
        }

        @Override
        public final Builder metricDimensions(Map<String, String> metricDimensions) {
            this.metricDimensions = MetricDimensionsMapDefinitionCopier.copy(metricDimensions);
            return this;
        }

        public final String getMetricStatisticRecommendation() {
            return metricStatisticRecommendation;
        }

        public final void setMetricStatisticRecommendation(String metricStatisticRecommendation) {
            this.metricStatisticRecommendation = metricStatisticRecommendation;
        }

        @Override
        public final Builder metricStatisticRecommendation(String metricStatisticRecommendation) {
            this.metricStatisticRecommendation = metricStatisticRecommendation;
            return this;
        }

        @Override
        public MetricInfo build() {
            return new MetricInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
