/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicequotas;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.servicequotas.model.AssociateServiceQuotaTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.AssociateServiceQuotaTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.DeleteServiceQuotaIncreaseRequestFromTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.DeleteServiceQuotaIncreaseRequestFromTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.DisassociateServiceQuotaTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.DisassociateServiceQuotaTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.GetAssociationForServiceQuotaTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.GetAssociationForServiceQuotaTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.GetAwsDefaultServiceQuotaRequest;
import software.amazon.awssdk.services.servicequotas.model.GetAwsDefaultServiceQuotaResponse;
import software.amazon.awssdk.services.servicequotas.model.GetRequestedServiceQuotaChangeRequest;
import software.amazon.awssdk.services.servicequotas.model.GetRequestedServiceQuotaChangeResponse;
import software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaIncreaseRequestFromTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaIncreaseRequestFromTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaRequest;
import software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaResponse;
import software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasRequest;
import software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasResponse;
import software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest;
import software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaResponse;
import software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest;
import software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryResponse;
import software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasRequest;
import software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasResponse;
import software.amazon.awssdk.services.servicequotas.model.ListServicesRequest;
import software.amazon.awssdk.services.servicequotas.model.ListServicesResponse;
import software.amazon.awssdk.services.servicequotas.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.servicequotas.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.RequestServiceQuotaIncreaseRequest;
import software.amazon.awssdk.services.servicequotas.model.RequestServiceQuotaIncreaseResponse;
import software.amazon.awssdk.services.servicequotas.model.TagResourceRequest;
import software.amazon.awssdk.services.servicequotas.model.TagResourceResponse;
import software.amazon.awssdk.services.servicequotas.model.UntagResourceRequest;
import software.amazon.awssdk.services.servicequotas.model.UntagResourceResponse;
import software.amazon.awssdk.services.servicequotas.paginators.ListAWSDefaultServiceQuotasPublisher;
import software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryByQuotaPublisher;
import software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryPublisher;
import software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotaIncreaseRequestsInTemplatePublisher;
import software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotasPublisher;
import software.amazon.awssdk.services.servicequotas.paginators.ListServicesPublisher;

/**
 * Service client for accessing Service Quotas asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@link SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * With Service Quotas, you can view and manage your quotas easily as your Amazon Web Services workloads grow. Quotas,
 * also referred to as limits, are the maximum number of resources that you can create in your Amazon Web Services
 * account. For more information, see the <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/">Service
 * Quotas User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ServiceQuotasAsyncClient extends AwsClient {
    String SERVICE_NAME = "servicequotas";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "servicequotas";

    /**
     * <p>
     * Associates your quota request template with your organization. When a new Amazon Web Services account is created
     * in your organization, the quota increase requests in the template are automatically applied to the account. You
     * can add a quota increase request for any adjustable quota to your template.
     * </p>
     *
     * @param associateServiceQuotaTemplateRequest
     * @return A Java Future containing the result of the AssociateServiceQuotaTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DependencyAccessDeniedException You can't perform this action because a dependency does not have
     *         access.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>AwsServiceAccessNotEnabledException The action you attempted is not allowed unless Service Access
     *         with Service Quotas is enabled in your organization.</li>
     *         <li>OrganizationNotInAllFeaturesModeException The organization that your Amazon Web Services account
     *         belongs to is not in All Features mode.</li>
     *         <li>TemplatesNotAvailableInRegionException The Service Quotas template is not available in this Amazon
     *         Web Services Region.</li>
     *         <li>NoAvailableOrganizationException The Amazon Web Services account making this call is not a member of
     *         an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.AssociateServiceQuotaTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/AssociateServiceQuotaTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateServiceQuotaTemplateResponse> associateServiceQuotaTemplate(
            AssociateServiceQuotaTemplateRequest associateServiceQuotaTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates your quota request template with your organization. When a new Amazon Web Services account is created
     * in your organization, the quota increase requests in the template are automatically applied to the account. You
     * can add a quota increase request for any adjustable quota to your template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateServiceQuotaTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateServiceQuotaTemplateRequest#builder()}
     * </p>
     *
     * @param associateServiceQuotaTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.AssociateServiceQuotaTemplateRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the AssociateServiceQuotaTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DependencyAccessDeniedException You can't perform this action because a dependency does not have
     *         access.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>AwsServiceAccessNotEnabledException The action you attempted is not allowed unless Service Access
     *         with Service Quotas is enabled in your organization.</li>
     *         <li>OrganizationNotInAllFeaturesModeException The organization that your Amazon Web Services account
     *         belongs to is not in All Features mode.</li>
     *         <li>TemplatesNotAvailableInRegionException The Service Quotas template is not available in this Amazon
     *         Web Services Region.</li>
     *         <li>NoAvailableOrganizationException The Amazon Web Services account making this call is not a member of
     *         an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.AssociateServiceQuotaTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/AssociateServiceQuotaTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AssociateServiceQuotaTemplateResponse> associateServiceQuotaTemplate(
            Consumer<AssociateServiceQuotaTemplateRequest.Builder> associateServiceQuotaTemplateRequest) {
        return associateServiceQuotaTemplate(AssociateServiceQuotaTemplateRequest.builder()
                .applyMutation(associateServiceQuotaTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes the quota increase request for the specified quota from your quota request template.
     * </p>
     *
     * @param deleteServiceQuotaIncreaseRequestFromTemplateRequest
     * @return A Java Future containing the result of the DeleteServiceQuotaIncreaseRequestFromTemplate operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>DependencyAccessDeniedException You can't perform this action because a dependency does not have
     *         access.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>AwsServiceAccessNotEnabledException The action you attempted is not allowed unless Service Access
     *         with Service Quotas is enabled in your organization.</li>
     *         <li>TemplatesNotAvailableInRegionException The Service Quotas template is not available in this Amazon
     *         Web Services Region.</li>
     *         <li>NoAvailableOrganizationException The Amazon Web Services account making this call is not a member of
     *         an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.DeleteServiceQuotaIncreaseRequestFromTemplate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/DeleteServiceQuotaIncreaseRequestFromTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteServiceQuotaIncreaseRequestFromTemplateResponse> deleteServiceQuotaIncreaseRequestFromTemplate(
            DeleteServiceQuotaIncreaseRequestFromTemplateRequest deleteServiceQuotaIncreaseRequestFromTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the quota increase request for the specified quota from your quota request template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteServiceQuotaIncreaseRequestFromTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteServiceQuotaIncreaseRequestFromTemplateRequest#builder()}
     * </p>
     *
     * @param deleteServiceQuotaIncreaseRequestFromTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.DeleteServiceQuotaIncreaseRequestFromTemplateRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteServiceQuotaIncreaseRequestFromTemplate operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>DependencyAccessDeniedException You can't perform this action because a dependency does not have
     *         access.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>AwsServiceAccessNotEnabledException The action you attempted is not allowed unless Service Access
     *         with Service Quotas is enabled in your organization.</li>
     *         <li>TemplatesNotAvailableInRegionException The Service Quotas template is not available in this Amazon
     *         Web Services Region.</li>
     *         <li>NoAvailableOrganizationException The Amazon Web Services account making this call is not a member of
     *         an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.DeleteServiceQuotaIncreaseRequestFromTemplate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/DeleteServiceQuotaIncreaseRequestFromTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteServiceQuotaIncreaseRequestFromTemplateResponse> deleteServiceQuotaIncreaseRequestFromTemplate(
            Consumer<DeleteServiceQuotaIncreaseRequestFromTemplateRequest.Builder> deleteServiceQuotaIncreaseRequestFromTemplateRequest) {
        return deleteServiceQuotaIncreaseRequestFromTemplate(DeleteServiceQuotaIncreaseRequestFromTemplateRequest.builder()
                .applyMutation(deleteServiceQuotaIncreaseRequestFromTemplateRequest).build());
    }

    /**
     * <p>
     * Disables your quota request template. After a template is disabled, the quota increase requests in the template
     * are not applied to new Amazon Web Services accounts in your organization. Disabling a quota request template does
     * not apply its quota increase requests.
     * </p>
     *
     * @param disassociateServiceQuotaTemplateRequest
     * @return A Java Future containing the result of the DisassociateServiceQuotaTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DependencyAccessDeniedException You can't perform this action because a dependency does not have
     *         access.</li>
     *         <li>ServiceQuotaTemplateNotInUseException The quota request template is not associated with your
     *         organization.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>AwsServiceAccessNotEnabledException The action you attempted is not allowed unless Service Access
     *         with Service Quotas is enabled in your organization.</li>
     *         <li>TemplatesNotAvailableInRegionException The Service Quotas template is not available in this Amazon
     *         Web Services Region.</li>
     *         <li>NoAvailableOrganizationException The Amazon Web Services account making this call is not a member of
     *         an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.DisassociateServiceQuotaTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/DisassociateServiceQuotaTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateServiceQuotaTemplateResponse> disassociateServiceQuotaTemplate(
            DisassociateServiceQuotaTemplateRequest disassociateServiceQuotaTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables your quota request template. After a template is disabled, the quota increase requests in the template
     * are not applied to new Amazon Web Services accounts in your organization. Disabling a quota request template does
     * not apply its quota increase requests.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateServiceQuotaTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateServiceQuotaTemplateRequest#builder()}
     * </p>
     *
     * @param disassociateServiceQuotaTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.DisassociateServiceQuotaTemplateRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DisassociateServiceQuotaTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DependencyAccessDeniedException You can't perform this action because a dependency does not have
     *         access.</li>
     *         <li>ServiceQuotaTemplateNotInUseException The quota request template is not associated with your
     *         organization.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>AwsServiceAccessNotEnabledException The action you attempted is not allowed unless Service Access
     *         with Service Quotas is enabled in your organization.</li>
     *         <li>TemplatesNotAvailableInRegionException The Service Quotas template is not available in this Amazon
     *         Web Services Region.</li>
     *         <li>NoAvailableOrganizationException The Amazon Web Services account making this call is not a member of
     *         an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.DisassociateServiceQuotaTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/DisassociateServiceQuotaTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DisassociateServiceQuotaTemplateResponse> disassociateServiceQuotaTemplate(
            Consumer<DisassociateServiceQuotaTemplateRequest.Builder> disassociateServiceQuotaTemplateRequest) {
        return disassociateServiceQuotaTemplate(DisassociateServiceQuotaTemplateRequest.builder()
                .applyMutation(disassociateServiceQuotaTemplateRequest).build());
    }

    /**
     * <p>
     * Retrieves the default value for the specified quota. The default value does not reflect any quota increases.
     * </p>
     *
     * @param getAwsDefaultServiceQuotaRequest
     * @return A Java Future containing the result of the GetAWSDefaultServiceQuota operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.GetAWSDefaultServiceQuota
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetAWSDefaultServiceQuota"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAwsDefaultServiceQuotaResponse> getAWSDefaultServiceQuota(
            GetAwsDefaultServiceQuotaRequest getAwsDefaultServiceQuotaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the default value for the specified quota. The default value does not reflect any quota increases.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAwsDefaultServiceQuotaRequest.Builder} avoiding
     * the need to create one manually via {@link GetAwsDefaultServiceQuotaRequest#builder()}
     * </p>
     *
     * @param getAwsDefaultServiceQuotaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.GetAwsDefaultServiceQuotaRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetAWSDefaultServiceQuota operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.GetAWSDefaultServiceQuota
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetAWSDefaultServiceQuota"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAwsDefaultServiceQuotaResponse> getAWSDefaultServiceQuota(
            Consumer<GetAwsDefaultServiceQuotaRequest.Builder> getAwsDefaultServiceQuotaRequest) {
        return getAWSDefaultServiceQuota(GetAwsDefaultServiceQuotaRequest.builder()
                .applyMutation(getAwsDefaultServiceQuotaRequest).build());
    }

    /**
     * <p>
     * Retrieves the status of the association for the quota request template.
     * </p>
     *
     * @param getAssociationForServiceQuotaTemplateRequest
     * @return A Java Future containing the result of the GetAssociationForServiceQuotaTemplate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DependencyAccessDeniedException You can't perform this action because a dependency does not have
     *         access.</li>
     *         <li>ServiceQuotaTemplateNotInUseException The quota request template is not associated with your
     *         organization.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>AwsServiceAccessNotEnabledException The action you attempted is not allowed unless Service Access
     *         with Service Quotas is enabled in your organization.</li>
     *         <li>TemplatesNotAvailableInRegionException The Service Quotas template is not available in this Amazon
     *         Web Services Region.</li>
     *         <li>NoAvailableOrganizationException The Amazon Web Services account making this call is not a member of
     *         an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.GetAssociationForServiceQuotaTemplate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetAssociationForServiceQuotaTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAssociationForServiceQuotaTemplateResponse> getAssociationForServiceQuotaTemplate(
            GetAssociationForServiceQuotaTemplateRequest getAssociationForServiceQuotaTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the status of the association for the quota request template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetAssociationForServiceQuotaTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link GetAssociationForServiceQuotaTemplateRequest#builder()}
     * </p>
     *
     * @param getAssociationForServiceQuotaTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.GetAssociationForServiceQuotaTemplateRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetAssociationForServiceQuotaTemplate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DependencyAccessDeniedException You can't perform this action because a dependency does not have
     *         access.</li>
     *         <li>ServiceQuotaTemplateNotInUseException The quota request template is not associated with your
     *         organization.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>AwsServiceAccessNotEnabledException The action you attempted is not allowed unless Service Access
     *         with Service Quotas is enabled in your organization.</li>
     *         <li>TemplatesNotAvailableInRegionException The Service Quotas template is not available in this Amazon
     *         Web Services Region.</li>
     *         <li>NoAvailableOrganizationException The Amazon Web Services account making this call is not a member of
     *         an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.GetAssociationForServiceQuotaTemplate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetAssociationForServiceQuotaTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAssociationForServiceQuotaTemplateResponse> getAssociationForServiceQuotaTemplate(
            Consumer<GetAssociationForServiceQuotaTemplateRequest.Builder> getAssociationForServiceQuotaTemplateRequest) {
        return getAssociationForServiceQuotaTemplate(GetAssociationForServiceQuotaTemplateRequest.builder()
                .applyMutation(getAssociationForServiceQuotaTemplateRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified quota increase request.
     * </p>
     *
     * @param getRequestedServiceQuotaChangeRequest
     * @return A Java Future containing the result of the GetRequestedServiceQuotaChange operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.GetRequestedServiceQuotaChange
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetRequestedServiceQuotaChange"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRequestedServiceQuotaChangeResponse> getRequestedServiceQuotaChange(
            GetRequestedServiceQuotaChangeRequest getRequestedServiceQuotaChangeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified quota increase request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRequestedServiceQuotaChangeRequest.Builder}
     * avoiding the need to create one manually via {@link GetRequestedServiceQuotaChangeRequest#builder()}
     * </p>
     *
     * @param getRequestedServiceQuotaChangeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.GetRequestedServiceQuotaChangeRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetRequestedServiceQuotaChange operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.GetRequestedServiceQuotaChange
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetRequestedServiceQuotaChange"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetRequestedServiceQuotaChangeResponse> getRequestedServiceQuotaChange(
            Consumer<GetRequestedServiceQuotaChangeRequest.Builder> getRequestedServiceQuotaChangeRequest) {
        return getRequestedServiceQuotaChange(GetRequestedServiceQuotaChangeRequest.builder()
                .applyMutation(getRequestedServiceQuotaChangeRequest).build());
    }

    /**
     * <p>
     * Retrieves the applied quota value for the specified quota. For some quotas, only the default values are
     * available. If the applied quota value is not available for a quota, the quota is not retrieved.
     * </p>
     *
     * @param getServiceQuotaRequest
     * @return A Java Future containing the result of the GetServiceQuota operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.GetServiceQuota
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetServiceQuota"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceQuotaResponse> getServiceQuota(GetServiceQuotaRequest getServiceQuotaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the applied quota value for the specified quota. For some quotas, only the default values are
     * available. If the applied quota value is not available for a quota, the quota is not retrieved.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceQuotaRequest.Builder} avoiding the need
     * to create one manually via {@link GetServiceQuotaRequest#builder()}
     * </p>
     *
     * @param getServiceQuotaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetServiceQuota operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.GetServiceQuota
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetServiceQuota"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceQuotaResponse> getServiceQuota(
            Consumer<GetServiceQuotaRequest.Builder> getServiceQuotaRequest) {
        return getServiceQuota(GetServiceQuotaRequest.builder().applyMutation(getServiceQuotaRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified quota increase request in your quota request template.
     * </p>
     *
     * @param getServiceQuotaIncreaseRequestFromTemplateRequest
     * @return A Java Future containing the result of the GetServiceQuotaIncreaseRequestFromTemplate operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>DependencyAccessDeniedException You can't perform this action because a dependency does not have
     *         access.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>AwsServiceAccessNotEnabledException The action you attempted is not allowed unless Service Access
     *         with Service Quotas is enabled in your organization.</li>
     *         <li>TemplatesNotAvailableInRegionException The Service Quotas template is not available in this Amazon
     *         Web Services Region.</li>
     *         <li>NoAvailableOrganizationException The Amazon Web Services account making this call is not a member of
     *         an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.GetServiceQuotaIncreaseRequestFromTemplate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetServiceQuotaIncreaseRequestFromTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceQuotaIncreaseRequestFromTemplateResponse> getServiceQuotaIncreaseRequestFromTemplate(
            GetServiceQuotaIncreaseRequestFromTemplateRequest getServiceQuotaIncreaseRequestFromTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified quota increase request in your quota request template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetServiceQuotaIncreaseRequestFromTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link GetServiceQuotaIncreaseRequestFromTemplateRequest#builder()}
     * </p>
     *
     * @param getServiceQuotaIncreaseRequestFromTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaIncreaseRequestFromTemplateRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the GetServiceQuotaIncreaseRequestFromTemplate operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>DependencyAccessDeniedException You can't perform this action because a dependency does not have
     *         access.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>AwsServiceAccessNotEnabledException The action you attempted is not allowed unless Service Access
     *         with Service Quotas is enabled in your organization.</li>
     *         <li>TemplatesNotAvailableInRegionException The Service Quotas template is not available in this Amazon
     *         Web Services Region.</li>
     *         <li>NoAvailableOrganizationException The Amazon Web Services account making this call is not a member of
     *         an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.GetServiceQuotaIncreaseRequestFromTemplate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetServiceQuotaIncreaseRequestFromTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetServiceQuotaIncreaseRequestFromTemplateResponse> getServiceQuotaIncreaseRequestFromTemplate(
            Consumer<GetServiceQuotaIncreaseRequestFromTemplateRequest.Builder> getServiceQuotaIncreaseRequestFromTemplateRequest) {
        return getServiceQuotaIncreaseRequestFromTemplate(GetServiceQuotaIncreaseRequestFromTemplateRequest.builder()
                .applyMutation(getServiceQuotaIncreaseRequestFromTemplateRequest).build());
    }

    /**
     * <p>
     * Lists the default values for the quotas for the specified Amazon Web Service. A default value does not reflect
     * any quota increases.
     * </p>
     *
     * @param listAwsDefaultServiceQuotasRequest
     * @return A Java Future containing the result of the ListAWSDefaultServiceQuotas operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListAWSDefaultServiceQuotas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListAWSDefaultServiceQuotas"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAwsDefaultServiceQuotasResponse> listAWSDefaultServiceQuotas(
            ListAwsDefaultServiceQuotasRequest listAwsDefaultServiceQuotasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the default values for the quotas for the specified Amazon Web Service. A default value does not reflect
     * any quota increases.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAwsDefaultServiceQuotasRequest.Builder}
     * avoiding the need to create one manually via {@link ListAwsDefaultServiceQuotasRequest#builder()}
     * </p>
     *
     * @param listAwsDefaultServiceQuotasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListAWSDefaultServiceQuotas operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListAWSDefaultServiceQuotas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListAWSDefaultServiceQuotas"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAwsDefaultServiceQuotasResponse> listAWSDefaultServiceQuotas(
            Consumer<ListAwsDefaultServiceQuotasRequest.Builder> listAwsDefaultServiceQuotasRequest) {
        return listAWSDefaultServiceQuotas(ListAwsDefaultServiceQuotasRequest.builder()
                .applyMutation(listAwsDefaultServiceQuotasRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAWSDefaultServiceQuotas(software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListAWSDefaultServiceQuotasPublisher publisher = client.listAWSDefaultServiceQuotasPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListAWSDefaultServiceQuotasPublisher publisher = client.listAWSDefaultServiceQuotasPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAWSDefaultServiceQuotas(software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAwsDefaultServiceQuotasRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListAWSDefaultServiceQuotas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListAWSDefaultServiceQuotas"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAWSDefaultServiceQuotasPublisher listAWSDefaultServiceQuotasPaginator(
            ListAwsDefaultServiceQuotasRequest listAwsDefaultServiceQuotasRequest) {
        return new ListAWSDefaultServiceQuotasPublisher(this, listAwsDefaultServiceQuotasRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAWSDefaultServiceQuotas(software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListAWSDefaultServiceQuotasPublisher publisher = client.listAWSDefaultServiceQuotasPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListAWSDefaultServiceQuotasPublisher publisher = client.listAWSDefaultServiceQuotasPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAWSDefaultServiceQuotas(software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAwsDefaultServiceQuotasRequest.Builder}
     * avoiding the need to create one manually via {@link ListAwsDefaultServiceQuotasRequest#builder()}
     * </p>
     *
     * @param listAwsDefaultServiceQuotasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListAWSDefaultServiceQuotas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListAWSDefaultServiceQuotas"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAWSDefaultServiceQuotasPublisher listAWSDefaultServiceQuotasPaginator(
            Consumer<ListAwsDefaultServiceQuotasRequest.Builder> listAwsDefaultServiceQuotasRequest) {
        return listAWSDefaultServiceQuotasPaginator(ListAwsDefaultServiceQuotasRequest.builder()
                .applyMutation(listAwsDefaultServiceQuotasRequest).build());
    }

    /**
     * <p>
     * Retrieves the quota increase requests for the specified Amazon Web Service.
     * </p>
     *
     * @param listRequestedServiceQuotaChangeHistoryRequest
     * @return A Java Future containing the result of the ListRequestedServiceQuotaChangeHistory operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListRequestedServiceQuotaChangeHistory
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListRequestedServiceQuotaChangeHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRequestedServiceQuotaChangeHistoryResponse> listRequestedServiceQuotaChangeHistory(
            ListRequestedServiceQuotaChangeHistoryRequest listRequestedServiceQuotaChangeHistoryRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the quota increase requests for the specified Amazon Web Service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListRequestedServiceQuotaChangeHistoryRequest.Builder} avoiding the need to create one manually via
     * {@link ListRequestedServiceQuotaChangeHistoryRequest#builder()}
     * </p>
     *
     * @param listRequestedServiceQuotaChangeHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListRequestedServiceQuotaChangeHistory operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListRequestedServiceQuotaChangeHistory
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListRequestedServiceQuotaChangeHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRequestedServiceQuotaChangeHistoryResponse> listRequestedServiceQuotaChangeHistory(
            Consumer<ListRequestedServiceQuotaChangeHistoryRequest.Builder> listRequestedServiceQuotaChangeHistoryRequest) {
        return listRequestedServiceQuotaChangeHistory(ListRequestedServiceQuotaChangeHistoryRequest.builder()
                .applyMutation(listRequestedServiceQuotaChangeHistoryRequest).build());
    }

    /**
     * <p>
     * Retrieves the quota increase requests for the specified quota.
     * </p>
     *
     * @param listRequestedServiceQuotaChangeHistoryByQuotaRequest
     * @return A Java Future containing the result of the ListRequestedServiceQuotaChangeHistoryByQuota operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListRequestedServiceQuotaChangeHistoryByQuota
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListRequestedServiceQuotaChangeHistoryByQuota"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRequestedServiceQuotaChangeHistoryByQuotaResponse> listRequestedServiceQuotaChangeHistoryByQuota(
            ListRequestedServiceQuotaChangeHistoryByQuotaRequest listRequestedServiceQuotaChangeHistoryByQuotaRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the quota increase requests for the specified quota.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListRequestedServiceQuotaChangeHistoryByQuotaRequest.Builder} avoiding the need to create one manually via
     * {@link ListRequestedServiceQuotaChangeHistoryByQuotaRequest#builder()}
     * </p>
     *
     * @param listRequestedServiceQuotaChangeHistoryByQuotaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListRequestedServiceQuotaChangeHistoryByQuota operation
     *         returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListRequestedServiceQuotaChangeHistoryByQuota
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListRequestedServiceQuotaChangeHistoryByQuota"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListRequestedServiceQuotaChangeHistoryByQuotaResponse> listRequestedServiceQuotaChangeHistoryByQuota(
            Consumer<ListRequestedServiceQuotaChangeHistoryByQuotaRequest.Builder> listRequestedServiceQuotaChangeHistoryByQuotaRequest) {
        return listRequestedServiceQuotaChangeHistoryByQuota(ListRequestedServiceQuotaChangeHistoryByQuotaRequest.builder()
                .applyMutation(listRequestedServiceQuotaChangeHistoryByQuotaRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRequestedServiceQuotaChangeHistoryByQuota(software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryByQuotaPublisher publisher = client.listRequestedServiceQuotaChangeHistoryByQuotaPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryByQuotaPublisher publisher = client.listRequestedServiceQuotaChangeHistoryByQuotaPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRequestedServiceQuotaChangeHistoryByQuota(software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRequestedServiceQuotaChangeHistoryByQuotaRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListRequestedServiceQuotaChangeHistoryByQuota
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListRequestedServiceQuotaChangeHistoryByQuota"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRequestedServiceQuotaChangeHistoryByQuotaPublisher listRequestedServiceQuotaChangeHistoryByQuotaPaginator(
            ListRequestedServiceQuotaChangeHistoryByQuotaRequest listRequestedServiceQuotaChangeHistoryByQuotaRequest) {
        return new ListRequestedServiceQuotaChangeHistoryByQuotaPublisher(this,
                listRequestedServiceQuotaChangeHistoryByQuotaRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRequestedServiceQuotaChangeHistoryByQuota(software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryByQuotaPublisher publisher = client.listRequestedServiceQuotaChangeHistoryByQuotaPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryByQuotaPublisher publisher = client.listRequestedServiceQuotaChangeHistoryByQuotaPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRequestedServiceQuotaChangeHistoryByQuota(software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListRequestedServiceQuotaChangeHistoryByQuotaRequest.Builder} avoiding the need to create one manually via
     * {@link ListRequestedServiceQuotaChangeHistoryByQuotaRequest#builder()}
     * </p>
     *
     * @param listRequestedServiceQuotaChangeHistoryByQuotaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListRequestedServiceQuotaChangeHistoryByQuota
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListRequestedServiceQuotaChangeHistoryByQuota"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRequestedServiceQuotaChangeHistoryByQuotaPublisher listRequestedServiceQuotaChangeHistoryByQuotaPaginator(
            Consumer<ListRequestedServiceQuotaChangeHistoryByQuotaRequest.Builder> listRequestedServiceQuotaChangeHistoryByQuotaRequest) {
        return listRequestedServiceQuotaChangeHistoryByQuotaPaginator(ListRequestedServiceQuotaChangeHistoryByQuotaRequest
                .builder().applyMutation(listRequestedServiceQuotaChangeHistoryByQuotaRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRequestedServiceQuotaChangeHistory(software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryPublisher publisher = client.listRequestedServiceQuotaChangeHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryPublisher publisher = client.listRequestedServiceQuotaChangeHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRequestedServiceQuotaChangeHistory(software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRequestedServiceQuotaChangeHistoryRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListRequestedServiceQuotaChangeHistory
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListRequestedServiceQuotaChangeHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRequestedServiceQuotaChangeHistoryPublisher listRequestedServiceQuotaChangeHistoryPaginator(
            ListRequestedServiceQuotaChangeHistoryRequest listRequestedServiceQuotaChangeHistoryRequest) {
        return new ListRequestedServiceQuotaChangeHistoryPublisher(this, listRequestedServiceQuotaChangeHistoryRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listRequestedServiceQuotaChangeHistory(software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryPublisher publisher = client.listRequestedServiceQuotaChangeHistoryPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryPublisher publisher = client.listRequestedServiceQuotaChangeHistoryPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRequestedServiceQuotaChangeHistory(software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListRequestedServiceQuotaChangeHistoryRequest.Builder} avoiding the need to create one manually via
     * {@link ListRequestedServiceQuotaChangeHistoryRequest#builder()}
     * </p>
     *
     * @param listRequestedServiceQuotaChangeHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListRequestedServiceQuotaChangeHistory
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListRequestedServiceQuotaChangeHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRequestedServiceQuotaChangeHistoryPublisher listRequestedServiceQuotaChangeHistoryPaginator(
            Consumer<ListRequestedServiceQuotaChangeHistoryRequest.Builder> listRequestedServiceQuotaChangeHistoryRequest) {
        return listRequestedServiceQuotaChangeHistoryPaginator(ListRequestedServiceQuotaChangeHistoryRequest.builder()
                .applyMutation(listRequestedServiceQuotaChangeHistoryRequest).build());
    }

    /**
     * <p>
     * Lists the quota increase requests in the specified quota request template.
     * </p>
     *
     * @param listServiceQuotaIncreaseRequestsInTemplateRequest
     * @return A Java Future containing the result of the ListServiceQuotaIncreaseRequestsInTemplate operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>DependencyAccessDeniedException You can't perform this action because a dependency does not have
     *         access.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>AwsServiceAccessNotEnabledException The action you attempted is not allowed unless Service Access
     *         with Service Quotas is enabled in your organization.</li>
     *         <li>TemplatesNotAvailableInRegionException The Service Quotas template is not available in this Amazon
     *         Web Services Region.</li>
     *         <li>NoAvailableOrganizationException The Amazon Web Services account making this call is not a member of
     *         an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListServiceQuotaIncreaseRequestsInTemplate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServiceQuotaIncreaseRequestsInTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServiceQuotaIncreaseRequestsInTemplateResponse> listServiceQuotaIncreaseRequestsInTemplate(
            ListServiceQuotaIncreaseRequestsInTemplateRequest listServiceQuotaIncreaseRequestsInTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the quota increase requests in the specified quota request template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListServiceQuotaIncreaseRequestsInTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link ListServiceQuotaIncreaseRequestsInTemplateRequest#builder()}
     * </p>
     *
     * @param listServiceQuotaIncreaseRequestsInTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListServiceQuotaIncreaseRequestsInTemplate operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>DependencyAccessDeniedException You can't perform this action because a dependency does not have
     *         access.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>AwsServiceAccessNotEnabledException The action you attempted is not allowed unless Service Access
     *         with Service Quotas is enabled in your organization.</li>
     *         <li>TemplatesNotAvailableInRegionException The Service Quotas template is not available in this Amazon
     *         Web Services Region.</li>
     *         <li>NoAvailableOrganizationException The Amazon Web Services account making this call is not a member of
     *         an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListServiceQuotaIncreaseRequestsInTemplate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServiceQuotaIncreaseRequestsInTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServiceQuotaIncreaseRequestsInTemplateResponse> listServiceQuotaIncreaseRequestsInTemplate(
            Consumer<ListServiceQuotaIncreaseRequestsInTemplateRequest.Builder> listServiceQuotaIncreaseRequestsInTemplateRequest) {
        return listServiceQuotaIncreaseRequestsInTemplate(ListServiceQuotaIncreaseRequestsInTemplateRequest.builder()
                .applyMutation(listServiceQuotaIncreaseRequestsInTemplateRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceQuotaIncreaseRequestsInTemplate(software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotaIncreaseRequestsInTemplatePublisher publisher = client.listServiceQuotaIncreaseRequestsInTemplatePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotaIncreaseRequestsInTemplatePublisher publisher = client.listServiceQuotaIncreaseRequestsInTemplatePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceQuotaIncreaseRequestsInTemplate(software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceQuotaIncreaseRequestsInTemplateRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>DependencyAccessDeniedException You can't perform this action because a dependency does not have
     *         access.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>AwsServiceAccessNotEnabledException The action you attempted is not allowed unless Service Access
     *         with Service Quotas is enabled in your organization.</li>
     *         <li>TemplatesNotAvailableInRegionException The Service Quotas template is not available in this Amazon
     *         Web Services Region.</li>
     *         <li>NoAvailableOrganizationException The Amazon Web Services account making this call is not a member of
     *         an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListServiceQuotaIncreaseRequestsInTemplate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServiceQuotaIncreaseRequestsInTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceQuotaIncreaseRequestsInTemplatePublisher listServiceQuotaIncreaseRequestsInTemplatePaginator(
            ListServiceQuotaIncreaseRequestsInTemplateRequest listServiceQuotaIncreaseRequestsInTemplateRequest) {
        return new ListServiceQuotaIncreaseRequestsInTemplatePublisher(this, listServiceQuotaIncreaseRequestsInTemplateRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceQuotaIncreaseRequestsInTemplate(software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotaIncreaseRequestsInTemplatePublisher publisher = client.listServiceQuotaIncreaseRequestsInTemplatePaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotaIncreaseRequestsInTemplatePublisher publisher = client.listServiceQuotaIncreaseRequestsInTemplatePaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceQuotaIncreaseRequestsInTemplate(software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListServiceQuotaIncreaseRequestsInTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link ListServiceQuotaIncreaseRequestsInTemplateRequest#builder()}
     * </p>
     *
     * @param listServiceQuotaIncreaseRequestsInTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>DependencyAccessDeniedException You can't perform this action because a dependency does not have
     *         access.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>AwsServiceAccessNotEnabledException The action you attempted is not allowed unless Service Access
     *         with Service Quotas is enabled in your organization.</li>
     *         <li>TemplatesNotAvailableInRegionException The Service Quotas template is not available in this Amazon
     *         Web Services Region.</li>
     *         <li>NoAvailableOrganizationException The Amazon Web Services account making this call is not a member of
     *         an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListServiceQuotaIncreaseRequestsInTemplate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServiceQuotaIncreaseRequestsInTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceQuotaIncreaseRequestsInTemplatePublisher listServiceQuotaIncreaseRequestsInTemplatePaginator(
            Consumer<ListServiceQuotaIncreaseRequestsInTemplateRequest.Builder> listServiceQuotaIncreaseRequestsInTemplateRequest) {
        return listServiceQuotaIncreaseRequestsInTemplatePaginator(ListServiceQuotaIncreaseRequestsInTemplateRequest.builder()
                .applyMutation(listServiceQuotaIncreaseRequestsInTemplateRequest).build());
    }

    /**
     * <p>
     * Lists the applied quota values for the specified Amazon Web Service. For some quotas, only the default values are
     * available. If the applied quota value is not available for a quota, the quota is not retrieved.
     * </p>
     *
     * @param listServiceQuotasRequest
     * @return A Java Future containing the result of the ListServiceQuotas operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListServiceQuotas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServiceQuotas"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServiceQuotasResponse> listServiceQuotas(ListServiceQuotasRequest listServiceQuotasRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the applied quota values for the specified Amazon Web Service. For some quotas, only the default values are
     * available. If the applied quota value is not available for a quota, the quota is not retrieved.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceQuotasRequest.Builder} avoiding the need
     * to create one manually via {@link ListServiceQuotasRequest#builder()}
     * </p>
     *
     * @param listServiceQuotasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListServiceQuotas operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListServiceQuotas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServiceQuotas"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListServiceQuotasResponse> listServiceQuotas(
            Consumer<ListServiceQuotasRequest.Builder> listServiceQuotasRequest) {
        return listServiceQuotas(ListServiceQuotasRequest.builder().applyMutation(listServiceQuotasRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceQuotas(software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotasPublisher publisher = client.listServiceQuotasPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotasPublisher publisher = client.listServiceQuotasPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceQuotas(software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceQuotasRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListServiceQuotas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServiceQuotas"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceQuotasPublisher listServiceQuotasPaginator(ListServiceQuotasRequest listServiceQuotasRequest) {
        return new ListServiceQuotasPublisher(this, listServiceQuotasRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServiceQuotas(software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotasPublisher publisher = client.listServiceQuotasPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotasPublisher publisher = client.listServiceQuotasPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceQuotas(software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceQuotasRequest.Builder} avoiding the need
     * to create one manually via {@link ListServiceQuotasRequest#builder()}
     * </p>
     *
     * @param listServiceQuotasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListServiceQuotas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServiceQuotas"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceQuotasPublisher listServiceQuotasPaginator(
            Consumer<ListServiceQuotasRequest.Builder> listServiceQuotasRequest) {
        return listServiceQuotasPaginator(ListServiceQuotasRequest.builder().applyMutation(listServiceQuotasRequest).build());
    }

    /**
     * <p>
     * Lists the names and codes for the Amazon Web Services integrated with Service Quotas.
     * </p>
     *
     * @param listServicesRequest
     * @return A Java Future containing the result of the ListServices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServices" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListServicesResponse> listServices(ListServicesRequest listServicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the names and codes for the Amazon Web Services integrated with Service Quotas.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListServicesRequest#builder()}
     * </p>
     *
     * @param listServicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.ListServicesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListServices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServices" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListServicesResponse> listServices(Consumer<ListServicesRequest.Builder> listServicesRequest) {
        return listServices(ListServicesRequest.builder().applyMutation(listServicesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServices(software.amazon.awssdk.services.servicequotas.model.ListServicesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListServicesPublisher publisher = client.listServicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListServicesPublisher publisher = client.listServicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicequotas.model.ListServicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicequotas.model.ListServicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServices(software.amazon.awssdk.services.servicequotas.model.ListServicesRequest)} operation.</b>
     * </p>
     *
     * @param listServicesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServices" target="_top">AWS
     *      API Documentation</a>
     */
    default ListServicesPublisher listServicesPaginator(ListServicesRequest listServicesRequest) {
        return new ListServicesPublisher(this, listServicesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listServices(software.amazon.awssdk.services.servicequotas.model.ListServicesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListServicesPublisher publisher = client.listServicesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListServicesPublisher publisher = client.listServicesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.servicequotas.model.ListServicesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.servicequotas.model.ListServicesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServices(software.amazon.awssdk.services.servicequotas.model.ListServicesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListServicesRequest#builder()}
     * </p>
     *
     * @param listServicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.ListServicesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidPaginationTokenException Invalid input was provided.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServices" target="_top">AWS
     *      API Documentation</a>
     */
    default ListServicesPublisher listServicesPaginator(Consumer<ListServicesRequest.Builder> listServicesRequest) {
        return listServicesPaginator(ListServicesRequest.builder().applyMutation(listServicesRequest).build());
    }

    /**
     * <p>
     * Returns a list of the tags assigned to the specified applied quota.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the tags assigned to the specified applied quota.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Adds a quota increase request to your quota request template.
     * </p>
     *
     * @param putServiceQuotaIncreaseRequestIntoTemplateRequest
     * @return A Java Future containing the result of the PutServiceQuotaIncreaseRequestIntoTemplate operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>DependencyAccessDeniedException You can't perform this action because a dependency does not have
     *         access.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>QuotaExceededException You have exceeded your service quota. To perform the requested action, remove
     *         some of the relevant resources, or use Service Quotas to request a service quota increase.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>AwsServiceAccessNotEnabledException The action you attempted is not allowed unless Service Access
     *         with Service Quotas is enabled in your organization.</li>
     *         <li>TemplatesNotAvailableInRegionException The Service Quotas template is not available in this Amazon
     *         Web Services Region.</li>
     *         <li>NoAvailableOrganizationException The Amazon Web Services account making this call is not a member of
     *         an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.PutServiceQuotaIncreaseRequestIntoTemplate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/PutServiceQuotaIncreaseRequestIntoTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutServiceQuotaIncreaseRequestIntoTemplateResponse> putServiceQuotaIncreaseRequestIntoTemplate(
            PutServiceQuotaIncreaseRequestIntoTemplateRequest putServiceQuotaIncreaseRequestIntoTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a quota increase request to your quota request template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutServiceQuotaIncreaseRequestIntoTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link PutServiceQuotaIncreaseRequestIntoTemplateRequest#builder()}
     * </p>
     *
     * @param putServiceQuotaIncreaseRequestIntoTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the PutServiceQuotaIncreaseRequestIntoTemplate operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>DependencyAccessDeniedException You can't perform this action because a dependency does not have
     *         access.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>QuotaExceededException You have exceeded your service quota. To perform the requested action, remove
     *         some of the relevant resources, or use Service Quotas to request a service quota increase.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>AwsServiceAccessNotEnabledException The action you attempted is not allowed unless Service Access
     *         with Service Quotas is enabled in your organization.</li>
     *         <li>TemplatesNotAvailableInRegionException The Service Quotas template is not available in this Amazon
     *         Web Services Region.</li>
     *         <li>NoAvailableOrganizationException The Amazon Web Services account making this call is not a member of
     *         an organization.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.PutServiceQuotaIncreaseRequestIntoTemplate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/PutServiceQuotaIncreaseRequestIntoTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<PutServiceQuotaIncreaseRequestIntoTemplateResponse> putServiceQuotaIncreaseRequestIntoTemplate(
            Consumer<PutServiceQuotaIncreaseRequestIntoTemplateRequest.Builder> putServiceQuotaIncreaseRequestIntoTemplateRequest) {
        return putServiceQuotaIncreaseRequestIntoTemplate(PutServiceQuotaIncreaseRequestIntoTemplateRequest.builder()
                .applyMutation(putServiceQuotaIncreaseRequestIntoTemplateRequest).build());
    }

    /**
     * <p>
     * Submits a quota increase request for the specified quota.
     * </p>
     *
     * @param requestServiceQuotaIncreaseRequest
     * @return A Java Future containing the result of the RequestServiceQuotaIncrease operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DependencyAccessDeniedException You can't perform this action because a dependency does not have
     *         access.</li>
     *         <li>QuotaExceededException You have exceeded your service quota. To perform the requested action, remove
     *         some of the relevant resources, or use Service Quotas to request a service quota increase.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidResourceStateException The resource is in an invalid state.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.RequestServiceQuotaIncrease
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/RequestServiceQuotaIncrease"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RequestServiceQuotaIncreaseResponse> requestServiceQuotaIncrease(
            RequestServiceQuotaIncreaseRequest requestServiceQuotaIncreaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Submits a quota increase request for the specified quota.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RequestServiceQuotaIncreaseRequest.Builder}
     * avoiding the need to create one manually via {@link RequestServiceQuotaIncreaseRequest#builder()}
     * </p>
     *
     * @param requestServiceQuotaIncreaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.RequestServiceQuotaIncreaseRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the RequestServiceQuotaIncrease operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>DependencyAccessDeniedException You can't perform this action because a dependency does not have
     *         access.</li>
     *         <li>QuotaExceededException You have exceeded your service quota. To perform the requested action, remove
     *         some of the relevant resources, or use Service Quotas to request a service quota increase.</li>
     *         <li>ResourceAlreadyExistsException The specified resource already exists.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>InvalidResourceStateException The resource is in an invalid state.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.RequestServiceQuotaIncrease
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/RequestServiceQuotaIncrease"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RequestServiceQuotaIncreaseResponse> requestServiceQuotaIncrease(
            Consumer<RequestServiceQuotaIncreaseRequest.Builder> requestServiceQuotaIncreaseRequest) {
        return requestServiceQuotaIncrease(RequestServiceQuotaIncreaseRequest.builder()
                .applyMutation(requestServiceQuotaIncreaseRequest).build());
    }

    /**
     * <p>
     * Adds tags to the specified applied quota. You can include one or more tags to add to the quota.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>TooManyTagsException You've exceeded the number of tags allowed for a resource. For more information,
     *         see <a href=
     *         "https://docs.aws.amazon.com/servicequotas/latest/userguide/sq-tagging.html#sq-tagging-restrictions">Tag
     *         restrictions</a> in the <i>Service Quotas User Guide</i>.</li>
     *         <li>TagPolicyViolationException The specified tag is a reserved word and cannot be used.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to the specified applied quota. You can include one or more tags to add to the quota.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>TooManyTagsException You've exceeded the number of tags allowed for a resource. For more information,
     *         see <a href=
     *         "https://docs.aws.amazon.com/servicequotas/latest/userguide/sq-tagging.html#sq-tagging-restrictions">Tag
     *         restrictions</a> in the <i>Service Quotas User Guide</i>.</li>
     *         <li>TagPolicyViolationException The specified tag is a reserved word and cannot be used.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from the specified applied quota. You can specify one or more tags to remove.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from the specified applied quota. You can specify one or more tags to remove.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>TooManyRequestsException Due to throttling, the request was denied. Slow down the rate of request
     *         calls, or request an increase for this quota.</li>
     *         <li>NoSuchResourceException The specified resource does not exist.</li>
     *         <li>IllegalArgumentException Invalid input was provided.</li>
     *         <li>AccessDeniedException You do not have sufficient permission to perform this action.</li>
     *         <li>ServiceException Something went wrong.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceQuotasException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample ServiceQuotasAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    @Override
    default ServiceQuotasServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link ServiceQuotasAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ServiceQuotasAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ServiceQuotasAsyncClient}.
     */
    static ServiceQuotasAsyncClientBuilder builder() {
        return new DefaultServiceQuotasAsyncClientBuilder();
    }
}
