/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicequotas.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a quota increase request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RequestedServiceQuotaChange implements SdkPojo, Serializable,
        ToCopyableBuilder<RequestedServiceQuotaChange.Builder, RequestedServiceQuotaChange> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(RequestedServiceQuotaChange::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> CASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("CaseId")
            .getter(getter(RequestedServiceQuotaChange::caseId)).setter(setter(Builder::caseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaseId").build()).build();

    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceCode").getter(getter(RequestedServiceQuotaChange::serviceCode))
            .setter(setter(Builder::serviceCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCode").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceName").getter(getter(RequestedServiceQuotaChange::serviceName))
            .setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()).build();

    private static final SdkField<String> QUOTA_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuotaCode").getter(getter(RequestedServiceQuotaChange::quotaCode)).setter(setter(Builder::quotaCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuotaCode").build()).build();

    private static final SdkField<String> QUOTA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuotaName").getter(getter(RequestedServiceQuotaChange::quotaName)).setter(setter(Builder::quotaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuotaName").build()).build();

    private static final SdkField<Double> DESIRED_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("DesiredValue").getter(getter(RequestedServiceQuotaChange::desiredValue))
            .setter(setter(Builder::desiredValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredValue").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(RequestedServiceQuotaChange::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("Created").getter(getter(RequestedServiceQuotaChange::created)).setter(setter(Builder::created))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Created").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdated").getter(getter(RequestedServiceQuotaChange::lastUpdated))
            .setter(setter(Builder::lastUpdated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdated").build()).build();

    private static final SdkField<String> REQUESTER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Requester").getter(getter(RequestedServiceQuotaChange::requester)).setter(setter(Builder::requester))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Requester").build()).build();

    private static final SdkField<String> QUOTA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuotaArn").getter(getter(RequestedServiceQuotaChange::quotaArn)).setter(setter(Builder::quotaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuotaArn").build()).build();

    private static final SdkField<Boolean> GLOBAL_QUOTA_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("GlobalQuota").getter(getter(RequestedServiceQuotaChange::globalQuota))
            .setter(setter(Builder::globalQuota))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalQuota").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Unit")
            .getter(getter(RequestedServiceQuotaChange::unit)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()).build();

    private static final SdkField<String> QUOTA_REQUESTED_AT_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuotaRequestedAtLevel").getter(getter(RequestedServiceQuotaChange::quotaRequestedAtLevelAsString))
            .setter(setter(Builder::quotaRequestedAtLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuotaRequestedAtLevel").build())
            .build();

    private static final SdkField<QuotaContextInfo> QUOTA_CONTEXT_FIELD = SdkField
            .<QuotaContextInfo> builder(MarshallingType.SDK_POJO).memberName("QuotaContext")
            .getter(getter(RequestedServiceQuotaChange::quotaContext)).setter(setter(Builder::quotaContext))
            .constructor(QuotaContextInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuotaContext").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, CASE_ID_FIELD,
            SERVICE_CODE_FIELD, SERVICE_NAME_FIELD, QUOTA_CODE_FIELD, QUOTA_NAME_FIELD, DESIRED_VALUE_FIELD, STATUS_FIELD,
            CREATED_FIELD, LAST_UPDATED_FIELD, REQUESTER_FIELD, QUOTA_ARN_FIELD, GLOBAL_QUOTA_FIELD, UNIT_FIELD,
            QUOTA_REQUESTED_AT_LEVEL_FIELD, QUOTA_CONTEXT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String caseId;

    private final String serviceCode;

    private final String serviceName;

    private final String quotaCode;

    private final String quotaName;

    private final Double desiredValue;

    private final String status;

    private final Instant created;

    private final Instant lastUpdated;

    private final String requester;

    private final String quotaArn;

    private final Boolean globalQuota;

    private final String unit;

    private final String quotaRequestedAtLevel;

    private final QuotaContextInfo quotaContext;

    private RequestedServiceQuotaChange(BuilderImpl builder) {
        this.id = builder.id;
        this.caseId = builder.caseId;
        this.serviceCode = builder.serviceCode;
        this.serviceName = builder.serviceName;
        this.quotaCode = builder.quotaCode;
        this.quotaName = builder.quotaName;
        this.desiredValue = builder.desiredValue;
        this.status = builder.status;
        this.created = builder.created;
        this.lastUpdated = builder.lastUpdated;
        this.requester = builder.requester;
        this.quotaArn = builder.quotaArn;
        this.globalQuota = builder.globalQuota;
        this.unit = builder.unit;
        this.quotaRequestedAtLevel = builder.quotaRequestedAtLevel;
        this.quotaContext = builder.quotaContext;
    }

    /**
     * <p>
     * The unique identifier.
     * </p>
     * 
     * @return The unique identifier.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The case ID.
     * </p>
     * 
     * @return The case ID.
     */
    public final String caseId() {
        return caseId;
    }

    /**
     * <p>
     * Specifies the service identifier. To find the service code value for an Amazon Web Services service, use the
     * <a>ListServices</a> operation.
     * </p>
     * 
     * @return Specifies the service identifier. To find the service code value for an Amazon Web Services service, use
     *         the <a>ListServices</a> operation.
     */
    public final String serviceCode() {
        return serviceCode;
    }

    /**
     * <p>
     * Specifies the service name.
     * </p>
     * 
     * @return Specifies the service name.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * Specifies the quota identifier. To find the quota code for a specific quota, use the <a>ListServiceQuotas</a>
     * operation, and look for the <code>QuotaCode</code> response in the output for the quota you want.
     * </p>
     * 
     * @return Specifies the quota identifier. To find the quota code for a specific quota, use the
     *         <a>ListServiceQuotas</a> operation, and look for the <code>QuotaCode</code> response in the output for
     *         the quota you want.
     */
    public final String quotaCode() {
        return quotaCode;
    }

    /**
     * <p>
     * Specifies the quota name.
     * </p>
     * 
     * @return Specifies the quota name.
     */
    public final String quotaName() {
        return quotaName;
    }

    /**
     * <p>
     * The new, increased value for the quota.
     * </p>
     * 
     * @return The new, increased value for the quota.
     */
    public final Double desiredValue() {
        return desiredValue;
    }

    /**
     * <p>
     * The state of the quota increase request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RequestStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The state of the quota increase request.
     * @see RequestStatus
     */
    public final RequestStatus status() {
        return RequestStatus.fromValue(status);
    }

    /**
     * <p>
     * The state of the quota increase request.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RequestStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The state of the quota increase request.
     * @see RequestStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time when the quota increase request was received and the case ID was created.
     * </p>
     * 
     * @return The date and time when the quota increase request was received and the case ID was created.
     */
    public final Instant created() {
        return created;
    }

    /**
     * <p>
     * The date and time of the most recent change.
     * </p>
     * 
     * @return The date and time of the most recent change.
     */
    public final Instant lastUpdated() {
        return lastUpdated;
    }

    /**
     * <p>
     * The IAM identity of the requester.
     * </p>
     * 
     * @return The IAM identity of the requester.
     */
    public final String requester() {
        return requester;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the quota.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the quota.
     */
    public final String quotaArn() {
        return quotaArn;
    }

    /**
     * <p>
     * Indicates whether the quota is global.
     * </p>
     * 
     * @return Indicates whether the quota is global.
     */
    public final Boolean globalQuota() {
        return globalQuota;
    }

    /**
     * <p>
     * The unit of measurement.
     * </p>
     * 
     * @return The unit of measurement.
     */
    public final String unit() {
        return unit;
    }

    /**
     * <p>
     * Specifies at which level within the Amazon Web Services account the quota request applies to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #quotaRequestedAtLevel} will return {@link AppliedLevelEnum#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #quotaRequestedAtLevelAsString}.
     * </p>
     * 
     * @return Specifies at which level within the Amazon Web Services account the quota request applies to.
     * @see AppliedLevelEnum
     */
    public final AppliedLevelEnum quotaRequestedAtLevel() {
        return AppliedLevelEnum.fromValue(quotaRequestedAtLevel);
    }

    /**
     * <p>
     * Specifies at which level within the Amazon Web Services account the quota request applies to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #quotaRequestedAtLevel} will return {@link AppliedLevelEnum#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #quotaRequestedAtLevelAsString}.
     * </p>
     * 
     * @return Specifies at which level within the Amazon Web Services account the quota request applies to.
     * @see AppliedLevelEnum
     */
    public final String quotaRequestedAtLevelAsString() {
        return quotaRequestedAtLevel;
    }

    /**
     * <p>
     * The context for this service quota.
     * </p>
     * 
     * @return The context for this service quota.
     */
    public final QuotaContextInfo quotaContext() {
        return quotaContext;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(caseId());
        hashCode = 31 * hashCode + Objects.hashCode(serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(quotaCode());
        hashCode = 31 * hashCode + Objects.hashCode(quotaName());
        hashCode = 31 * hashCode + Objects.hashCode(desiredValue());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(created());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdated());
        hashCode = 31 * hashCode + Objects.hashCode(requester());
        hashCode = 31 * hashCode + Objects.hashCode(quotaArn());
        hashCode = 31 * hashCode + Objects.hashCode(globalQuota());
        hashCode = 31 * hashCode + Objects.hashCode(unit());
        hashCode = 31 * hashCode + Objects.hashCode(quotaRequestedAtLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(quotaContext());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestedServiceQuotaChange)) {
            return false;
        }
        RequestedServiceQuotaChange other = (RequestedServiceQuotaChange) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(caseId(), other.caseId())
                && Objects.equals(serviceCode(), other.serviceCode()) && Objects.equals(serviceName(), other.serviceName())
                && Objects.equals(quotaCode(), other.quotaCode()) && Objects.equals(quotaName(), other.quotaName())
                && Objects.equals(desiredValue(), other.desiredValue())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(created(), other.created())
                && Objects.equals(lastUpdated(), other.lastUpdated()) && Objects.equals(requester(), other.requester())
                && Objects.equals(quotaArn(), other.quotaArn()) && Objects.equals(globalQuota(), other.globalQuota())
                && Objects.equals(unit(), other.unit())
                && Objects.equals(quotaRequestedAtLevelAsString(), other.quotaRequestedAtLevelAsString())
                && Objects.equals(quotaContext(), other.quotaContext());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RequestedServiceQuotaChange").add("Id", id()).add("CaseId", caseId())
                .add("ServiceCode", serviceCode()).add("ServiceName", serviceName()).add("QuotaCode", quotaCode())
                .add("QuotaName", quotaName()).add("DesiredValue", desiredValue()).add("Status", statusAsString())
                .add("Created", created()).add("LastUpdated", lastUpdated()).add("Requester", requester())
                .add("QuotaArn", quotaArn()).add("GlobalQuota", globalQuota()).add("Unit", unit())
                .add("QuotaRequestedAtLevel", quotaRequestedAtLevelAsString()).add("QuotaContext", quotaContext()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "CaseId":
            return Optional.ofNullable(clazz.cast(caseId()));
        case "ServiceCode":
            return Optional.ofNullable(clazz.cast(serviceCode()));
        case "ServiceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "QuotaCode":
            return Optional.ofNullable(clazz.cast(quotaCode()));
        case "QuotaName":
            return Optional.ofNullable(clazz.cast(quotaName()));
        case "DesiredValue":
            return Optional.ofNullable(clazz.cast(desiredValue()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Created":
            return Optional.ofNullable(clazz.cast(created()));
        case "LastUpdated":
            return Optional.ofNullable(clazz.cast(lastUpdated()));
        case "Requester":
            return Optional.ofNullable(clazz.cast(requester()));
        case "QuotaArn":
            return Optional.ofNullable(clazz.cast(quotaArn()));
        case "GlobalQuota":
            return Optional.ofNullable(clazz.cast(globalQuota()));
        case "Unit":
            return Optional.ofNullable(clazz.cast(unit()));
        case "QuotaRequestedAtLevel":
            return Optional.ofNullable(clazz.cast(quotaRequestedAtLevelAsString()));
        case "QuotaContext":
            return Optional.ofNullable(clazz.cast(quotaContext()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RequestedServiceQuotaChange, T> g) {
        return obj -> g.apply((RequestedServiceQuotaChange) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RequestedServiceQuotaChange> {
        /**
         * <p>
         * The unique identifier.
         * </p>
         * 
         * @param id
         *        The unique identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The case ID.
         * </p>
         * 
         * @param caseId
         *        The case ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseId(String caseId);

        /**
         * <p>
         * Specifies the service identifier. To find the service code value for an Amazon Web Services service, use the
         * <a>ListServices</a> operation.
         * </p>
         * 
         * @param serviceCode
         *        Specifies the service identifier. To find the service code value for an Amazon Web Services service,
         *        use the <a>ListServices</a> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCode(String serviceCode);

        /**
         * <p>
         * Specifies the service name.
         * </p>
         * 
         * @param serviceName
         *        Specifies the service name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * Specifies the quota identifier. To find the quota code for a specific quota, use the <a>ListServiceQuotas</a>
         * operation, and look for the <code>QuotaCode</code> response in the output for the quota you want.
         * </p>
         * 
         * @param quotaCode
         *        Specifies the quota identifier. To find the quota code for a specific quota, use the
         *        <a>ListServiceQuotas</a> operation, and look for the <code>QuotaCode</code> response in the output for
         *        the quota you want.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quotaCode(String quotaCode);

        /**
         * <p>
         * Specifies the quota name.
         * </p>
         * 
         * @param quotaName
         *        Specifies the quota name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quotaName(String quotaName);

        /**
         * <p>
         * The new, increased value for the quota.
         * </p>
         * 
         * @param desiredValue
         *        The new, increased value for the quota.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredValue(Double desiredValue);

        /**
         * <p>
         * The state of the quota increase request.
         * </p>
         * 
         * @param status
         *        The state of the quota increase request.
         * @see RequestStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The state of the quota increase request.
         * </p>
         * 
         * @param status
         *        The state of the quota increase request.
         * @see RequestStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RequestStatus
         */
        Builder status(RequestStatus status);

        /**
         * <p>
         * The date and time when the quota increase request was received and the case ID was created.
         * </p>
         * 
         * @param created
         *        The date and time when the quota increase request was received and the case ID was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder created(Instant created);

        /**
         * <p>
         * The date and time of the most recent change.
         * </p>
         * 
         * @param lastUpdated
         *        The date and time of the most recent change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdated(Instant lastUpdated);

        /**
         * <p>
         * The IAM identity of the requester.
         * </p>
         * 
         * @param requester
         *        The IAM identity of the requester.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requester(String requester);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the quota.
         * </p>
         * 
         * @param quotaArn
         *        The Amazon Resource Name (ARN) of the quota.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quotaArn(String quotaArn);

        /**
         * <p>
         * Indicates whether the quota is global.
         * </p>
         * 
         * @param globalQuota
         *        Indicates whether the quota is global.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalQuota(Boolean globalQuota);

        /**
         * <p>
         * The unit of measurement.
         * </p>
         * 
         * @param unit
         *        The unit of measurement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unit(String unit);

        /**
         * <p>
         * Specifies at which level within the Amazon Web Services account the quota request applies to.
         * </p>
         * 
         * @param quotaRequestedAtLevel
         *        Specifies at which level within the Amazon Web Services account the quota request applies to.
         * @see AppliedLevelEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppliedLevelEnum
         */
        Builder quotaRequestedAtLevel(String quotaRequestedAtLevel);

        /**
         * <p>
         * Specifies at which level within the Amazon Web Services account the quota request applies to.
         * </p>
         * 
         * @param quotaRequestedAtLevel
         *        Specifies at which level within the Amazon Web Services account the quota request applies to.
         * @see AppliedLevelEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppliedLevelEnum
         */
        Builder quotaRequestedAtLevel(AppliedLevelEnum quotaRequestedAtLevel);

        /**
         * <p>
         * The context for this service quota.
         * </p>
         * 
         * @param quotaContext
         *        The context for this service quota.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quotaContext(QuotaContextInfo quotaContext);

        /**
         * <p>
         * The context for this service quota.
         * </p>
         * This is a convenience method that creates an instance of the {@link QuotaContextInfo.Builder} avoiding the
         * need to create one manually via {@link QuotaContextInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link QuotaContextInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #quotaContext(QuotaContextInfo)}.
         * 
         * @param quotaContext
         *        a consumer that will call methods on {@link QuotaContextInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #quotaContext(QuotaContextInfo)
         */
        default Builder quotaContext(Consumer<QuotaContextInfo.Builder> quotaContext) {
            return quotaContext(QuotaContextInfo.builder().applyMutation(quotaContext).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String caseId;

        private String serviceCode;

        private String serviceName;

        private String quotaCode;

        private String quotaName;

        private Double desiredValue;

        private String status;

        private Instant created;

        private Instant lastUpdated;

        private String requester;

        private String quotaArn;

        private Boolean globalQuota;

        private String unit;

        private String quotaRequestedAtLevel;

        private QuotaContextInfo quotaContext;

        private BuilderImpl() {
        }

        private BuilderImpl(RequestedServiceQuotaChange model) {
            id(model.id);
            caseId(model.caseId);
            serviceCode(model.serviceCode);
            serviceName(model.serviceName);
            quotaCode(model.quotaCode);
            quotaName(model.quotaName);
            desiredValue(model.desiredValue);
            status(model.status);
            created(model.created);
            lastUpdated(model.lastUpdated);
            requester(model.requester);
            quotaArn(model.quotaArn);
            globalQuota(model.globalQuota);
            unit(model.unit);
            quotaRequestedAtLevel(model.quotaRequestedAtLevel);
            quotaContext(model.quotaContext);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getCaseId() {
            return caseId;
        }

        public final void setCaseId(String caseId) {
            this.caseId = caseId;
        }

        @Override
        public final Builder caseId(String caseId) {
            this.caseId = caseId;
            return this;
        }

        public final String getServiceCode() {
            return serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getQuotaCode() {
            return quotaCode;
        }

        public final void setQuotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
        }

        @Override
        public final Builder quotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
            return this;
        }

        public final String getQuotaName() {
            return quotaName;
        }

        public final void setQuotaName(String quotaName) {
            this.quotaName = quotaName;
        }

        @Override
        public final Builder quotaName(String quotaName) {
            this.quotaName = quotaName;
            return this;
        }

        public final Double getDesiredValue() {
            return desiredValue;
        }

        public final void setDesiredValue(Double desiredValue) {
            this.desiredValue = desiredValue;
        }

        @Override
        public final Builder desiredValue(Double desiredValue) {
            this.desiredValue = desiredValue;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RequestStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreated() {
            return created;
        }

        public final void setCreated(Instant created) {
            this.created = created;
        }

        @Override
        public final Builder created(Instant created) {
            this.created = created;
            return this;
        }

        public final Instant getLastUpdated() {
            return lastUpdated;
        }

        public final void setLastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
        }

        @Override
        public final Builder lastUpdated(Instant lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public final String getRequester() {
            return requester;
        }

        public final void setRequester(String requester) {
            this.requester = requester;
        }

        @Override
        public final Builder requester(String requester) {
            this.requester = requester;
            return this;
        }

        public final String getQuotaArn() {
            return quotaArn;
        }

        public final void setQuotaArn(String quotaArn) {
            this.quotaArn = quotaArn;
        }

        @Override
        public final Builder quotaArn(String quotaArn) {
            this.quotaArn = quotaArn;
            return this;
        }

        public final Boolean getGlobalQuota() {
            return globalQuota;
        }

        public final void setGlobalQuota(Boolean globalQuota) {
            this.globalQuota = globalQuota;
        }

        @Override
        public final Builder globalQuota(Boolean globalQuota) {
            this.globalQuota = globalQuota;
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final String getQuotaRequestedAtLevel() {
            return quotaRequestedAtLevel;
        }

        public final void setQuotaRequestedAtLevel(String quotaRequestedAtLevel) {
            this.quotaRequestedAtLevel = quotaRequestedAtLevel;
        }

        @Override
        public final Builder quotaRequestedAtLevel(String quotaRequestedAtLevel) {
            this.quotaRequestedAtLevel = quotaRequestedAtLevel;
            return this;
        }

        @Override
        public final Builder quotaRequestedAtLevel(AppliedLevelEnum quotaRequestedAtLevel) {
            this.quotaRequestedAtLevel(quotaRequestedAtLevel == null ? null : quotaRequestedAtLevel.toString());
            return this;
        }

        public final QuotaContextInfo.Builder getQuotaContext() {
            return quotaContext != null ? quotaContext.toBuilder() : null;
        }

        public final void setQuotaContext(QuotaContextInfo.BuilderImpl quotaContext) {
            this.quotaContext = quotaContext != null ? quotaContext.build() : null;
        }

        @Override
        public final Builder quotaContext(QuotaContextInfo quotaContext) {
            this.quotaContext = quotaContext;
            return this;
        }

        @Override
        public RequestedServiceQuotaChange build() {
            return new RequestedServiceQuotaChange(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
