/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicequotas;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.servicequotas.model.AccessDeniedException;
import software.amazon.awssdk.services.servicequotas.model.AssociateServiceQuotaTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.AssociateServiceQuotaTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.AwsServiceAccessNotEnabledException;
import software.amazon.awssdk.services.servicequotas.model.DeleteServiceQuotaIncreaseRequestFromTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.DeleteServiceQuotaIncreaseRequestFromTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.DependencyAccessDeniedException;
import software.amazon.awssdk.services.servicequotas.model.DisassociateServiceQuotaTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.DisassociateServiceQuotaTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.GetAssociationForServiceQuotaTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.GetAssociationForServiceQuotaTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.GetAwsDefaultServiceQuotaRequest;
import software.amazon.awssdk.services.servicequotas.model.GetAwsDefaultServiceQuotaResponse;
import software.amazon.awssdk.services.servicequotas.model.GetRequestedServiceQuotaChangeRequest;
import software.amazon.awssdk.services.servicequotas.model.GetRequestedServiceQuotaChangeResponse;
import software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaIncreaseRequestFromTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaIncreaseRequestFromTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaRequest;
import software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaResponse;
import software.amazon.awssdk.services.servicequotas.model.IllegalArgumentException;
import software.amazon.awssdk.services.servicequotas.model.InvalidPaginationTokenException;
import software.amazon.awssdk.services.servicequotas.model.InvalidResourceStateException;
import software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasRequest;
import software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasResponse;
import software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest;
import software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaResponse;
import software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest;
import software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryResponse;
import software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasRequest;
import software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasResponse;
import software.amazon.awssdk.services.servicequotas.model.ListServicesRequest;
import software.amazon.awssdk.services.servicequotas.model.ListServicesResponse;
import software.amazon.awssdk.services.servicequotas.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.servicequotas.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.servicequotas.model.NoAvailableOrganizationException;
import software.amazon.awssdk.services.servicequotas.model.NoSuchResourceException;
import software.amazon.awssdk.services.servicequotas.model.OrganizationNotInAllFeaturesModeException;
import software.amazon.awssdk.services.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateRequest;
import software.amazon.awssdk.services.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateResponse;
import software.amazon.awssdk.services.servicequotas.model.QuotaExceededException;
import software.amazon.awssdk.services.servicequotas.model.RequestServiceQuotaIncreaseRequest;
import software.amazon.awssdk.services.servicequotas.model.RequestServiceQuotaIncreaseResponse;
import software.amazon.awssdk.services.servicequotas.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.servicequotas.model.ServiceException;
import software.amazon.awssdk.services.servicequotas.model.ServiceQuotaTemplateNotInUseException;
import software.amazon.awssdk.services.servicequotas.model.ServiceQuotasException;
import software.amazon.awssdk.services.servicequotas.model.TagPolicyViolationException;
import software.amazon.awssdk.services.servicequotas.model.TagResourceRequest;
import software.amazon.awssdk.services.servicequotas.model.TagResourceResponse;
import software.amazon.awssdk.services.servicequotas.model.TemplatesNotAvailableInRegionException;
import software.amazon.awssdk.services.servicequotas.model.TooManyRequestsException;
import software.amazon.awssdk.services.servicequotas.model.TooManyTagsException;
import software.amazon.awssdk.services.servicequotas.model.UntagResourceRequest;
import software.amazon.awssdk.services.servicequotas.model.UntagResourceResponse;
import software.amazon.awssdk.services.servicequotas.paginators.ListAWSDefaultServiceQuotasIterable;
import software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryByQuotaIterable;
import software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryIterable;
import software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotaIncreaseRequestsInTemplateIterable;
import software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotasIterable;
import software.amazon.awssdk.services.servicequotas.paginators.ListServicesIterable;

/**
 * Service client for accessing Service Quotas. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * With Service Quotas, you can view and manage your quotas easily as your Amazon Web Services workloads grow. Quotas,
 * also referred to as limits, are the maximum number of resources that you can create in your Amazon Web Services
 * account. For more information, see the <a href="https://docs.aws.amazon.com/servicequotas/latest/userguide/">Service
 * Quotas User Guide</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ServiceQuotasClient extends AwsClient {
    String SERVICE_NAME = "servicequotas";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "servicequotas";

    /**
     * <p>
     * Associates your quota request template with your organization. When a new Amazon Web Services account is created
     * in your organization, the quota increase requests in the template are automatically applied to the account. You
     * can add a quota increase request for any adjustable quota to your template.
     * </p>
     *
     * @param associateServiceQuotaTemplateRequest
     * @return Result of the AssociateServiceQuotaTemplate operation returned by the service.
     * @throws DependencyAccessDeniedException
     *         You can't perform this action because a dependency does not have access.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws AwsServiceAccessNotEnabledException
     *         The action you attempted is not allowed unless Service Access with Service Quotas is enabled in your
     *         organization.
     * @throws OrganizationNotInAllFeaturesModeException
     *         The organization that your Amazon Web Services account belongs to is not in All Features mode.
     * @throws TemplatesNotAvailableInRegionException
     *         The Service Quotas template is not available in this Amazon Web Services Region.
     * @throws NoAvailableOrganizationException
     *         The Amazon Web Services account making this call is not a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.AssociateServiceQuotaTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/AssociateServiceQuotaTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateServiceQuotaTemplateResponse associateServiceQuotaTemplate(
            AssociateServiceQuotaTemplateRequest associateServiceQuotaTemplateRequest) throws DependencyAccessDeniedException,
            AccessDeniedException, ServiceException, TooManyRequestsException, AwsServiceAccessNotEnabledException,
            OrganizationNotInAllFeaturesModeException, TemplatesNotAvailableInRegionException, NoAvailableOrganizationException,
            AwsServiceException, SdkClientException, ServiceQuotasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates your quota request template with your organization. When a new Amazon Web Services account is created
     * in your organization, the quota increase requests in the template are automatically applied to the account. You
     * can add a quota increase request for any adjustable quota to your template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateServiceQuotaTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateServiceQuotaTemplateRequest#builder()}
     * </p>
     *
     * @param associateServiceQuotaTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.AssociateServiceQuotaTemplateRequest.Builder}
     *        to create a request.
     * @return Result of the AssociateServiceQuotaTemplate operation returned by the service.
     * @throws DependencyAccessDeniedException
     *         You can't perform this action because a dependency does not have access.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws AwsServiceAccessNotEnabledException
     *         The action you attempted is not allowed unless Service Access with Service Quotas is enabled in your
     *         organization.
     * @throws OrganizationNotInAllFeaturesModeException
     *         The organization that your Amazon Web Services account belongs to is not in All Features mode.
     * @throws TemplatesNotAvailableInRegionException
     *         The Service Quotas template is not available in this Amazon Web Services Region.
     * @throws NoAvailableOrganizationException
     *         The Amazon Web Services account making this call is not a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.AssociateServiceQuotaTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/AssociateServiceQuotaTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateServiceQuotaTemplateResponse associateServiceQuotaTemplate(
            Consumer<AssociateServiceQuotaTemplateRequest.Builder> associateServiceQuotaTemplateRequest)
            throws DependencyAccessDeniedException, AccessDeniedException, ServiceException, TooManyRequestsException,
            AwsServiceAccessNotEnabledException, OrganizationNotInAllFeaturesModeException,
            TemplatesNotAvailableInRegionException, NoAvailableOrganizationException, AwsServiceException, SdkClientException,
            ServiceQuotasException {
        return associateServiceQuotaTemplate(AssociateServiceQuotaTemplateRequest.builder()
                .applyMutation(associateServiceQuotaTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes the quota increase request for the specified quota from your quota request template.
     * </p>
     *
     * @param deleteServiceQuotaIncreaseRequestFromTemplateRequest
     * @return Result of the DeleteServiceQuotaIncreaseRequestFromTemplate operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws ServiceException
     *         Something went wrong.
     * @throws DependencyAccessDeniedException
     *         You can't perform this action because a dependency does not have access.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws NoSuchResourceException
     *         The specified resource does not exist.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws AwsServiceAccessNotEnabledException
     *         The action you attempted is not allowed unless Service Access with Service Quotas is enabled in your
     *         organization.
     * @throws TemplatesNotAvailableInRegionException
     *         The Service Quotas template is not available in this Amazon Web Services Region.
     * @throws NoAvailableOrganizationException
     *         The Amazon Web Services account making this call is not a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.DeleteServiceQuotaIncreaseRequestFromTemplate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/DeleteServiceQuotaIncreaseRequestFromTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteServiceQuotaIncreaseRequestFromTemplateResponse deleteServiceQuotaIncreaseRequestFromTemplate(
            DeleteServiceQuotaIncreaseRequestFromTemplateRequest deleteServiceQuotaIncreaseRequestFromTemplateRequest)
            throws AccessDeniedException, ServiceException, DependencyAccessDeniedException, TooManyRequestsException,
            NoSuchResourceException, IllegalArgumentException, AwsServiceAccessNotEnabledException,
            TemplatesNotAvailableInRegionException, NoAvailableOrganizationException, AwsServiceException, SdkClientException,
            ServiceQuotasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the quota increase request for the specified quota from your quota request template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteServiceQuotaIncreaseRequestFromTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteServiceQuotaIncreaseRequestFromTemplateRequest#builder()}
     * </p>
     *
     * @param deleteServiceQuotaIncreaseRequestFromTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.DeleteServiceQuotaIncreaseRequestFromTemplateRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteServiceQuotaIncreaseRequestFromTemplate operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws ServiceException
     *         Something went wrong.
     * @throws DependencyAccessDeniedException
     *         You can't perform this action because a dependency does not have access.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws NoSuchResourceException
     *         The specified resource does not exist.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws AwsServiceAccessNotEnabledException
     *         The action you attempted is not allowed unless Service Access with Service Quotas is enabled in your
     *         organization.
     * @throws TemplatesNotAvailableInRegionException
     *         The Service Quotas template is not available in this Amazon Web Services Region.
     * @throws NoAvailableOrganizationException
     *         The Amazon Web Services account making this call is not a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.DeleteServiceQuotaIncreaseRequestFromTemplate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/DeleteServiceQuotaIncreaseRequestFromTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteServiceQuotaIncreaseRequestFromTemplateResponse deleteServiceQuotaIncreaseRequestFromTemplate(
            Consumer<DeleteServiceQuotaIncreaseRequestFromTemplateRequest.Builder> deleteServiceQuotaIncreaseRequestFromTemplateRequest)
            throws AccessDeniedException, ServiceException, DependencyAccessDeniedException, TooManyRequestsException,
            NoSuchResourceException, IllegalArgumentException, AwsServiceAccessNotEnabledException,
            TemplatesNotAvailableInRegionException, NoAvailableOrganizationException, AwsServiceException, SdkClientException,
            ServiceQuotasException {
        return deleteServiceQuotaIncreaseRequestFromTemplate(DeleteServiceQuotaIncreaseRequestFromTemplateRequest.builder()
                .applyMutation(deleteServiceQuotaIncreaseRequestFromTemplateRequest).build());
    }

    /**
     * <p>
     * Disables your quota request template. After a template is disabled, the quota increase requests in the template
     * are not applied to new Amazon Web Services accounts in your organization. Disabling a quota request template does
     * not apply its quota increase requests.
     * </p>
     *
     * @param disassociateServiceQuotaTemplateRequest
     * @return Result of the DisassociateServiceQuotaTemplate operation returned by the service.
     * @throws DependencyAccessDeniedException
     *         You can't perform this action because a dependency does not have access.
     * @throws ServiceQuotaTemplateNotInUseException
     *         The quota request template is not associated with your organization.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws AwsServiceAccessNotEnabledException
     *         The action you attempted is not allowed unless Service Access with Service Quotas is enabled in your
     *         organization.
     * @throws TemplatesNotAvailableInRegionException
     *         The Service Quotas template is not available in this Amazon Web Services Region.
     * @throws NoAvailableOrganizationException
     *         The Amazon Web Services account making this call is not a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.DisassociateServiceQuotaTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/DisassociateServiceQuotaTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateServiceQuotaTemplateResponse disassociateServiceQuotaTemplate(
            DisassociateServiceQuotaTemplateRequest disassociateServiceQuotaTemplateRequest)
            throws DependencyAccessDeniedException, ServiceQuotaTemplateNotInUseException, AccessDeniedException,
            ServiceException, TooManyRequestsException, AwsServiceAccessNotEnabledException,
            TemplatesNotAvailableInRegionException, NoAvailableOrganizationException, AwsServiceException, SdkClientException,
            ServiceQuotasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables your quota request template. After a template is disabled, the quota increase requests in the template
     * are not applied to new Amazon Web Services accounts in your organization. Disabling a quota request template does
     * not apply its quota increase requests.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateServiceQuotaTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateServiceQuotaTemplateRequest#builder()}
     * </p>
     *
     * @param disassociateServiceQuotaTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.DisassociateServiceQuotaTemplateRequest.Builder}
     *        to create a request.
     * @return Result of the DisassociateServiceQuotaTemplate operation returned by the service.
     * @throws DependencyAccessDeniedException
     *         You can't perform this action because a dependency does not have access.
     * @throws ServiceQuotaTemplateNotInUseException
     *         The quota request template is not associated with your organization.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws AwsServiceAccessNotEnabledException
     *         The action you attempted is not allowed unless Service Access with Service Quotas is enabled in your
     *         organization.
     * @throws TemplatesNotAvailableInRegionException
     *         The Service Quotas template is not available in this Amazon Web Services Region.
     * @throws NoAvailableOrganizationException
     *         The Amazon Web Services account making this call is not a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.DisassociateServiceQuotaTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/DisassociateServiceQuotaTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateServiceQuotaTemplateResponse disassociateServiceQuotaTemplate(
            Consumer<DisassociateServiceQuotaTemplateRequest.Builder> disassociateServiceQuotaTemplateRequest)
            throws DependencyAccessDeniedException, ServiceQuotaTemplateNotInUseException, AccessDeniedException,
            ServiceException, TooManyRequestsException, AwsServiceAccessNotEnabledException,
            TemplatesNotAvailableInRegionException, NoAvailableOrganizationException, AwsServiceException, SdkClientException,
            ServiceQuotasException {
        return disassociateServiceQuotaTemplate(DisassociateServiceQuotaTemplateRequest.builder()
                .applyMutation(disassociateServiceQuotaTemplateRequest).build());
    }

    /**
     * <p>
     * Retrieves the default value for the specified quota. The default value does not reflect any quota increases.
     * </p>
     *
     * @param getAwsDefaultServiceQuotaRequest
     * @return Result of the GetAWSDefaultServiceQuota operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws NoSuchResourceException
     *         The specified resource does not exist.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.GetAWSDefaultServiceQuota
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetAWSDefaultServiceQuota"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAwsDefaultServiceQuotaResponse getAWSDefaultServiceQuota(
            GetAwsDefaultServiceQuotaRequest getAwsDefaultServiceQuotaRequest) throws AccessDeniedException,
            NoSuchResourceException, IllegalArgumentException, ServiceException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ServiceQuotasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the default value for the specified quota. The default value does not reflect any quota increases.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAwsDefaultServiceQuotaRequest.Builder} avoiding
     * the need to create one manually via {@link GetAwsDefaultServiceQuotaRequest#builder()}
     * </p>
     *
     * @param getAwsDefaultServiceQuotaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.GetAwsDefaultServiceQuotaRequest.Builder} to
     *        create a request.
     * @return Result of the GetAWSDefaultServiceQuota operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws NoSuchResourceException
     *         The specified resource does not exist.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.GetAWSDefaultServiceQuota
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetAWSDefaultServiceQuota"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAwsDefaultServiceQuotaResponse getAWSDefaultServiceQuota(
            Consumer<GetAwsDefaultServiceQuotaRequest.Builder> getAwsDefaultServiceQuotaRequest) throws AccessDeniedException,
            NoSuchResourceException, IllegalArgumentException, ServiceException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ServiceQuotasException {
        return getAWSDefaultServiceQuota(GetAwsDefaultServiceQuotaRequest.builder()
                .applyMutation(getAwsDefaultServiceQuotaRequest).build());
    }

    /**
     * <p>
     * Retrieves the status of the association for the quota request template.
     * </p>
     *
     * @param getAssociationForServiceQuotaTemplateRequest
     * @return Result of the GetAssociationForServiceQuotaTemplate operation returned by the service.
     * @throws DependencyAccessDeniedException
     *         You can't perform this action because a dependency does not have access.
     * @throws ServiceQuotaTemplateNotInUseException
     *         The quota request template is not associated with your organization.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws AwsServiceAccessNotEnabledException
     *         The action you attempted is not allowed unless Service Access with Service Quotas is enabled in your
     *         organization.
     * @throws TemplatesNotAvailableInRegionException
     *         The Service Quotas template is not available in this Amazon Web Services Region.
     * @throws NoAvailableOrganizationException
     *         The Amazon Web Services account making this call is not a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.GetAssociationForServiceQuotaTemplate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetAssociationForServiceQuotaTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAssociationForServiceQuotaTemplateResponse getAssociationForServiceQuotaTemplate(
            GetAssociationForServiceQuotaTemplateRequest getAssociationForServiceQuotaTemplateRequest)
            throws DependencyAccessDeniedException, ServiceQuotaTemplateNotInUseException, AccessDeniedException,
            ServiceException, TooManyRequestsException, AwsServiceAccessNotEnabledException,
            TemplatesNotAvailableInRegionException, NoAvailableOrganizationException, AwsServiceException, SdkClientException,
            ServiceQuotasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the status of the association for the quota request template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetAssociationForServiceQuotaTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link GetAssociationForServiceQuotaTemplateRequest#builder()}
     * </p>
     *
     * @param getAssociationForServiceQuotaTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.GetAssociationForServiceQuotaTemplateRequest.Builder}
     *        to create a request.
     * @return Result of the GetAssociationForServiceQuotaTemplate operation returned by the service.
     * @throws DependencyAccessDeniedException
     *         You can't perform this action because a dependency does not have access.
     * @throws ServiceQuotaTemplateNotInUseException
     *         The quota request template is not associated with your organization.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws AwsServiceAccessNotEnabledException
     *         The action you attempted is not allowed unless Service Access with Service Quotas is enabled in your
     *         organization.
     * @throws TemplatesNotAvailableInRegionException
     *         The Service Quotas template is not available in this Amazon Web Services Region.
     * @throws NoAvailableOrganizationException
     *         The Amazon Web Services account making this call is not a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.GetAssociationForServiceQuotaTemplate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetAssociationForServiceQuotaTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAssociationForServiceQuotaTemplateResponse getAssociationForServiceQuotaTemplate(
            Consumer<GetAssociationForServiceQuotaTemplateRequest.Builder> getAssociationForServiceQuotaTemplateRequest)
            throws DependencyAccessDeniedException, ServiceQuotaTemplateNotInUseException, AccessDeniedException,
            ServiceException, TooManyRequestsException, AwsServiceAccessNotEnabledException,
            TemplatesNotAvailableInRegionException, NoAvailableOrganizationException, AwsServiceException, SdkClientException,
            ServiceQuotasException {
        return getAssociationForServiceQuotaTemplate(GetAssociationForServiceQuotaTemplateRequest.builder()
                .applyMutation(getAssociationForServiceQuotaTemplateRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified quota increase request.
     * </p>
     *
     * @param getRequestedServiceQuotaChangeRequest
     * @return Result of the GetRequestedServiceQuotaChange operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws NoSuchResourceException
     *         The specified resource does not exist.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.GetRequestedServiceQuotaChange
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetRequestedServiceQuotaChange"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRequestedServiceQuotaChangeResponse getRequestedServiceQuotaChange(
            GetRequestedServiceQuotaChangeRequest getRequestedServiceQuotaChangeRequest) throws AccessDeniedException,
            NoSuchResourceException, IllegalArgumentException, ServiceException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ServiceQuotasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified quota increase request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRequestedServiceQuotaChangeRequest.Builder}
     * avoiding the need to create one manually via {@link GetRequestedServiceQuotaChangeRequest#builder()}
     * </p>
     *
     * @param getRequestedServiceQuotaChangeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.GetRequestedServiceQuotaChangeRequest.Builder}
     *        to create a request.
     * @return Result of the GetRequestedServiceQuotaChange operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws NoSuchResourceException
     *         The specified resource does not exist.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.GetRequestedServiceQuotaChange
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetRequestedServiceQuotaChange"
     *      target="_top">AWS API Documentation</a>
     */
    default GetRequestedServiceQuotaChangeResponse getRequestedServiceQuotaChange(
            Consumer<GetRequestedServiceQuotaChangeRequest.Builder> getRequestedServiceQuotaChangeRequest)
            throws AccessDeniedException, NoSuchResourceException, IllegalArgumentException, ServiceException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        return getRequestedServiceQuotaChange(GetRequestedServiceQuotaChangeRequest.builder()
                .applyMutation(getRequestedServiceQuotaChangeRequest).build());
    }

    /**
     * <p>
     * Retrieves the applied quota value for the specified quota. For some quotas, only the default values are
     * available. If the applied quota value is not available for a quota, the quota is not retrieved.
     * </p>
     *
     * @param getServiceQuotaRequest
     * @return Result of the GetServiceQuota operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws NoSuchResourceException
     *         The specified resource does not exist.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.GetServiceQuota
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetServiceQuota"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServiceQuotaResponse getServiceQuota(GetServiceQuotaRequest getServiceQuotaRequest) throws AccessDeniedException,
            NoSuchResourceException, IllegalArgumentException, ServiceException, TooManyRequestsException, AwsServiceException,
            SdkClientException, ServiceQuotasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the applied quota value for the specified quota. For some quotas, only the default values are
     * available. If the applied quota value is not available for a quota, the quota is not retrieved.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetServiceQuotaRequest.Builder} avoiding the need
     * to create one manually via {@link GetServiceQuotaRequest#builder()}
     * </p>
     *
     * @param getServiceQuotaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaRequest.Builder} to create a
     *        request.
     * @return Result of the GetServiceQuota operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws NoSuchResourceException
     *         The specified resource does not exist.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.GetServiceQuota
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetServiceQuota"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServiceQuotaResponse getServiceQuota(Consumer<GetServiceQuotaRequest.Builder> getServiceQuotaRequest)
            throws AccessDeniedException, NoSuchResourceException, IllegalArgumentException, ServiceException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        return getServiceQuota(GetServiceQuotaRequest.builder().applyMutation(getServiceQuotaRequest).build());
    }

    /**
     * <p>
     * Retrieves information about the specified quota increase request in your quota request template.
     * </p>
     *
     * @param getServiceQuotaIncreaseRequestFromTemplateRequest
     * @return Result of the GetServiceQuotaIncreaseRequestFromTemplate operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws DependencyAccessDeniedException
     *         You can't perform this action because a dependency does not have access.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws NoSuchResourceException
     *         The specified resource does not exist.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws AwsServiceAccessNotEnabledException
     *         The action you attempted is not allowed unless Service Access with Service Quotas is enabled in your
     *         organization.
     * @throws TemplatesNotAvailableInRegionException
     *         The Service Quotas template is not available in this Amazon Web Services Region.
     * @throws NoAvailableOrganizationException
     *         The Amazon Web Services account making this call is not a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.GetServiceQuotaIncreaseRequestFromTemplate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetServiceQuotaIncreaseRequestFromTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServiceQuotaIncreaseRequestFromTemplateResponse getServiceQuotaIncreaseRequestFromTemplate(
            GetServiceQuotaIncreaseRequestFromTemplateRequest getServiceQuotaIncreaseRequestFromTemplateRequest)
            throws AccessDeniedException, DependencyAccessDeniedException, ServiceException, TooManyRequestsException,
            NoSuchResourceException, IllegalArgumentException, AwsServiceAccessNotEnabledException,
            TemplatesNotAvailableInRegionException, NoAvailableOrganizationException, AwsServiceException, SdkClientException,
            ServiceQuotasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about the specified quota increase request in your quota request template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link GetServiceQuotaIncreaseRequestFromTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link GetServiceQuotaIncreaseRequestFromTemplateRequest#builder()}
     * </p>
     *
     * @param getServiceQuotaIncreaseRequestFromTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.GetServiceQuotaIncreaseRequestFromTemplateRequest.Builder}
     *        to create a request.
     * @return Result of the GetServiceQuotaIncreaseRequestFromTemplate operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws DependencyAccessDeniedException
     *         You can't perform this action because a dependency does not have access.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws NoSuchResourceException
     *         The specified resource does not exist.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws AwsServiceAccessNotEnabledException
     *         The action you attempted is not allowed unless Service Access with Service Quotas is enabled in your
     *         organization.
     * @throws TemplatesNotAvailableInRegionException
     *         The Service Quotas template is not available in this Amazon Web Services Region.
     * @throws NoAvailableOrganizationException
     *         The Amazon Web Services account making this call is not a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.GetServiceQuotaIncreaseRequestFromTemplate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/GetServiceQuotaIncreaseRequestFromTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default GetServiceQuotaIncreaseRequestFromTemplateResponse getServiceQuotaIncreaseRequestFromTemplate(
            Consumer<GetServiceQuotaIncreaseRequestFromTemplateRequest.Builder> getServiceQuotaIncreaseRequestFromTemplateRequest)
            throws AccessDeniedException, DependencyAccessDeniedException, ServiceException, TooManyRequestsException,
            NoSuchResourceException, IllegalArgumentException, AwsServiceAccessNotEnabledException,
            TemplatesNotAvailableInRegionException, NoAvailableOrganizationException, AwsServiceException, SdkClientException,
            ServiceQuotasException {
        return getServiceQuotaIncreaseRequestFromTemplate(GetServiceQuotaIncreaseRequestFromTemplateRequest.builder()
                .applyMutation(getServiceQuotaIncreaseRequestFromTemplateRequest).build());
    }

    /**
     * <p>
     * Lists the default values for the quotas for the specified Amazon Web Service. A default value does not reflect
     * any quota increases.
     * </p>
     *
     * @param listAwsDefaultServiceQuotasRequest
     * @return Result of the ListAWSDefaultServiceQuotas operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws NoSuchResourceException
     *         The specified resource does not exist.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws InvalidPaginationTokenException
     *         Invalid input was provided.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.ListAWSDefaultServiceQuotas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListAWSDefaultServiceQuotas"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAwsDefaultServiceQuotasResponse listAWSDefaultServiceQuotas(
            ListAwsDefaultServiceQuotasRequest listAwsDefaultServiceQuotasRequest) throws AccessDeniedException,
            NoSuchResourceException, IllegalArgumentException, InvalidPaginationTokenException, ServiceException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the default values for the quotas for the specified Amazon Web Service. A default value does not reflect
     * any quota increases.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAwsDefaultServiceQuotasRequest.Builder}
     * avoiding the need to create one manually via {@link ListAwsDefaultServiceQuotasRequest#builder()}
     * </p>
     *
     * @param listAwsDefaultServiceQuotasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasRequest.Builder} to
     *        create a request.
     * @return Result of the ListAWSDefaultServiceQuotas operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws NoSuchResourceException
     *         The specified resource does not exist.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws InvalidPaginationTokenException
     *         Invalid input was provided.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.ListAWSDefaultServiceQuotas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListAWSDefaultServiceQuotas"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAwsDefaultServiceQuotasResponse listAWSDefaultServiceQuotas(
            Consumer<ListAwsDefaultServiceQuotasRequest.Builder> listAwsDefaultServiceQuotasRequest)
            throws AccessDeniedException, NoSuchResourceException, IllegalArgumentException, InvalidPaginationTokenException,
            ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        return listAWSDefaultServiceQuotas(ListAwsDefaultServiceQuotasRequest.builder()
                .applyMutation(listAwsDefaultServiceQuotasRequest).build());
    }

    /**
     * <p>
     * Lists the default values for the quotas for the specified Amazon Web Service. A default value does not reflect
     * any quota increases.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAWSDefaultServiceQuotas(software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListAWSDefaultServiceQuotasIterable responses = client.listAWSDefaultServiceQuotasPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicequotas.paginators.ListAWSDefaultServiceQuotasIterable responses = client
     *             .listAWSDefaultServiceQuotasPaginator(request);
     *     for (software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListAWSDefaultServiceQuotasIterable responses = client.listAWSDefaultServiceQuotasPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAWSDefaultServiceQuotas(software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAwsDefaultServiceQuotasRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws NoSuchResourceException
     *         The specified resource does not exist.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws InvalidPaginationTokenException
     *         Invalid input was provided.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.ListAWSDefaultServiceQuotas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListAWSDefaultServiceQuotas"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAWSDefaultServiceQuotasIterable listAWSDefaultServiceQuotasPaginator(
            ListAwsDefaultServiceQuotasRequest listAwsDefaultServiceQuotasRequest) throws AccessDeniedException,
            NoSuchResourceException, IllegalArgumentException, InvalidPaginationTokenException, ServiceException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        return new ListAWSDefaultServiceQuotasIterable(this, listAwsDefaultServiceQuotasRequest);
    }

    /**
     * <p>
     * Lists the default values for the quotas for the specified Amazon Web Service. A default value does not reflect
     * any quota increases.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listAWSDefaultServiceQuotas(software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListAWSDefaultServiceQuotasIterable responses = client.listAWSDefaultServiceQuotasPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicequotas.paginators.ListAWSDefaultServiceQuotasIterable responses = client
     *             .listAWSDefaultServiceQuotasPaginator(request);
     *     for (software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListAWSDefaultServiceQuotasIterable responses = client.listAWSDefaultServiceQuotasPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAWSDefaultServiceQuotas(software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAwsDefaultServiceQuotasRequest.Builder}
     * avoiding the need to create one manually via {@link ListAwsDefaultServiceQuotasRequest#builder()}
     * </p>
     *
     * @param listAwsDefaultServiceQuotasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.ListAwsDefaultServiceQuotasRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws NoSuchResourceException
     *         The specified resource does not exist.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws InvalidPaginationTokenException
     *         Invalid input was provided.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.ListAWSDefaultServiceQuotas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListAWSDefaultServiceQuotas"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAWSDefaultServiceQuotasIterable listAWSDefaultServiceQuotasPaginator(
            Consumer<ListAwsDefaultServiceQuotasRequest.Builder> listAwsDefaultServiceQuotasRequest)
            throws AccessDeniedException, NoSuchResourceException, IllegalArgumentException, InvalidPaginationTokenException,
            ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        return listAWSDefaultServiceQuotasPaginator(ListAwsDefaultServiceQuotasRequest.builder()
                .applyMutation(listAwsDefaultServiceQuotasRequest).build());
    }

    /**
     * <p>
     * Retrieves the quota increase requests for the specified Amazon Web Service.
     * </p>
     *
     * @param listRequestedServiceQuotaChangeHistoryRequest
     * @return Result of the ListRequestedServiceQuotaChangeHistory operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws NoSuchResourceException
     *         The specified resource does not exist.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws InvalidPaginationTokenException
     *         Invalid input was provided.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.ListRequestedServiceQuotaChangeHistory
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListRequestedServiceQuotaChangeHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRequestedServiceQuotaChangeHistoryResponse listRequestedServiceQuotaChangeHistory(
            ListRequestedServiceQuotaChangeHistoryRequest listRequestedServiceQuotaChangeHistoryRequest)
            throws AccessDeniedException, NoSuchResourceException, IllegalArgumentException, InvalidPaginationTokenException,
            ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the quota increase requests for the specified Amazon Web Service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListRequestedServiceQuotaChangeHistoryRequest.Builder} avoiding the need to create one manually via
     * {@link ListRequestedServiceQuotaChangeHistoryRequest#builder()}
     * </p>
     *
     * @param listRequestedServiceQuotaChangeHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest.Builder}
     *        to create a request.
     * @return Result of the ListRequestedServiceQuotaChangeHistory operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws NoSuchResourceException
     *         The specified resource does not exist.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws InvalidPaginationTokenException
     *         Invalid input was provided.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.ListRequestedServiceQuotaChangeHistory
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListRequestedServiceQuotaChangeHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRequestedServiceQuotaChangeHistoryResponse listRequestedServiceQuotaChangeHistory(
            Consumer<ListRequestedServiceQuotaChangeHistoryRequest.Builder> listRequestedServiceQuotaChangeHistoryRequest)
            throws AccessDeniedException, NoSuchResourceException, IllegalArgumentException, InvalidPaginationTokenException,
            ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        return listRequestedServiceQuotaChangeHistory(ListRequestedServiceQuotaChangeHistoryRequest.builder()
                .applyMutation(listRequestedServiceQuotaChangeHistoryRequest).build());
    }

    /**
     * <p>
     * Retrieves the quota increase requests for the specified Amazon Web Service.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRequestedServiceQuotaChangeHistory(software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryIterable responses = client.listRequestedServiceQuotaChangeHistoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryIterable responses = client
     *             .listRequestedServiceQuotaChangeHistoryPaginator(request);
     *     for (software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryIterable responses = client.listRequestedServiceQuotaChangeHistoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRequestedServiceQuotaChangeHistory(software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRequestedServiceQuotaChangeHistoryRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws NoSuchResourceException
     *         The specified resource does not exist.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws InvalidPaginationTokenException
     *         Invalid input was provided.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.ListRequestedServiceQuotaChangeHistory
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListRequestedServiceQuotaChangeHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRequestedServiceQuotaChangeHistoryIterable listRequestedServiceQuotaChangeHistoryPaginator(
            ListRequestedServiceQuotaChangeHistoryRequest listRequestedServiceQuotaChangeHistoryRequest)
            throws AccessDeniedException, NoSuchResourceException, IllegalArgumentException, InvalidPaginationTokenException,
            ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        return new ListRequestedServiceQuotaChangeHistoryIterable(this, listRequestedServiceQuotaChangeHistoryRequest);
    }

    /**
     * <p>
     * Retrieves the quota increase requests for the specified Amazon Web Service.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRequestedServiceQuotaChangeHistory(software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryIterable responses = client.listRequestedServiceQuotaChangeHistoryPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryIterable responses = client
     *             .listRequestedServiceQuotaChangeHistoryPaginator(request);
     *     for (software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryIterable responses = client.listRequestedServiceQuotaChangeHistoryPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRequestedServiceQuotaChangeHistory(software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListRequestedServiceQuotaChangeHistoryRequest.Builder} avoiding the need to create one manually via
     * {@link ListRequestedServiceQuotaChangeHistoryRequest#builder()}
     * </p>
     *
     * @param listRequestedServiceQuotaChangeHistoryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws NoSuchResourceException
     *         The specified resource does not exist.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws InvalidPaginationTokenException
     *         Invalid input was provided.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.ListRequestedServiceQuotaChangeHistory
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListRequestedServiceQuotaChangeHistory"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRequestedServiceQuotaChangeHistoryIterable listRequestedServiceQuotaChangeHistoryPaginator(
            Consumer<ListRequestedServiceQuotaChangeHistoryRequest.Builder> listRequestedServiceQuotaChangeHistoryRequest)
            throws AccessDeniedException, NoSuchResourceException, IllegalArgumentException, InvalidPaginationTokenException,
            ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        return listRequestedServiceQuotaChangeHistoryPaginator(ListRequestedServiceQuotaChangeHistoryRequest.builder()
                .applyMutation(listRequestedServiceQuotaChangeHistoryRequest).build());
    }

    /**
     * <p>
     * Retrieves the quota increase requests for the specified quota.
     * </p>
     *
     * @param listRequestedServiceQuotaChangeHistoryByQuotaRequest
     * @return Result of the ListRequestedServiceQuotaChangeHistoryByQuota operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws NoSuchResourceException
     *         The specified resource does not exist.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws InvalidPaginationTokenException
     *         Invalid input was provided.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.ListRequestedServiceQuotaChangeHistoryByQuota
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListRequestedServiceQuotaChangeHistoryByQuota"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRequestedServiceQuotaChangeHistoryByQuotaResponse listRequestedServiceQuotaChangeHistoryByQuota(
            ListRequestedServiceQuotaChangeHistoryByQuotaRequest listRequestedServiceQuotaChangeHistoryByQuotaRequest)
            throws AccessDeniedException, NoSuchResourceException, IllegalArgumentException, InvalidPaginationTokenException,
            ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the quota increase requests for the specified quota.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListRequestedServiceQuotaChangeHistoryByQuotaRequest.Builder} avoiding the need to create one manually via
     * {@link ListRequestedServiceQuotaChangeHistoryByQuotaRequest#builder()}
     * </p>
     *
     * @param listRequestedServiceQuotaChangeHistoryByQuotaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest.Builder}
     *        to create a request.
     * @return Result of the ListRequestedServiceQuotaChangeHistoryByQuota operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws NoSuchResourceException
     *         The specified resource does not exist.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws InvalidPaginationTokenException
     *         Invalid input was provided.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.ListRequestedServiceQuotaChangeHistoryByQuota
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListRequestedServiceQuotaChangeHistoryByQuota"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRequestedServiceQuotaChangeHistoryByQuotaResponse listRequestedServiceQuotaChangeHistoryByQuota(
            Consumer<ListRequestedServiceQuotaChangeHistoryByQuotaRequest.Builder> listRequestedServiceQuotaChangeHistoryByQuotaRequest)
            throws AccessDeniedException, NoSuchResourceException, IllegalArgumentException, InvalidPaginationTokenException,
            ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        return listRequestedServiceQuotaChangeHistoryByQuota(ListRequestedServiceQuotaChangeHistoryByQuotaRequest.builder()
                .applyMutation(listRequestedServiceQuotaChangeHistoryByQuotaRequest).build());
    }

    /**
     * <p>
     * Retrieves the quota increase requests for the specified quota.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRequestedServiceQuotaChangeHistoryByQuota(software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryByQuotaIterable responses = client.listRequestedServiceQuotaChangeHistoryByQuotaPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryByQuotaIterable responses = client
     *             .listRequestedServiceQuotaChangeHistoryByQuotaPaginator(request);
     *     for (software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryByQuotaIterable responses = client.listRequestedServiceQuotaChangeHistoryByQuotaPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRequestedServiceQuotaChangeHistoryByQuota(software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest)}
     * operation.</b>
     * </p>
     *
     * @param listRequestedServiceQuotaChangeHistoryByQuotaRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws NoSuchResourceException
     *         The specified resource does not exist.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws InvalidPaginationTokenException
     *         Invalid input was provided.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.ListRequestedServiceQuotaChangeHistoryByQuota
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListRequestedServiceQuotaChangeHistoryByQuota"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRequestedServiceQuotaChangeHistoryByQuotaIterable listRequestedServiceQuotaChangeHistoryByQuotaPaginator(
            ListRequestedServiceQuotaChangeHistoryByQuotaRequest listRequestedServiceQuotaChangeHistoryByQuotaRequest)
            throws AccessDeniedException, NoSuchResourceException, IllegalArgumentException, InvalidPaginationTokenException,
            ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        return new ListRequestedServiceQuotaChangeHistoryByQuotaIterable(this,
                listRequestedServiceQuotaChangeHistoryByQuotaRequest);
    }

    /**
     * <p>
     * Retrieves the quota increase requests for the specified quota.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listRequestedServiceQuotaChangeHistoryByQuota(software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryByQuotaIterable responses = client.listRequestedServiceQuotaChangeHistoryByQuotaPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryByQuotaIterable responses = client
     *             .listRequestedServiceQuotaChangeHistoryByQuotaPaginator(request);
     *     for (software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListRequestedServiceQuotaChangeHistoryByQuotaIterable responses = client.listRequestedServiceQuotaChangeHistoryByQuotaPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRequestedServiceQuotaChangeHistoryByQuota(software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListRequestedServiceQuotaChangeHistoryByQuotaRequest.Builder} avoiding the need to create one manually via
     * {@link ListRequestedServiceQuotaChangeHistoryByQuotaRequest#builder()}
     * </p>
     *
     * @param listRequestedServiceQuotaChangeHistoryByQuotaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.ListRequestedServiceQuotaChangeHistoryByQuotaRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws NoSuchResourceException
     *         The specified resource does not exist.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws InvalidPaginationTokenException
     *         Invalid input was provided.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.ListRequestedServiceQuotaChangeHistoryByQuota
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListRequestedServiceQuotaChangeHistoryByQuota"
     *      target="_top">AWS API Documentation</a>
     */
    default ListRequestedServiceQuotaChangeHistoryByQuotaIterable listRequestedServiceQuotaChangeHistoryByQuotaPaginator(
            Consumer<ListRequestedServiceQuotaChangeHistoryByQuotaRequest.Builder> listRequestedServiceQuotaChangeHistoryByQuotaRequest)
            throws AccessDeniedException, NoSuchResourceException, IllegalArgumentException, InvalidPaginationTokenException,
            ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        return listRequestedServiceQuotaChangeHistoryByQuotaPaginator(ListRequestedServiceQuotaChangeHistoryByQuotaRequest
                .builder().applyMutation(listRequestedServiceQuotaChangeHistoryByQuotaRequest).build());
    }

    /**
     * <p>
     * Lists the quota increase requests in the specified quota request template.
     * </p>
     *
     * @param listServiceQuotaIncreaseRequestsInTemplateRequest
     * @return Result of the ListServiceQuotaIncreaseRequestsInTemplate operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws DependencyAccessDeniedException
     *         You can't perform this action because a dependency does not have access.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws AwsServiceAccessNotEnabledException
     *         The action you attempted is not allowed unless Service Access with Service Quotas is enabled in your
     *         organization.
     * @throws TemplatesNotAvailableInRegionException
     *         The Service Quotas template is not available in this Amazon Web Services Region.
     * @throws NoAvailableOrganizationException
     *         The Amazon Web Services account making this call is not a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.ListServiceQuotaIncreaseRequestsInTemplate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServiceQuotaIncreaseRequestsInTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceQuotaIncreaseRequestsInTemplateResponse listServiceQuotaIncreaseRequestsInTemplate(
            ListServiceQuotaIncreaseRequestsInTemplateRequest listServiceQuotaIncreaseRequestsInTemplateRequest)
            throws AccessDeniedException, DependencyAccessDeniedException, ServiceException, TooManyRequestsException,
            IllegalArgumentException, AwsServiceAccessNotEnabledException, TemplatesNotAvailableInRegionException,
            NoAvailableOrganizationException, AwsServiceException, SdkClientException, ServiceQuotasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the quota increase requests in the specified quota request template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListServiceQuotaIncreaseRequestsInTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link ListServiceQuotaIncreaseRequestsInTemplateRequest#builder()}
     * </p>
     *
     * @param listServiceQuotaIncreaseRequestsInTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest.Builder}
     *        to create a request.
     * @return Result of the ListServiceQuotaIncreaseRequestsInTemplate operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws DependencyAccessDeniedException
     *         You can't perform this action because a dependency does not have access.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws AwsServiceAccessNotEnabledException
     *         The action you attempted is not allowed unless Service Access with Service Quotas is enabled in your
     *         organization.
     * @throws TemplatesNotAvailableInRegionException
     *         The Service Quotas template is not available in this Amazon Web Services Region.
     * @throws NoAvailableOrganizationException
     *         The Amazon Web Services account making this call is not a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.ListServiceQuotaIncreaseRequestsInTemplate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServiceQuotaIncreaseRequestsInTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceQuotaIncreaseRequestsInTemplateResponse listServiceQuotaIncreaseRequestsInTemplate(
            Consumer<ListServiceQuotaIncreaseRequestsInTemplateRequest.Builder> listServiceQuotaIncreaseRequestsInTemplateRequest)
            throws AccessDeniedException, DependencyAccessDeniedException, ServiceException, TooManyRequestsException,
            IllegalArgumentException, AwsServiceAccessNotEnabledException, TemplatesNotAvailableInRegionException,
            NoAvailableOrganizationException, AwsServiceException, SdkClientException, ServiceQuotasException {
        return listServiceQuotaIncreaseRequestsInTemplate(ListServiceQuotaIncreaseRequestsInTemplateRequest.builder()
                .applyMutation(listServiceQuotaIncreaseRequestsInTemplateRequest).build());
    }

    /**
     * <p>
     * Lists the quota increase requests in the specified quota request template.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listServiceQuotaIncreaseRequestsInTemplate(software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotaIncreaseRequestsInTemplateIterable responses = client.listServiceQuotaIncreaseRequestsInTemplatePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotaIncreaseRequestsInTemplateIterable responses = client
     *             .listServiceQuotaIncreaseRequestsInTemplatePaginator(request);
     *     for (software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotaIncreaseRequestsInTemplateIterable responses = client.listServiceQuotaIncreaseRequestsInTemplatePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceQuotaIncreaseRequestsInTemplate(software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceQuotaIncreaseRequestsInTemplateRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws DependencyAccessDeniedException
     *         You can't perform this action because a dependency does not have access.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws AwsServiceAccessNotEnabledException
     *         The action you attempted is not allowed unless Service Access with Service Quotas is enabled in your
     *         organization.
     * @throws TemplatesNotAvailableInRegionException
     *         The Service Quotas template is not available in this Amazon Web Services Region.
     * @throws NoAvailableOrganizationException
     *         The Amazon Web Services account making this call is not a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.ListServiceQuotaIncreaseRequestsInTemplate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServiceQuotaIncreaseRequestsInTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceQuotaIncreaseRequestsInTemplateIterable listServiceQuotaIncreaseRequestsInTemplatePaginator(
            ListServiceQuotaIncreaseRequestsInTemplateRequest listServiceQuotaIncreaseRequestsInTemplateRequest)
            throws AccessDeniedException, DependencyAccessDeniedException, ServiceException, TooManyRequestsException,
            IllegalArgumentException, AwsServiceAccessNotEnabledException, TemplatesNotAvailableInRegionException,
            NoAvailableOrganizationException, AwsServiceException, SdkClientException, ServiceQuotasException {
        return new ListServiceQuotaIncreaseRequestsInTemplateIterable(this, listServiceQuotaIncreaseRequestsInTemplateRequest);
    }

    /**
     * <p>
     * Lists the quota increase requests in the specified quota request template.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listServiceQuotaIncreaseRequestsInTemplate(software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotaIncreaseRequestsInTemplateIterable responses = client.listServiceQuotaIncreaseRequestsInTemplatePaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotaIncreaseRequestsInTemplateIterable responses = client
     *             .listServiceQuotaIncreaseRequestsInTemplatePaginator(request);
     *     for (software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotaIncreaseRequestsInTemplateIterable responses = client.listServiceQuotaIncreaseRequestsInTemplatePaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceQuotaIncreaseRequestsInTemplate(software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListServiceQuotaIncreaseRequestsInTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link ListServiceQuotaIncreaseRequestsInTemplateRequest#builder()}
     * </p>
     *
     * @param listServiceQuotaIncreaseRequestsInTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.ListServiceQuotaIncreaseRequestsInTemplateRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws DependencyAccessDeniedException
     *         You can't perform this action because a dependency does not have access.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws AwsServiceAccessNotEnabledException
     *         The action you attempted is not allowed unless Service Access with Service Quotas is enabled in your
     *         organization.
     * @throws TemplatesNotAvailableInRegionException
     *         The Service Quotas template is not available in this Amazon Web Services Region.
     * @throws NoAvailableOrganizationException
     *         The Amazon Web Services account making this call is not a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.ListServiceQuotaIncreaseRequestsInTemplate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServiceQuotaIncreaseRequestsInTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceQuotaIncreaseRequestsInTemplateIterable listServiceQuotaIncreaseRequestsInTemplatePaginator(
            Consumer<ListServiceQuotaIncreaseRequestsInTemplateRequest.Builder> listServiceQuotaIncreaseRequestsInTemplateRequest)
            throws AccessDeniedException, DependencyAccessDeniedException, ServiceException, TooManyRequestsException,
            IllegalArgumentException, AwsServiceAccessNotEnabledException, TemplatesNotAvailableInRegionException,
            NoAvailableOrganizationException, AwsServiceException, SdkClientException, ServiceQuotasException {
        return listServiceQuotaIncreaseRequestsInTemplatePaginator(ListServiceQuotaIncreaseRequestsInTemplateRequest.builder()
                .applyMutation(listServiceQuotaIncreaseRequestsInTemplateRequest).build());
    }

    /**
     * <p>
     * Lists the applied quota values for the specified Amazon Web Service. For some quotas, only the default values are
     * available. If the applied quota value is not available for a quota, the quota is not retrieved.
     * </p>
     *
     * @param listServiceQuotasRequest
     * @return Result of the ListServiceQuotas operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws NoSuchResourceException
     *         The specified resource does not exist.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws InvalidPaginationTokenException
     *         Invalid input was provided.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.ListServiceQuotas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServiceQuotas"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceQuotasResponse listServiceQuotas(ListServiceQuotasRequest listServiceQuotasRequest)
            throws AccessDeniedException, NoSuchResourceException, IllegalArgumentException, InvalidPaginationTokenException,
            ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the applied quota values for the specified Amazon Web Service. For some quotas, only the default values are
     * available. If the applied quota value is not available for a quota, the quota is not retrieved.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceQuotasRequest.Builder} avoiding the need
     * to create one manually via {@link ListServiceQuotasRequest#builder()}
     * </p>
     *
     * @param listServiceQuotasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasRequest.Builder} to create a
     *        request.
     * @return Result of the ListServiceQuotas operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws NoSuchResourceException
     *         The specified resource does not exist.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws InvalidPaginationTokenException
     *         Invalid input was provided.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.ListServiceQuotas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServiceQuotas"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceQuotasResponse listServiceQuotas(Consumer<ListServiceQuotasRequest.Builder> listServiceQuotasRequest)
            throws AccessDeniedException, NoSuchResourceException, IllegalArgumentException, InvalidPaginationTokenException,
            ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        return listServiceQuotas(ListServiceQuotasRequest.builder().applyMutation(listServiceQuotasRequest).build());
    }

    /**
     * <p>
     * Lists the applied quota values for the specified Amazon Web Service. For some quotas, only the default values are
     * available. If the applied quota value is not available for a quota, the quota is not retrieved.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listServiceQuotas(software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotasIterable responses = client.listServiceQuotasPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotasIterable responses = client
     *             .listServiceQuotasPaginator(request);
     *     for (software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotasIterable responses = client.listServiceQuotasPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceQuotas(software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasRequest)}
     * operation.</b>
     * </p>
     *
     * @param listServiceQuotasRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws NoSuchResourceException
     *         The specified resource does not exist.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws InvalidPaginationTokenException
     *         Invalid input was provided.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.ListServiceQuotas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServiceQuotas"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceQuotasIterable listServiceQuotasPaginator(ListServiceQuotasRequest listServiceQuotasRequest)
            throws AccessDeniedException, NoSuchResourceException, IllegalArgumentException, InvalidPaginationTokenException,
            ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        return new ListServiceQuotasIterable(this, listServiceQuotasRequest);
    }

    /**
     * <p>
     * Lists the applied quota values for the specified Amazon Web Service. For some quotas, only the default values are
     * available. If the applied quota value is not available for a quota, the quota is not retrieved.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listServiceQuotas(software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotasIterable responses = client.listServiceQuotasPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotasIterable responses = client
     *             .listServiceQuotasPaginator(request);
     *     for (software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListServiceQuotasIterable responses = client.listServiceQuotasPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServiceQuotas(software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServiceQuotasRequest.Builder} avoiding the need
     * to create one manually via {@link ListServiceQuotasRequest#builder()}
     * </p>
     *
     * @param listServiceQuotasRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws NoSuchResourceException
     *         The specified resource does not exist.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws InvalidPaginationTokenException
     *         Invalid input was provided.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.ListServiceQuotas
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServiceQuotas"
     *      target="_top">AWS API Documentation</a>
     */
    default ListServiceQuotasIterable listServiceQuotasPaginator(
            Consumer<ListServiceQuotasRequest.Builder> listServiceQuotasRequest) throws AccessDeniedException,
            NoSuchResourceException, IllegalArgumentException, InvalidPaginationTokenException, ServiceException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        return listServiceQuotasPaginator(ListServiceQuotasRequest.builder().applyMutation(listServiceQuotasRequest).build());
    }

    /**
     * <p>
     * Lists the names and codes for the Amazon Web Services integrated with Service Quotas.
     * </p>
     *
     * @param listServicesRequest
     * @return Result of the ListServices operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws InvalidPaginationTokenException
     *         Invalid input was provided.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.ListServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServices" target="_top">AWS
     *      API Documentation</a>
     */
    default ListServicesResponse listServices(ListServicesRequest listServicesRequest) throws AccessDeniedException,
            IllegalArgumentException, InvalidPaginationTokenException, ServiceException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ServiceQuotasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the names and codes for the Amazon Web Services integrated with Service Quotas.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListServicesRequest#builder()}
     * </p>
     *
     * @param listServicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.ListServicesRequest.Builder} to create a
     *        request.
     * @return Result of the ListServices operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws InvalidPaginationTokenException
     *         Invalid input was provided.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.ListServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServices" target="_top">AWS
     *      API Documentation</a>
     */
    default ListServicesResponse listServices(Consumer<ListServicesRequest.Builder> listServicesRequest)
            throws AccessDeniedException, IllegalArgumentException, InvalidPaginationTokenException, ServiceException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        return listServices(ListServicesRequest.builder().applyMutation(listServicesRequest).build());
    }

    /**
     * <p>
     * Lists the names and codes for the Amazon Web Services integrated with Service Quotas.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listServices(software.amazon.awssdk.services.servicequotas.model.ListServicesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListServicesIterable responses = client.listServicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicequotas.paginators.ListServicesIterable responses = client
     *             .listServicesPaginator(request);
     *     for (software.amazon.awssdk.services.servicequotas.model.ListServicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListServicesIterable responses = client.listServicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServices(software.amazon.awssdk.services.servicequotas.model.ListServicesRequest)} operation.</b>
     * </p>
     *
     * @param listServicesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws InvalidPaginationTokenException
     *         Invalid input was provided.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.ListServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServices" target="_top">AWS
     *      API Documentation</a>
     */
    default ListServicesIterable listServicesPaginator(ListServicesRequest listServicesRequest) throws AccessDeniedException,
            IllegalArgumentException, InvalidPaginationTokenException, ServiceException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ServiceQuotasException {
        return new ListServicesIterable(this, listServicesRequest);
    }

    /**
     * <p>
     * Lists the names and codes for the Amazon Web Services integrated with Service Quotas.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listServices(software.amazon.awssdk.services.servicequotas.model.ListServicesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListServicesIterable responses = client.listServicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicequotas.paginators.ListServicesIterable responses = client
     *             .listServicesPaginator(request);
     *     for (software.amazon.awssdk.services.servicequotas.model.ListServicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicequotas.paginators.ListServicesIterable responses = client.listServicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServices(software.amazon.awssdk.services.servicequotas.model.ListServicesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListServicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListServicesRequest#builder()}
     * </p>
     *
     * @param listServicesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.ListServicesRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws InvalidPaginationTokenException
     *         Invalid input was provided.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.ListServices
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListServices" target="_top">AWS
     *      API Documentation</a>
     */
    default ListServicesIterable listServicesPaginator(Consumer<ListServicesRequest.Builder> listServicesRequest)
            throws AccessDeniedException, IllegalArgumentException, InvalidPaginationTokenException, ServiceException,
            TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        return listServicesPaginator(ListServicesRequest.builder().applyMutation(listServicesRequest).build());
    }

    /**
     * <p>
     * Returns a list of the tags assigned to the specified applied quota.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws NoSuchResourceException
     *         The specified resource does not exist.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws ServiceException
     *         Something went wrong.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws TooManyRequestsException, NoSuchResourceException, IllegalArgumentException, AccessDeniedException,
            ServiceException, AwsServiceException, SdkClientException, ServiceQuotasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the tags assigned to the specified applied quota.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws NoSuchResourceException
     *         The specified resource does not exist.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws ServiceException
     *         Something went wrong.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws TooManyRequestsException,
            NoSuchResourceException, IllegalArgumentException, AccessDeniedException, ServiceException, AwsServiceException,
            SdkClientException, ServiceQuotasException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Adds a quota increase request to your quota request template.
     * </p>
     *
     * @param putServiceQuotaIncreaseRequestIntoTemplateRequest
     * @return Result of the PutServiceQuotaIncreaseRequestIntoTemplate operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws DependencyAccessDeniedException
     *         You can't perform this action because a dependency does not have access.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws QuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use Service Quotas to request a service quota increase.
     * @throws NoSuchResourceException
     *         The specified resource does not exist.
     * @throws AwsServiceAccessNotEnabledException
     *         The action you attempted is not allowed unless Service Access with Service Quotas is enabled in your
     *         organization.
     * @throws TemplatesNotAvailableInRegionException
     *         The Service Quotas template is not available in this Amazon Web Services Region.
     * @throws NoAvailableOrganizationException
     *         The Amazon Web Services account making this call is not a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.PutServiceQuotaIncreaseRequestIntoTemplate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/PutServiceQuotaIncreaseRequestIntoTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default PutServiceQuotaIncreaseRequestIntoTemplateResponse putServiceQuotaIncreaseRequestIntoTemplate(
            PutServiceQuotaIncreaseRequestIntoTemplateRequest putServiceQuotaIncreaseRequestIntoTemplateRequest)
            throws AccessDeniedException, DependencyAccessDeniedException, ServiceException, TooManyRequestsException,
            IllegalArgumentException, QuotaExceededException, NoSuchResourceException, AwsServiceAccessNotEnabledException,
            TemplatesNotAvailableInRegionException, NoAvailableOrganizationException, AwsServiceException, SdkClientException,
            ServiceQuotasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a quota increase request to your quota request template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link PutServiceQuotaIncreaseRequestIntoTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link PutServiceQuotaIncreaseRequestIntoTemplateRequest#builder()}
     * </p>
     *
     * @param putServiceQuotaIncreaseRequestIntoTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.PutServiceQuotaIncreaseRequestIntoTemplateRequest.Builder}
     *        to create a request.
     * @return Result of the PutServiceQuotaIncreaseRequestIntoTemplate operation returned by the service.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws DependencyAccessDeniedException
     *         You can't perform this action because a dependency does not have access.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws QuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use Service Quotas to request a service quota increase.
     * @throws NoSuchResourceException
     *         The specified resource does not exist.
     * @throws AwsServiceAccessNotEnabledException
     *         The action you attempted is not allowed unless Service Access with Service Quotas is enabled in your
     *         organization.
     * @throws TemplatesNotAvailableInRegionException
     *         The Service Quotas template is not available in this Amazon Web Services Region.
     * @throws NoAvailableOrganizationException
     *         The Amazon Web Services account making this call is not a member of an organization.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.PutServiceQuotaIncreaseRequestIntoTemplate
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/PutServiceQuotaIncreaseRequestIntoTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default PutServiceQuotaIncreaseRequestIntoTemplateResponse putServiceQuotaIncreaseRequestIntoTemplate(
            Consumer<PutServiceQuotaIncreaseRequestIntoTemplateRequest.Builder> putServiceQuotaIncreaseRequestIntoTemplateRequest)
            throws AccessDeniedException, DependencyAccessDeniedException, ServiceException, TooManyRequestsException,
            IllegalArgumentException, QuotaExceededException, NoSuchResourceException, AwsServiceAccessNotEnabledException,
            TemplatesNotAvailableInRegionException, NoAvailableOrganizationException, AwsServiceException, SdkClientException,
            ServiceQuotasException {
        return putServiceQuotaIncreaseRequestIntoTemplate(PutServiceQuotaIncreaseRequestIntoTemplateRequest.builder()
                .applyMutation(putServiceQuotaIncreaseRequestIntoTemplateRequest).build());
    }

    /**
     * <p>
     * Submits a quota increase request for the specified quota.
     * </p>
     *
     * @param requestServiceQuotaIncreaseRequest
     * @return Result of the RequestServiceQuotaIncrease operation returned by the service.
     * @throws DependencyAccessDeniedException
     *         You can't perform this action because a dependency does not have access.
     * @throws QuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use Service Quotas to request a service quota increase.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws NoSuchResourceException
     *         The specified resource does not exist.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws InvalidResourceStateException
     *         The resource is in an invalid state.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.RequestServiceQuotaIncrease
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/RequestServiceQuotaIncrease"
     *      target="_top">AWS API Documentation</a>
     */
    default RequestServiceQuotaIncreaseResponse requestServiceQuotaIncrease(
            RequestServiceQuotaIncreaseRequest requestServiceQuotaIncreaseRequest) throws DependencyAccessDeniedException,
            QuotaExceededException, ResourceAlreadyExistsException, AccessDeniedException, NoSuchResourceException,
            IllegalArgumentException, InvalidResourceStateException, ServiceException, TooManyRequestsException,
            AwsServiceException, SdkClientException, ServiceQuotasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Submits a quota increase request for the specified quota.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RequestServiceQuotaIncreaseRequest.Builder}
     * avoiding the need to create one manually via {@link RequestServiceQuotaIncreaseRequest#builder()}
     * </p>
     *
     * @param requestServiceQuotaIncreaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.RequestServiceQuotaIncreaseRequest.Builder} to
     *        create a request.
     * @return Result of the RequestServiceQuotaIncrease operation returned by the service.
     * @throws DependencyAccessDeniedException
     *         You can't perform this action because a dependency does not have access.
     * @throws QuotaExceededException
     *         You have exceeded your service quota. To perform the requested action, remove some of the relevant
     *         resources, or use Service Quotas to request a service quota increase.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws NoSuchResourceException
     *         The specified resource does not exist.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws InvalidResourceStateException
     *         The resource is in an invalid state.
     * @throws ServiceException
     *         Something went wrong.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.RequestServiceQuotaIncrease
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/RequestServiceQuotaIncrease"
     *      target="_top">AWS API Documentation</a>
     */
    default RequestServiceQuotaIncreaseResponse requestServiceQuotaIncrease(
            Consumer<RequestServiceQuotaIncreaseRequest.Builder> requestServiceQuotaIncreaseRequest)
            throws DependencyAccessDeniedException, QuotaExceededException, ResourceAlreadyExistsException,
            AccessDeniedException, NoSuchResourceException, IllegalArgumentException, InvalidResourceStateException,
            ServiceException, TooManyRequestsException, AwsServiceException, SdkClientException, ServiceQuotasException {
        return requestServiceQuotaIncrease(RequestServiceQuotaIncreaseRequest.builder()
                .applyMutation(requestServiceQuotaIncreaseRequest).build());
    }

    /**
     * <p>
     * Adds tags to the specified applied quota. You can include one or more tags to add to the quota.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws NoSuchResourceException
     *         The specified resource does not exist.
     * @throws TooManyTagsException
     *         You've exceeded the number of tags allowed for a resource. For more information, see <a href=
     *         "https://docs.aws.amazon.com/servicequotas/latest/userguide/sq-tagging.html#sq-tagging-restrictions">Tag
     *         restrictions</a> in the <i>Service Quotas User Guide</i>.
     * @throws TagPolicyViolationException
     *         The specified tag is a reserved word and cannot be used.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws ServiceException
     *         Something went wrong.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws TooManyRequestsException,
            NoSuchResourceException, TooManyTagsException, TagPolicyViolationException, IllegalArgumentException,
            AccessDeniedException, ServiceException, AwsServiceException, SdkClientException, ServiceQuotasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds tags to the specified applied quota. You can include one or more tags to add to the quota.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the TagResource operation returned by the service.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws NoSuchResourceException
     *         The specified resource does not exist.
     * @throws TooManyTagsException
     *         You've exceeded the number of tags allowed for a resource. For more information, see <a href=
     *         "https://docs.aws.amazon.com/servicequotas/latest/userguide/sq-tagging.html#sq-tagging-restrictions">Tag
     *         restrictions</a> in the <i>Service Quotas User Guide</i>.
     * @throws TagPolicyViolationException
     *         The specified tag is a reserved word and cannot be used.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws ServiceException
     *         Something went wrong.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/TagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws TooManyRequestsException, NoSuchResourceException, TooManyTagsException, TagPolicyViolationException,
            IllegalArgumentException, AccessDeniedException, ServiceException, AwsServiceException, SdkClientException,
            ServiceQuotasException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from the specified applied quota. You can specify one or more tags to remove.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws NoSuchResourceException
     *         The specified resource does not exist.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws ServiceException
     *         Something went wrong.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws TooManyRequestsException,
            NoSuchResourceException, IllegalArgumentException, AccessDeniedException, ServiceException, AwsServiceException,
            SdkClientException, ServiceQuotasException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from the specified applied quota. You can specify one or more tags to remove.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.servicequotas.model.UntagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws TooManyRequestsException
     *         Due to throttling, the request was denied. Slow down the rate of request calls, or request an increase
     *         for this quota.
     * @throws NoSuchResourceException
     *         The specified resource does not exist.
     * @throws IllegalArgumentException
     *         Invalid input was provided.
     * @throws AccessDeniedException
     *         You do not have sufficient permission to perform this action.
     * @throws ServiceException
     *         Something went wrong.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceQuotasException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceQuotasClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/service-quotas-2019-06-24/UntagResource" target="_top">AWS
     *      API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws TooManyRequestsException, NoSuchResourceException, IllegalArgumentException, AccessDeniedException,
            ServiceException, AwsServiceException, SdkClientException, ServiceQuotasException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * Create a {@link ServiceQuotasClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ServiceQuotasClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ServiceQuotasClient}.
     */
    static ServiceQuotasClientBuilder builder() {
        return new DefaultServiceQuotasClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default ServiceQuotasServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
