/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicequotas.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.servicequotas.ServiceQuotasClient;
import software.amazon.awssdk.services.servicequotas.internal.UserAgentUtils;
import software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasRequest;
import software.amazon.awssdk.services.servicequotas.model.ListServiceQuotasResponse;
import software.amazon.awssdk.services.servicequotas.model.ServiceQuota;

public class ListServiceQuotasIterable
implements SdkIterable<ListServiceQuotasResponse> {
    private final ServiceQuotasClient client;
    private final ListServiceQuotasRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListServiceQuotasIterable(ServiceQuotasClient client, ListServiceQuotasRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListServiceQuotasResponseFetcher();
    }

    public Iterator<ListServiceQuotasResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ServiceQuota> quotas() {
        Function<ListServiceQuotasResponse, Iterator> getIterator = response -> {
            if (response != null && response.quotas() != null) {
                return response.quotas().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListServiceQuotasResponseFetcher
    implements SyncPageFetcher<ListServiceQuotasResponse> {
        private ListServiceQuotasResponseFetcher() {
        }

        public boolean hasNextPage(ListServiceQuotasResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListServiceQuotasResponse nextPage(ListServiceQuotasResponse previousPage) {
            if (previousPage == null) {
                return ListServiceQuotasIterable.this.client.listServiceQuotas(ListServiceQuotasIterable.this.firstRequest);
            }
            return ListServiceQuotasIterable.this.client.listServiceQuotas((ListServiceQuotasRequest)((Object)ListServiceQuotasIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

