/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicequotas.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a quota.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceQuota implements SdkPojo, Serializable, ToCopyableBuilder<ServiceQuota.Builder, ServiceQuota> {
    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceCode").getter(getter(ServiceQuota::serviceCode)).setter(setter(Builder::serviceCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCode").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceName").getter(getter(ServiceQuota::serviceName)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()).build();

    private static final SdkField<String> QUOTA_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuotaArn").getter(getter(ServiceQuota::quotaArn)).setter(setter(Builder::quotaArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuotaArn").build()).build();

    private static final SdkField<String> QUOTA_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuotaCode").getter(getter(ServiceQuota::quotaCode)).setter(setter(Builder::quotaCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuotaCode").build()).build();

    private static final SdkField<String> QUOTA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("QuotaName").getter(getter(ServiceQuota::quotaName)).setter(setter(Builder::quotaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuotaName").build()).build();

    private static final SdkField<Double> VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE).memberName("Value")
            .getter(getter(ServiceQuota::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Unit")
            .getter(getter(ServiceQuota::unit)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()).build();

    private static final SdkField<Boolean> ADJUSTABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Adjustable").getter(getter(ServiceQuota::adjustable)).setter(setter(Builder::adjustable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Adjustable").build()).build();

    private static final SdkField<Boolean> GLOBAL_QUOTA_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("GlobalQuota").getter(getter(ServiceQuota::globalQuota)).setter(setter(Builder::globalQuota))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalQuota").build()).build();

    private static final SdkField<MetricInfo> USAGE_METRIC_FIELD = SdkField.<MetricInfo> builder(MarshallingType.SDK_POJO)
            .memberName("UsageMetric").getter(getter(ServiceQuota::usageMetric)).setter(setter(Builder::usageMetric))
            .constructor(MetricInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsageMetric").build()).build();

    private static final SdkField<QuotaPeriod> PERIOD_FIELD = SdkField.<QuotaPeriod> builder(MarshallingType.SDK_POJO)
            .memberName("Period").getter(getter(ServiceQuota::period)).setter(setter(Builder::period))
            .constructor(QuotaPeriod::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period").build()).build();

    private static final SdkField<ErrorReason> ERROR_REASON_FIELD = SdkField.<ErrorReason> builder(MarshallingType.SDK_POJO)
            .memberName("ErrorReason").getter(getter(ServiceQuota::errorReason)).setter(setter(Builder::errorReason))
            .constructor(ErrorReason::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_CODE_FIELD,
            SERVICE_NAME_FIELD, QUOTA_ARN_FIELD, QUOTA_CODE_FIELD, QUOTA_NAME_FIELD, VALUE_FIELD, UNIT_FIELD, ADJUSTABLE_FIELD,
            GLOBAL_QUOTA_FIELD, USAGE_METRIC_FIELD, PERIOD_FIELD, ERROR_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serviceCode;

    private final String serviceName;

    private final String quotaArn;

    private final String quotaCode;

    private final String quotaName;

    private final Double value;

    private final String unit;

    private final Boolean adjustable;

    private final Boolean globalQuota;

    private final MetricInfo usageMetric;

    private final QuotaPeriod period;

    private final ErrorReason errorReason;

    private ServiceQuota(BuilderImpl builder) {
        this.serviceCode = builder.serviceCode;
        this.serviceName = builder.serviceName;
        this.quotaArn = builder.quotaArn;
        this.quotaCode = builder.quotaCode;
        this.quotaName = builder.quotaName;
        this.value = builder.value;
        this.unit = builder.unit;
        this.adjustable = builder.adjustable;
        this.globalQuota = builder.globalQuota;
        this.usageMetric = builder.usageMetric;
        this.period = builder.period;
        this.errorReason = builder.errorReason;
    }

    /**
     * <p>
     * The service identifier.
     * </p>
     * 
     * @return The service identifier.
     */
    public final String serviceCode() {
        return serviceCode;
    }

    /**
     * <p>
     * The service name.
     * </p>
     * 
     * @return The service name.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the quota.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the quota.
     */
    public final String quotaArn() {
        return quotaArn;
    }

    /**
     * <p>
     * The quota identifier.
     * </p>
     * 
     * @return The quota identifier.
     */
    public final String quotaCode() {
        return quotaCode;
    }

    /**
     * <p>
     * The quota name.
     * </p>
     * 
     * @return The quota name.
     */
    public final String quotaName() {
        return quotaName;
    }

    /**
     * <p>
     * The quota value.
     * </p>
     * 
     * @return The quota value.
     */
    public final Double value() {
        return value;
    }

    /**
     * <p>
     * The unit of measurement.
     * </p>
     * 
     * @return The unit of measurement.
     */
    public final String unit() {
        return unit;
    }

    /**
     * <p>
     * Indicates whether the quota value can be increased.
     * </p>
     * 
     * @return Indicates whether the quota value can be increased.
     */
    public final Boolean adjustable() {
        return adjustable;
    }

    /**
     * <p>
     * Indicates whether the quota is global.
     * </p>
     * 
     * @return Indicates whether the quota is global.
     */
    public final Boolean globalQuota() {
        return globalQuota;
    }

    /**
     * <p>
     * Information about the measurement.
     * </p>
     * 
     * @return Information about the measurement.
     */
    public final MetricInfo usageMetric() {
        return usageMetric;
    }

    /**
     * <p>
     * The period of time.
     * </p>
     * 
     * @return The period of time.
     */
    public final QuotaPeriod period() {
        return period;
    }

    /**
     * <p>
     * The error code and error reason.
     * </p>
     * 
     * @return The error code and error reason.
     */
    public final ErrorReason errorReason() {
        return errorReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(quotaArn());
        hashCode = 31 * hashCode + Objects.hashCode(quotaCode());
        hashCode = 31 * hashCode + Objects.hashCode(quotaName());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(unit());
        hashCode = 31 * hashCode + Objects.hashCode(adjustable());
        hashCode = 31 * hashCode + Objects.hashCode(globalQuota());
        hashCode = 31 * hashCode + Objects.hashCode(usageMetric());
        hashCode = 31 * hashCode + Objects.hashCode(period());
        hashCode = 31 * hashCode + Objects.hashCode(errorReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceQuota)) {
            return false;
        }
        ServiceQuota other = (ServiceQuota) obj;
        return Objects.equals(serviceCode(), other.serviceCode()) && Objects.equals(serviceName(), other.serviceName())
                && Objects.equals(quotaArn(), other.quotaArn()) && Objects.equals(quotaCode(), other.quotaCode())
                && Objects.equals(quotaName(), other.quotaName()) && Objects.equals(value(), other.value())
                && Objects.equals(unit(), other.unit()) && Objects.equals(adjustable(), other.adjustable())
                && Objects.equals(globalQuota(), other.globalQuota()) && Objects.equals(usageMetric(), other.usageMetric())
                && Objects.equals(period(), other.period()) && Objects.equals(errorReason(), other.errorReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceQuota").add("ServiceCode", serviceCode()).add("ServiceName", serviceName())
                .add("QuotaArn", quotaArn()).add("QuotaCode", quotaCode()).add("QuotaName", quotaName()).add("Value", value())
                .add("Unit", unit()).add("Adjustable", adjustable()).add("GlobalQuota", globalQuota())
                .add("UsageMetric", usageMetric()).add("Period", period()).add("ErrorReason", errorReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceCode":
            return Optional.ofNullable(clazz.cast(serviceCode()));
        case "ServiceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "QuotaArn":
            return Optional.ofNullable(clazz.cast(quotaArn()));
        case "QuotaCode":
            return Optional.ofNullable(clazz.cast(quotaCode()));
        case "QuotaName":
            return Optional.ofNullable(clazz.cast(quotaName()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Unit":
            return Optional.ofNullable(clazz.cast(unit()));
        case "Adjustable":
            return Optional.ofNullable(clazz.cast(adjustable()));
        case "GlobalQuota":
            return Optional.ofNullable(clazz.cast(globalQuota()));
        case "UsageMetric":
            return Optional.ofNullable(clazz.cast(usageMetric()));
        case "Period":
            return Optional.ofNullable(clazz.cast(period()));
        case "ErrorReason":
            return Optional.ofNullable(clazz.cast(errorReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceQuota, T> g) {
        return obj -> g.apply((ServiceQuota) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceQuota> {
        /**
         * <p>
         * The service identifier.
         * </p>
         * 
         * @param serviceCode
         *        The service identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCode(String serviceCode);

        /**
         * <p>
         * The service name.
         * </p>
         * 
         * @param serviceName
         *        The service name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the quota.
         * </p>
         * 
         * @param quotaArn
         *        The Amazon Resource Name (ARN) of the quota.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quotaArn(String quotaArn);

        /**
         * <p>
         * The quota identifier.
         * </p>
         * 
         * @param quotaCode
         *        The quota identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quotaCode(String quotaCode);

        /**
         * <p>
         * The quota name.
         * </p>
         * 
         * @param quotaName
         *        The quota name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quotaName(String quotaName);

        /**
         * <p>
         * The quota value.
         * </p>
         * 
         * @param value
         *        The quota value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(Double value);

        /**
         * <p>
         * The unit of measurement.
         * </p>
         * 
         * @param unit
         *        The unit of measurement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unit(String unit);

        /**
         * <p>
         * Indicates whether the quota value can be increased.
         * </p>
         * 
         * @param adjustable
         *        Indicates whether the quota value can be increased.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adjustable(Boolean adjustable);

        /**
         * <p>
         * Indicates whether the quota is global.
         * </p>
         * 
         * @param globalQuota
         *        Indicates whether the quota is global.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalQuota(Boolean globalQuota);

        /**
         * <p>
         * Information about the measurement.
         * </p>
         * 
         * @param usageMetric
         *        Information about the measurement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usageMetric(MetricInfo usageMetric);

        /**
         * <p>
         * Information about the measurement.
         * </p>
         * This is a convenience method that creates an instance of the {@link MetricInfo.Builder} avoiding the need to
         * create one manually via {@link MetricInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link MetricInfo.Builder#build()} is called immediately and its result
         * is passed to {@link #usageMetric(MetricInfo)}.
         * 
         * @param usageMetric
         *        a consumer that will call methods on {@link MetricInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #usageMetric(MetricInfo)
         */
        default Builder usageMetric(Consumer<MetricInfo.Builder> usageMetric) {
            return usageMetric(MetricInfo.builder().applyMutation(usageMetric).build());
        }

        /**
         * <p>
         * The period of time.
         * </p>
         * 
         * @param period
         *        The period of time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder period(QuotaPeriod period);

        /**
         * <p>
         * The period of time.
         * </p>
         * This is a convenience method that creates an instance of the {@link QuotaPeriod.Builder} avoiding the need to
         * create one manually via {@link QuotaPeriod#builder()}.
         *
         * When the {@link Consumer} completes, {@link QuotaPeriod.Builder#build()} is called immediately and its result
         * is passed to {@link #period(QuotaPeriod)}.
         * 
         * @param period
         *        a consumer that will call methods on {@link QuotaPeriod.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #period(QuotaPeriod)
         */
        default Builder period(Consumer<QuotaPeriod.Builder> period) {
            return period(QuotaPeriod.builder().applyMutation(period).build());
        }

        /**
         * <p>
         * The error code and error reason.
         * </p>
         * 
         * @param errorReason
         *        The error code and error reason.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorReason(ErrorReason errorReason);

        /**
         * <p>
         * The error code and error reason.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorReason.Builder} avoiding the need to
         * create one manually via {@link ErrorReason#builder()}.
         *
         * When the {@link Consumer} completes, {@link ErrorReason.Builder#build()} is called immediately and its result
         * is passed to {@link #errorReason(ErrorReason)}.
         * 
         * @param errorReason
         *        a consumer that will call methods on {@link ErrorReason.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorReason(ErrorReason)
         */
        default Builder errorReason(Consumer<ErrorReason.Builder> errorReason) {
            return errorReason(ErrorReason.builder().applyMutation(errorReason).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String serviceCode;

        private String serviceName;

        private String quotaArn;

        private String quotaCode;

        private String quotaName;

        private Double value;

        private String unit;

        private Boolean adjustable;

        private Boolean globalQuota;

        private MetricInfo usageMetric;

        private QuotaPeriod period;

        private ErrorReason errorReason;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceQuota model) {
            serviceCode(model.serviceCode);
            serviceName(model.serviceName);
            quotaArn(model.quotaArn);
            quotaCode(model.quotaCode);
            quotaName(model.quotaName);
            value(model.value);
            unit(model.unit);
            adjustable(model.adjustable);
            globalQuota(model.globalQuota);
            usageMetric(model.usageMetric);
            period(model.period);
            errorReason(model.errorReason);
        }

        public final String getServiceCode() {
            return serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final String getQuotaArn() {
            return quotaArn;
        }

        public final void setQuotaArn(String quotaArn) {
            this.quotaArn = quotaArn;
        }

        @Override
        public final Builder quotaArn(String quotaArn) {
            this.quotaArn = quotaArn;
            return this;
        }

        public final String getQuotaCode() {
            return quotaCode;
        }

        public final void setQuotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
        }

        @Override
        public final Builder quotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
            return this;
        }

        public final String getQuotaName() {
            return quotaName;
        }

        public final void setQuotaName(String quotaName) {
            this.quotaName = quotaName;
        }

        @Override
        public final Builder quotaName(String quotaName) {
            this.quotaName = quotaName;
            return this;
        }

        public final Double getValue() {
            return value;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        public final String getUnit() {
            return unit;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final Boolean getAdjustable() {
            return adjustable;
        }

        public final void setAdjustable(Boolean adjustable) {
            this.adjustable = adjustable;
        }

        @Override
        public final Builder adjustable(Boolean adjustable) {
            this.adjustable = adjustable;
            return this;
        }

        public final Boolean getGlobalQuota() {
            return globalQuota;
        }

        public final void setGlobalQuota(Boolean globalQuota) {
            this.globalQuota = globalQuota;
        }

        @Override
        public final Builder globalQuota(Boolean globalQuota) {
            this.globalQuota = globalQuota;
            return this;
        }

        public final MetricInfo.Builder getUsageMetric() {
            return usageMetric != null ? usageMetric.toBuilder() : null;
        }

        public final void setUsageMetric(MetricInfo.BuilderImpl usageMetric) {
            this.usageMetric = usageMetric != null ? usageMetric.build() : null;
        }

        @Override
        public final Builder usageMetric(MetricInfo usageMetric) {
            this.usageMetric = usageMetric;
            return this;
        }

        public final QuotaPeriod.Builder getPeriod() {
            return period != null ? period.toBuilder() : null;
        }

        public final void setPeriod(QuotaPeriod.BuilderImpl period) {
            this.period = period != null ? period.build() : null;
        }

        @Override
        public final Builder period(QuotaPeriod period) {
            this.period = period;
            return this;
        }

        public final ErrorReason.Builder getErrorReason() {
            return errorReason != null ? errorReason.toBuilder() : null;
        }

        public final void setErrorReason(ErrorReason.BuilderImpl errorReason) {
            this.errorReason = errorReason != null ? errorReason.build() : null;
        }

        @Override
        public final Builder errorReason(ErrorReason errorReason) {
            this.errorReason = errorReason;
            return this;
        }

        @Override
        public ServiceQuota build() {
            return new ServiceQuota(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
