/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicequotas.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetRequestedServiceQuotaChangeResponse extends ServiceQuotasResponse implements
        ToCopyableBuilder<GetRequestedServiceQuotaChangeResponse.Builder, GetRequestedServiceQuotaChangeResponse> {
    private static final SdkField<RequestedServiceQuotaChange> REQUESTED_QUOTA_FIELD = SdkField
            .<RequestedServiceQuotaChange> builder(MarshallingType.SDK_POJO).memberName("RequestedQuota")
            .getter(getter(GetRequestedServiceQuotaChangeResponse::requestedQuota)).setter(setter(Builder::requestedQuota))
            .constructor(RequestedServiceQuotaChange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedQuota").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUESTED_QUOTA_FIELD));

    private final RequestedServiceQuotaChange requestedQuota;

    private GetRequestedServiceQuotaChangeResponse(BuilderImpl builder) {
        super(builder);
        this.requestedQuota = builder.requestedQuota;
    }

    /**
     * <p>
     * Information about the quota increase request.
     * </p>
     * 
     * @return Information about the quota increase request.
     */
    public final RequestedServiceQuotaChange requestedQuota() {
        return requestedQuota;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(requestedQuota());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetRequestedServiceQuotaChangeResponse)) {
            return false;
        }
        GetRequestedServiceQuotaChangeResponse other = (GetRequestedServiceQuotaChangeResponse) obj;
        return Objects.equals(requestedQuota(), other.requestedQuota());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetRequestedServiceQuotaChangeResponse").add("RequestedQuota", requestedQuota()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RequestedQuota":
            return Optional.ofNullable(clazz.cast(requestedQuota()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetRequestedServiceQuotaChangeResponse, T> g) {
        return obj -> g.apply((GetRequestedServiceQuotaChangeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceQuotasResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetRequestedServiceQuotaChangeResponse> {
        /**
         * <p>
         * Information about the quota increase request.
         * </p>
         * 
         * @param requestedQuota
         *        Information about the quota increase request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedQuota(RequestedServiceQuotaChange requestedQuota);

        /**
         * <p>
         * Information about the quota increase request.
         * </p>
         * This is a convenience method that creates an instance of the {@link RequestedServiceQuotaChange.Builder}
         * avoiding the need to create one manually via {@link RequestedServiceQuotaChange#builder()}.
         *
         * When the {@link Consumer} completes, {@link RequestedServiceQuotaChange.Builder#build()} is called
         * immediately and its result is passed to {@link #requestedQuota(RequestedServiceQuotaChange)}.
         * 
         * @param requestedQuota
         *        a consumer that will call methods on {@link RequestedServiceQuotaChange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requestedQuota(RequestedServiceQuotaChange)
         */
        default Builder requestedQuota(Consumer<RequestedServiceQuotaChange.Builder> requestedQuota) {
            return requestedQuota(RequestedServiceQuotaChange.builder().applyMutation(requestedQuota).build());
        }
    }

    static final class BuilderImpl extends ServiceQuotasResponse.BuilderImpl implements Builder {
        private RequestedServiceQuotaChange requestedQuota;

        private BuilderImpl() {
        }

        private BuilderImpl(GetRequestedServiceQuotaChangeResponse model) {
            super(model);
            requestedQuota(model.requestedQuota);
        }

        public final RequestedServiceQuotaChange.Builder getRequestedQuota() {
            return requestedQuota != null ? requestedQuota.toBuilder() : null;
        }

        public final void setRequestedQuota(RequestedServiceQuotaChange.BuilderImpl requestedQuota) {
            this.requestedQuota = requestedQuota != null ? requestedQuota.build() : null;
        }

        @Override
        public final Builder requestedQuota(RequestedServiceQuotaChange requestedQuota) {
            this.requestedQuota = requestedQuota;
            return this;
        }

        @Override
        public GetRequestedServiceQuotaChangeResponse build() {
            return new GetRequestedServiceQuotaChangeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
