/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicequotas.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicequotas.model.PeriodUnit;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QuotaPeriod
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, QuotaPeriod> {
    private static final SdkField<Integer> PERIOD_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PeriodValue").getter(QuotaPeriod.getter(QuotaPeriod::periodValue)).setter(QuotaPeriod.setter(Builder::periodValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeriodValue").build()}).build();
    private static final SdkField<String> PERIOD_UNIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PeriodUnit").getter(QuotaPeriod.getter(QuotaPeriod::periodUnitAsString)).setter(QuotaPeriod.setter(Builder::periodUnit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeriodUnit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERIOD_VALUE_FIELD, PERIOD_UNIT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer periodValue;
    private final String periodUnit;

    private QuotaPeriod(BuilderImpl builder) {
        this.periodValue = builder.periodValue;
        this.periodUnit = builder.periodUnit;
    }

    public final Integer periodValue() {
        return this.periodValue;
    }

    public final PeriodUnit periodUnit() {
        return PeriodUnit.fromValue(this.periodUnit);
    }

    public final String periodUnitAsString() {
        return this.periodUnit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.periodValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.periodUnitAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuotaPeriod)) {
            return false;
        }
        QuotaPeriod other = (QuotaPeriod)obj;
        return Objects.equals(this.periodValue(), other.periodValue()) && Objects.equals(this.periodUnitAsString(), other.periodUnitAsString());
    }

    public final String toString() {
        return ToString.builder((String)"QuotaPeriod").add("PeriodValue", (Object)this.periodValue()).add("PeriodUnit", (Object)this.periodUnitAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PeriodValue": {
                return Optional.ofNullable(clazz.cast(this.periodValue()));
            }
            case "PeriodUnit": {
                return Optional.ofNullable(clazz.cast(this.periodUnitAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<QuotaPeriod, T> g) {
        return obj -> g.apply((QuotaPeriod)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer periodValue;
        private String periodUnit;

        private BuilderImpl() {
        }

        private BuilderImpl(QuotaPeriod model) {
            this.periodValue(model.periodValue);
            this.periodUnit(model.periodUnit);
        }

        public final Integer getPeriodValue() {
            return this.periodValue;
        }

        public final void setPeriodValue(Integer periodValue) {
            this.periodValue = periodValue;
        }

        @Override
        @Transient
        public final Builder periodValue(Integer periodValue) {
            this.periodValue = periodValue;
            return this;
        }

        public final String getPeriodUnit() {
            return this.periodUnit;
        }

        public final void setPeriodUnit(String periodUnit) {
            this.periodUnit = periodUnit;
        }

        @Override
        @Transient
        public final Builder periodUnit(String periodUnit) {
            this.periodUnit = periodUnit;
            return this;
        }

        @Override
        @Transient
        public final Builder periodUnit(PeriodUnit periodUnit) {
            this.periodUnit(periodUnit == null ? null : periodUnit.toString());
            return this;
        }

        public QuotaPeriod build() {
            return new QuotaPeriod(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, QuotaPeriod> {
        public Builder periodValue(Integer var1);

        public Builder periodUnit(String var1);

        public Builder periodUnit(PeriodUnit var1);
    }
}

