/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicequotas.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.servicequotas.model.ServiceInfo;
import software.amazon.awssdk.services.servicequotas.model.ServiceInfoListDefinitionCopier;
import software.amazon.awssdk.services.servicequotas.model.ServiceQuotasResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListServicesResponse
extends ServiceQuotasResponse
implements ToCopyableBuilder<Builder, ListServicesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListServicesResponse.getter(ListServicesResponse::nextToken)).setter(ListServicesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<ServiceInfo>> SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Services").getter(ListServicesResponse.getter(ListServicesResponse::services)).setter(ListServicesResponse.setter(Builder::services)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Services").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ServiceInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SERVICES_FIELD));
    private final String nextToken;
    private final List<ServiceInfo> services;

    private ListServicesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.services = builder.services;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasServices() {
        return this.services != null && !(this.services instanceof SdkAutoConstructList);
    }

    public final List<ServiceInfo> services() {
        return this.services;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServices() ? this.services() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServicesResponse)) {
            return false;
        }
        ListServicesResponse other = (ListServicesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasServices() == other.hasServices() && Objects.equals(this.services(), other.services());
    }

    public final String toString() {
        return ToString.builder((String)"ListServicesResponse").add("NextToken", (Object)this.nextToken()).add("Services", this.hasServices() ? this.services() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Services": {
                return Optional.ofNullable(clazz.cast(this.services()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListServicesResponse, T> g) {
        return obj -> g.apply((ListServicesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceQuotasResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ServiceInfo> services = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListServicesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.services(model.services);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<ServiceInfo.Builder> getServices() {
            if (this.services instanceof SdkAutoConstructList) {
                return null;
            }
            return this.services != null ? (Collection)this.services.stream().map(ServiceInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder services(Collection<ServiceInfo> services) {
            this.services = ServiceInfoListDefinitionCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(ServiceInfo ... services) {
            this.services(Arrays.asList(services));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(Consumer<ServiceInfo.Builder> ... services) {
            this.services(Stream.of(services).map(c -> (ServiceInfo)((ServiceInfo.Builder)ServiceInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServices(Collection<ServiceInfo.BuilderImpl> services) {
            this.services = ServiceInfoListDefinitionCopier.copyFromBuilder(services);
        }

        @Override
        public ListServicesResponse build() {
            return new ListServicesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ServiceQuotasResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListServicesResponse> {
        public Builder nextToken(String var1);

        public Builder services(Collection<ServiceInfo> var1);

        public Builder services(ServiceInfo ... var1);

        public Builder services(Consumer<ServiceInfo.Builder> ... var1);
    }
}

