/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicequotas.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRequestedServiceQuotaChangeHistoryResponse extends ServiceQuotasResponse implements
        ToCopyableBuilder<ListRequestedServiceQuotaChangeHistoryResponse.Builder, ListRequestedServiceQuotaChangeHistoryResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListRequestedServiceQuotaChangeHistoryResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<RequestedServiceQuotaChange>> REQUESTED_QUOTAS_FIELD = SdkField
            .<List<RequestedServiceQuotaChange>> builder(MarshallingType.LIST)
            .memberName("RequestedQuotas")
            .getter(getter(ListRequestedServiceQuotaChangeHistoryResponse::requestedQuotas))
            .setter(setter(Builder::requestedQuotas))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedQuotas").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RequestedServiceQuotaChange> builder(MarshallingType.SDK_POJO)
                                            .constructor(RequestedServiceQuotaChange::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            REQUESTED_QUOTAS_FIELD));

    private final String nextToken;

    private final List<RequestedServiceQuotaChange> requestedQuotas;

    private ListRequestedServiceQuotaChangeHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.requestedQuotas = builder.requestedQuotas;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is null when there are no more results to
     * return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is null when there are no more results
     *         to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the RequestedQuotas property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasRequestedQuotas() {
        return requestedQuotas != null && !(requestedQuotas instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the quota increase requests.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRequestedQuotas()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Information about the quota increase requests.
     */
    public final List<RequestedServiceQuotaChange> requestedQuotas() {
        return requestedQuotas;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasRequestedQuotas() ? requestedQuotas() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRequestedServiceQuotaChangeHistoryResponse)) {
            return false;
        }
        ListRequestedServiceQuotaChangeHistoryResponse other = (ListRequestedServiceQuotaChangeHistoryResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasRequestedQuotas() == other.hasRequestedQuotas()
                && Objects.equals(requestedQuotas(), other.requestedQuotas());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRequestedServiceQuotaChangeHistoryResponse").add("NextToken", nextToken())
                .add("RequestedQuotas", hasRequestedQuotas() ? requestedQuotas() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "RequestedQuotas":
            return Optional.ofNullable(clazz.cast(requestedQuotas()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListRequestedServiceQuotaChangeHistoryResponse, T> g) {
        return obj -> g.apply((ListRequestedServiceQuotaChangeHistoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceQuotasResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListRequestedServiceQuotaChangeHistoryResponse> {
        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is null when there are no more results to
         * return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is null when there are no more
         *        results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Information about the quota increase requests.
         * </p>
         * 
         * @param requestedQuotas
         *        Information about the quota increase requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedQuotas(Collection<RequestedServiceQuotaChange> requestedQuotas);

        /**
         * <p>
         * Information about the quota increase requests.
         * </p>
         * 
         * @param requestedQuotas
         *        Information about the quota increase requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestedQuotas(RequestedServiceQuotaChange... requestedQuotas);

        /**
         * <p>
         * Information about the quota increase requests.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RequestedServiceQuotaChange>.Builder}
         * avoiding the need to create one manually via {@link List<RequestedServiceQuotaChange>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RequestedServiceQuotaChange>.Builder#build()} is called
         * immediately and its result is passed to {@link #requestedQuotas(List<RequestedServiceQuotaChange>)}.
         * 
         * @param requestedQuotas
         *        a consumer that will call methods on {@link List<RequestedServiceQuotaChange>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #requestedQuotas(List<RequestedServiceQuotaChange>)
         */
        Builder requestedQuotas(Consumer<RequestedServiceQuotaChange.Builder>... requestedQuotas);
    }

    static final class BuilderImpl extends ServiceQuotasResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<RequestedServiceQuotaChange> requestedQuotas = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListRequestedServiceQuotaChangeHistoryResponse model) {
            super(model);
            nextToken(model.nextToken);
            requestedQuotas(model.requestedQuotas);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<RequestedServiceQuotaChange.Builder> getRequestedQuotas() {
            if (requestedQuotas instanceof SdkAutoConstructList) {
                return null;
            }
            return requestedQuotas != null ? requestedQuotas.stream().map(RequestedServiceQuotaChange::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder requestedQuotas(Collection<RequestedServiceQuotaChange> requestedQuotas) {
            this.requestedQuotas = RequestedServiceQuotaChangeHistoryListDefinitionCopier.copy(requestedQuotas);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestedQuotas(RequestedServiceQuotaChange... requestedQuotas) {
            requestedQuotas(Arrays.asList(requestedQuotas));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requestedQuotas(Consumer<RequestedServiceQuotaChange.Builder>... requestedQuotas) {
            requestedQuotas(Stream.of(requestedQuotas).map(c -> RequestedServiceQuotaChange.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setRequestedQuotas(Collection<RequestedServiceQuotaChange.BuilderImpl> requestedQuotas) {
            this.requestedQuotas = RequestedServiceQuotaChangeHistoryListDefinitionCopier.copyFromBuilder(requestedQuotas);
        }

        @Override
        public ListRequestedServiceQuotaChangeHistoryResponse build() {
            return new ListRequestedServiceQuotaChangeHistoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
