/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicequotas.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAssociationForServiceQuotaTemplateResponse extends ServiceQuotasResponse implements
        ToCopyableBuilder<GetAssociationForServiceQuotaTemplateResponse.Builder, GetAssociationForServiceQuotaTemplateResponse> {
    private static final SdkField<String> SERVICE_QUOTA_TEMPLATE_ASSOCIATION_STATUS_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ServiceQuotaTemplateAssociationStatus")
            .getter(getter(GetAssociationForServiceQuotaTemplateResponse::serviceQuotaTemplateAssociationStatusAsString))
            .setter(setter(Builder::serviceQuotaTemplateAssociationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ServiceQuotaTemplateAssociationStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SERVICE_QUOTA_TEMPLATE_ASSOCIATION_STATUS_FIELD));

    private final String serviceQuotaTemplateAssociationStatus;

    private GetAssociationForServiceQuotaTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.serviceQuotaTemplateAssociationStatus = builder.serviceQuotaTemplateAssociationStatus;
    }

    /**
     * <p>
     * Specifies whether the template is <code>ASSOCIATED</code> or <code>DISASSOCIATED</code>. If the template is
     * <code>ASSOCIATED</code>, then it requests service quota increases for all new accounts created in your
     * organization.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #serviceQuotaTemplateAssociationStatus} will return
     * {@link ServiceQuotaTemplateAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #serviceQuotaTemplateAssociationStatusAsString}.
     * </p>
     * 
     * @return Specifies whether the template is <code>ASSOCIATED</code> or <code>DISASSOCIATED</code>. If the template
     *         is <code>ASSOCIATED</code>, then it requests service quota increases for all new accounts created in your
     *         organization.
     * @see ServiceQuotaTemplateAssociationStatus
     */
    public ServiceQuotaTemplateAssociationStatus serviceQuotaTemplateAssociationStatus() {
        return ServiceQuotaTemplateAssociationStatus.fromValue(serviceQuotaTemplateAssociationStatus);
    }

    /**
     * <p>
     * Specifies whether the template is <code>ASSOCIATED</code> or <code>DISASSOCIATED</code>. If the template is
     * <code>ASSOCIATED</code>, then it requests service quota increases for all new accounts created in your
     * organization.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #serviceQuotaTemplateAssociationStatus} will return
     * {@link ServiceQuotaTemplateAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #serviceQuotaTemplateAssociationStatusAsString}.
     * </p>
     * 
     * @return Specifies whether the template is <code>ASSOCIATED</code> or <code>DISASSOCIATED</code>. If the template
     *         is <code>ASSOCIATED</code>, then it requests service quota increases for all new accounts created in your
     *         organization.
     * @see ServiceQuotaTemplateAssociationStatus
     */
    public String serviceQuotaTemplateAssociationStatusAsString() {
        return serviceQuotaTemplateAssociationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(serviceQuotaTemplateAssociationStatusAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssociationForServiceQuotaTemplateResponse)) {
            return false;
        }
        GetAssociationForServiceQuotaTemplateResponse other = (GetAssociationForServiceQuotaTemplateResponse) obj;
        return Objects.equals(serviceQuotaTemplateAssociationStatusAsString(),
                other.serviceQuotaTemplateAssociationStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("GetAssociationForServiceQuotaTemplateResponse")
                .add("ServiceQuotaTemplateAssociationStatus", serviceQuotaTemplateAssociationStatusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceQuotaTemplateAssociationStatus":
            return Optional.ofNullable(clazz.cast(serviceQuotaTemplateAssociationStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAssociationForServiceQuotaTemplateResponse, T> g) {
        return obj -> g.apply((GetAssociationForServiceQuotaTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceQuotasResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAssociationForServiceQuotaTemplateResponse> {
        /**
         * <p>
         * Specifies whether the template is <code>ASSOCIATED</code> or <code>DISASSOCIATED</code>. If the template is
         * <code>ASSOCIATED</code>, then it requests service quota increases for all new accounts created in your
         * organization.
         * </p>
         * 
         * @param serviceQuotaTemplateAssociationStatus
         *        Specifies whether the template is <code>ASSOCIATED</code> or <code>DISASSOCIATED</code>. If the
         *        template is <code>ASSOCIATED</code>, then it requests service quota increases for all new accounts
         *        created in your organization.
         * @see ServiceQuotaTemplateAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceQuotaTemplateAssociationStatus
         */
        Builder serviceQuotaTemplateAssociationStatus(String serviceQuotaTemplateAssociationStatus);

        /**
         * <p>
         * Specifies whether the template is <code>ASSOCIATED</code> or <code>DISASSOCIATED</code>. If the template is
         * <code>ASSOCIATED</code>, then it requests service quota increases for all new accounts created in your
         * organization.
         * </p>
         * 
         * @param serviceQuotaTemplateAssociationStatus
         *        Specifies whether the template is <code>ASSOCIATED</code> or <code>DISASSOCIATED</code>. If the
         *        template is <code>ASSOCIATED</code>, then it requests service quota increases for all new accounts
         *        created in your organization.
         * @see ServiceQuotaTemplateAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceQuotaTemplateAssociationStatus
         */
        Builder serviceQuotaTemplateAssociationStatus(ServiceQuotaTemplateAssociationStatus serviceQuotaTemplateAssociationStatus);
    }

    static final class BuilderImpl extends ServiceQuotasResponse.BuilderImpl implements Builder {
        private String serviceQuotaTemplateAssociationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAssociationForServiceQuotaTemplateResponse model) {
            super(model);
            serviceQuotaTemplateAssociationStatus(model.serviceQuotaTemplateAssociationStatus);
        }

        public final String getServiceQuotaTemplateAssociationStatus() {
            return serviceQuotaTemplateAssociationStatus;
        }

        @Override
        public final Builder serviceQuotaTemplateAssociationStatus(String serviceQuotaTemplateAssociationStatus) {
            this.serviceQuotaTemplateAssociationStatus = serviceQuotaTemplateAssociationStatus;
            return this;
        }

        @Override
        public final Builder serviceQuotaTemplateAssociationStatus(
                ServiceQuotaTemplateAssociationStatus serviceQuotaTemplateAssociationStatus) {
            this.serviceQuotaTemplateAssociationStatus(serviceQuotaTemplateAssociationStatus == null ? null
                    : serviceQuotaTemplateAssociationStatus.toString());
            return this;
        }

        public final void setServiceQuotaTemplateAssociationStatus(String serviceQuotaTemplateAssociationStatus) {
            this.serviceQuotaTemplateAssociationStatus = serviceQuotaTemplateAssociationStatus;
        }

        @Override
        public GetAssociationForServiceQuotaTemplateResponse build() {
            return new GetAssociationForServiceQuotaTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
