/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicequotas.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServiceQuotaIncreaseRequestsInTemplateResponse extends ServiceQuotasResponse
        implements
        ToCopyableBuilder<ListServiceQuotaIncreaseRequestsInTemplateResponse.Builder, ListServiceQuotaIncreaseRequestsInTemplateResponse> {
    private static final SdkField<List<ServiceQuotaIncreaseRequestInTemplate>> SERVICE_QUOTA_INCREASE_REQUEST_IN_TEMPLATE_LIST_FIELD = SdkField
            .<List<ServiceQuotaIncreaseRequestInTemplate>> builder(MarshallingType.LIST)
            .memberName("ServiceQuotaIncreaseRequestInTemplateList")
            .getter(getter(ListServiceQuotaIncreaseRequestsInTemplateResponse::serviceQuotaIncreaseRequestInTemplateList))
            .setter(setter(Builder::serviceQuotaIncreaseRequestInTemplateList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ServiceQuotaIncreaseRequestInTemplateList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceQuotaIncreaseRequestInTemplate> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceQuotaIncreaseRequestInTemplate::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListServiceQuotaIncreaseRequestsInTemplateResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SERVICE_QUOTA_INCREASE_REQUEST_IN_TEMPLATE_LIST_FIELD, NEXT_TOKEN_FIELD));

    private final List<ServiceQuotaIncreaseRequestInTemplate> serviceQuotaIncreaseRequestInTemplateList;

    private final String nextToken;

    private ListServiceQuotaIncreaseRequestsInTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.serviceQuotaIncreaseRequestInTemplateList = builder.serviceQuotaIncreaseRequestInTemplateList;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ServiceQuotaIncreaseRequestInTemplateList property was specified by the sender (it may be
     * empty), or false if the sender did not specify the value (it will be empty). For responses returned by the SDK,
     * the sender is the AWS service.
     */
    public boolean hasServiceQuotaIncreaseRequestInTemplateList() {
        return serviceQuotaIncreaseRequestInTemplateList != null
                && !(serviceQuotaIncreaseRequestInTemplateList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns the list of values of the quota increase request in the template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasServiceQuotaIncreaseRequestInTemplateList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Returns the list of values of the quota increase request in the template.
     */
    public List<ServiceQuotaIncreaseRequestInTemplate> serviceQuotaIncreaseRequestInTemplateList() {
        return serviceQuotaIncreaseRequestInTemplateList;
    }

    /**
     * <p>
     * If present in the response, this value indicates there's more output available that what's included in the
     * current response. This can occur even when the response includes no values at all, such as when you ask for a
     * filtered view of a very long list. Use this value in the <code>NextToken</code> request parameter in a subsequent
     * call to the operation to continue processing and get the next part of the output. You should repeat this until
     * the <code>NextToken</code> response element comes back empty (as <code>null</code>).
     * </p>
     * 
     * @return If present in the response, this value indicates there's more output available that what's included in
     *         the current response. This can occur even when the response includes no values at all, such as when you
     *         ask for a filtered view of a very long list. Use this value in the <code>NextToken</code> request
     *         parameter in a subsequent call to the operation to continue processing and get the next part of the
     *         output. You should repeat this until the <code>NextToken</code> response element comes back empty (as
     *         <code>null</code>).
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31
                * hashCode
                + Objects.hashCode(hasServiceQuotaIncreaseRequestInTemplateList() ? serviceQuotaIncreaseRequestInTemplateList()
                        : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServiceQuotaIncreaseRequestsInTemplateResponse)) {
            return false;
        }
        ListServiceQuotaIncreaseRequestsInTemplateResponse other = (ListServiceQuotaIncreaseRequestsInTemplateResponse) obj;
        return hasServiceQuotaIncreaseRequestInTemplateList() == other.hasServiceQuotaIncreaseRequestInTemplateList()
                && Objects.equals(serviceQuotaIncreaseRequestInTemplateList(), other.serviceQuotaIncreaseRequestInTemplateList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString
                .builder("ListServiceQuotaIncreaseRequestsInTemplateResponse")
                .add("ServiceQuotaIncreaseRequestInTemplateList",
                        hasServiceQuotaIncreaseRequestInTemplateList() ? serviceQuotaIncreaseRequestInTemplateList() : null)
                .add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceQuotaIncreaseRequestInTemplateList":
            return Optional.ofNullable(clazz.cast(serviceQuotaIncreaseRequestInTemplateList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListServiceQuotaIncreaseRequestsInTemplateResponse, T> g) {
        return obj -> g.apply((ListServiceQuotaIncreaseRequestsInTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceQuotasResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListServiceQuotaIncreaseRequestsInTemplateResponse> {
        /**
         * <p>
         * Returns the list of values of the quota increase request in the template.
         * </p>
         * 
         * @param serviceQuotaIncreaseRequestInTemplateList
         *        Returns the list of values of the quota increase request in the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceQuotaIncreaseRequestInTemplateList(
                Collection<ServiceQuotaIncreaseRequestInTemplate> serviceQuotaIncreaseRequestInTemplateList);

        /**
         * <p>
         * Returns the list of values of the quota increase request in the template.
         * </p>
         * 
         * @param serviceQuotaIncreaseRequestInTemplateList
         *        Returns the list of values of the quota increase request in the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceQuotaIncreaseRequestInTemplateList(
                ServiceQuotaIncreaseRequestInTemplate... serviceQuotaIncreaseRequestInTemplateList);

        /**
         * <p>
         * Returns the list of values of the quota increase request in the template.
         * </p>
         * This is a convenience that creates an instance of the {@link List
         * <ServiceQuotaIncreaseRequestInTemplate>.Builder} avoiding the need to create one manually via {@link List
         * <ServiceQuotaIncreaseRequestInTemplate>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ServiceQuotaIncreaseRequestInTemplate>.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #serviceQuotaIncreaseRequestInTemplateList(List<ServiceQuotaIncreaseRequestInTemplate>)}.
         * 
         * @param serviceQuotaIncreaseRequestInTemplateList
         *        a consumer that will call methods on {@link List<ServiceQuotaIncreaseRequestInTemplate>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceQuotaIncreaseRequestInTemplateList(List<ServiceQuotaIncreaseRequestInTemplate>)
         */
        Builder serviceQuotaIncreaseRequestInTemplateList(
                Consumer<ServiceQuotaIncreaseRequestInTemplate.Builder>... serviceQuotaIncreaseRequestInTemplateList);

        /**
         * <p>
         * If present in the response, this value indicates there's more output available that what's included in the
         * current response. This can occur even when the response includes no values at all, such as when you ask for a
         * filtered view of a very long list. Use this value in the <code>NextToken</code> request parameter in a
         * subsequent call to the operation to continue processing and get the next part of the output. You should
         * repeat this until the <code>NextToken</code> response element comes back empty (as <code>null</code>).
         * </p>
         * 
         * @param nextToken
         *        If present in the response, this value indicates there's more output available that what's included in
         *        the current response. This can occur even when the response includes no values at all, such as when
         *        you ask for a filtered view of a very long list. Use this value in the <code>NextToken</code> request
         *        parameter in a subsequent call to the operation to continue processing and get the next part of the
         *        output. You should repeat this until the <code>NextToken</code> response element comes back empty (as
         *        <code>null</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ServiceQuotasResponse.BuilderImpl implements Builder {
        private List<ServiceQuotaIncreaseRequestInTemplate> serviceQuotaIncreaseRequestInTemplateList = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServiceQuotaIncreaseRequestsInTemplateResponse model) {
            super(model);
            serviceQuotaIncreaseRequestInTemplateList(model.serviceQuotaIncreaseRequestInTemplateList);
            nextToken(model.nextToken);
        }

        public final Collection<ServiceQuotaIncreaseRequestInTemplate.Builder> getServiceQuotaIncreaseRequestInTemplateList() {
            if (serviceQuotaIncreaseRequestInTemplateList instanceof SdkAutoConstructList) {
                return null;
            }
            return serviceQuotaIncreaseRequestInTemplateList != null ? serviceQuotaIncreaseRequestInTemplateList.stream()
                    .map(ServiceQuotaIncreaseRequestInTemplate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder serviceQuotaIncreaseRequestInTemplateList(
                Collection<ServiceQuotaIncreaseRequestInTemplate> serviceQuotaIncreaseRequestInTemplateList) {
            this.serviceQuotaIncreaseRequestInTemplateList = ServiceQuotaIncreaseRequestInTemplateListCopier
                    .copy(serviceQuotaIncreaseRequestInTemplateList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceQuotaIncreaseRequestInTemplateList(
                ServiceQuotaIncreaseRequestInTemplate... serviceQuotaIncreaseRequestInTemplateList) {
            serviceQuotaIncreaseRequestInTemplateList(Arrays.asList(serviceQuotaIncreaseRequestInTemplateList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceQuotaIncreaseRequestInTemplateList(
                Consumer<ServiceQuotaIncreaseRequestInTemplate.Builder>... serviceQuotaIncreaseRequestInTemplateList) {
            serviceQuotaIncreaseRequestInTemplateList(Stream.of(serviceQuotaIncreaseRequestInTemplateList)
                    .map(c -> ServiceQuotaIncreaseRequestInTemplate.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setServiceQuotaIncreaseRequestInTemplateList(
                Collection<ServiceQuotaIncreaseRequestInTemplate.BuilderImpl> serviceQuotaIncreaseRequestInTemplateList) {
            this.serviceQuotaIncreaseRequestInTemplateList = ServiceQuotaIncreaseRequestInTemplateListCopier
                    .copyFromBuilder(serviceQuotaIncreaseRequestInTemplateList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListServiceQuotaIncreaseRequestsInTemplateResponse build() {
            return new ListServiceQuotaIncreaseRequestsInTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
