/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicequotas.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains information about one service quota increase request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceQuotaIncreaseRequestInTemplate implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceQuotaIncreaseRequestInTemplate.Builder, ServiceQuotaIncreaseRequestInTemplate> {
    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceQuotaIncreaseRequestInTemplate::serviceCode)).setter(setter(Builder::serviceCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceCode").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceQuotaIncreaseRequestInTemplate::serviceName)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()).build();

    private static final SdkField<String> QUOTA_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceQuotaIncreaseRequestInTemplate::quotaCode)).setter(setter(Builder::quotaCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuotaCode").build()).build();

    private static final SdkField<String> QUOTA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceQuotaIncreaseRequestInTemplate::quotaName)).setter(setter(Builder::quotaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuotaName").build()).build();

    private static final SdkField<Double> DESIRED_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(ServiceQuotaIncreaseRequestInTemplate::desiredValue)).setter(setter(Builder::desiredValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredValue").build()).build();

    private static final SdkField<String> AWS_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceQuotaIncreaseRequestInTemplate::awsRegion)).setter(setter(Builder::awsRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsRegion").build()).build();

    private static final SdkField<String> UNIT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceQuotaIncreaseRequestInTemplate::unit)).setter(setter(Builder::unit))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Unit").build()).build();

    private static final SdkField<Boolean> GLOBAL_QUOTA_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ServiceQuotaIncreaseRequestInTemplate::globalQuota)).setter(setter(Builder::globalQuota))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GlobalQuota").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_CODE_FIELD,
            SERVICE_NAME_FIELD, QUOTA_CODE_FIELD, QUOTA_NAME_FIELD, DESIRED_VALUE_FIELD, AWS_REGION_FIELD, UNIT_FIELD,
            GLOBAL_QUOTA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String serviceCode;

    private final String serviceName;

    private final String quotaCode;

    private final String quotaName;

    private final Double desiredValue;

    private final String awsRegion;

    private final String unit;

    private final Boolean globalQuota;

    private ServiceQuotaIncreaseRequestInTemplate(BuilderImpl builder) {
        this.serviceCode = builder.serviceCode;
        this.serviceName = builder.serviceName;
        this.quotaCode = builder.quotaCode;
        this.quotaName = builder.quotaName;
        this.desiredValue = builder.desiredValue;
        this.awsRegion = builder.awsRegion;
        this.unit = builder.unit;
        this.globalQuota = builder.globalQuota;
    }

    /**
     * <p>
     * The code identifier for the AWS service specified in the increase request.
     * </p>
     * 
     * @return The code identifier for the AWS service specified in the increase request.
     */
    public String serviceCode() {
        return serviceCode;
    }

    /**
     * <p>
     * The name of the AWS service specified in the increase request.
     * </p>
     * 
     * @return The name of the AWS service specified in the increase request.
     */
    public String serviceName() {
        return serviceName;
    }

    /**
     * <p>
     * The code identifier for the service quota specified in the increase request.
     * </p>
     * 
     * @return The code identifier for the service quota specified in the increase request.
     */
    public String quotaCode() {
        return quotaCode;
    }

    /**
     * <p>
     * The name of the service quota in the increase request.
     * </p>
     * 
     * @return The name of the service quota in the increase request.
     */
    public String quotaName() {
        return quotaName;
    }

    /**
     * <p>
     * Identifies the new, increased value of the service quota in the increase request.
     * </p>
     * 
     * @return Identifies the new, increased value of the service quota in the increase request.
     */
    public Double desiredValue() {
        return desiredValue;
    }

    /**
     * <p>
     * The AWS Region where the increase request occurs.
     * </p>
     * 
     * @return The AWS Region where the increase request occurs.
     */
    public String awsRegion() {
        return awsRegion;
    }

    /**
     * <p>
     * The unit of measure for the increase request.
     * </p>
     * 
     * @return The unit of measure for the increase request.
     */
    public String unit() {
        return unit;
    }

    /**
     * <p>
     * Specifies if the quota is a global quota.
     * </p>
     * 
     * @return Specifies if the quota is a global quota.
     */
    public Boolean globalQuota() {
        return globalQuota;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(quotaCode());
        hashCode = 31 * hashCode + Objects.hashCode(quotaName());
        hashCode = 31 * hashCode + Objects.hashCode(desiredValue());
        hashCode = 31 * hashCode + Objects.hashCode(awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(unit());
        hashCode = 31 * hashCode + Objects.hashCode(globalQuota());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceQuotaIncreaseRequestInTemplate)) {
            return false;
        }
        ServiceQuotaIncreaseRequestInTemplate other = (ServiceQuotaIncreaseRequestInTemplate) obj;
        return Objects.equals(serviceCode(), other.serviceCode()) && Objects.equals(serviceName(), other.serviceName())
                && Objects.equals(quotaCode(), other.quotaCode()) && Objects.equals(quotaName(), other.quotaName())
                && Objects.equals(desiredValue(), other.desiredValue()) && Objects.equals(awsRegion(), other.awsRegion())
                && Objects.equals(unit(), other.unit()) && Objects.equals(globalQuota(), other.globalQuota());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ServiceQuotaIncreaseRequestInTemplate").add("ServiceCode", serviceCode())
                .add("ServiceName", serviceName()).add("QuotaCode", quotaCode()).add("QuotaName", quotaName())
                .add("DesiredValue", desiredValue()).add("AwsRegion", awsRegion()).add("Unit", unit())
                .add("GlobalQuota", globalQuota()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ServiceCode":
            return Optional.ofNullable(clazz.cast(serviceCode()));
        case "ServiceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "QuotaCode":
            return Optional.ofNullable(clazz.cast(quotaCode()));
        case "QuotaName":
            return Optional.ofNullable(clazz.cast(quotaName()));
        case "DesiredValue":
            return Optional.ofNullable(clazz.cast(desiredValue()));
        case "AwsRegion":
            return Optional.ofNullable(clazz.cast(awsRegion()));
        case "Unit":
            return Optional.ofNullable(clazz.cast(unit()));
        case "GlobalQuota":
            return Optional.ofNullable(clazz.cast(globalQuota()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceQuotaIncreaseRequestInTemplate, T> g) {
        return obj -> g.apply((ServiceQuotaIncreaseRequestInTemplate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceQuotaIncreaseRequestInTemplate> {
        /**
         * <p>
         * The code identifier for the AWS service specified in the increase request.
         * </p>
         * 
         * @param serviceCode
         *        The code identifier for the AWS service specified in the increase request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceCode(String serviceCode);

        /**
         * <p>
         * The name of the AWS service specified in the increase request.
         * </p>
         * 
         * @param serviceName
         *        The name of the AWS service specified in the increase request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * The code identifier for the service quota specified in the increase request.
         * </p>
         * 
         * @param quotaCode
         *        The code identifier for the service quota specified in the increase request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quotaCode(String quotaCode);

        /**
         * <p>
         * The name of the service quota in the increase request.
         * </p>
         * 
         * @param quotaName
         *        The name of the service quota in the increase request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quotaName(String quotaName);

        /**
         * <p>
         * Identifies the new, increased value of the service quota in the increase request.
         * </p>
         * 
         * @param desiredValue
         *        Identifies the new, increased value of the service quota in the increase request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredValue(Double desiredValue);

        /**
         * <p>
         * The AWS Region where the increase request occurs.
         * </p>
         * 
         * @param awsRegion
         *        The AWS Region where the increase request occurs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsRegion(String awsRegion);

        /**
         * <p>
         * The unit of measure for the increase request.
         * </p>
         * 
         * @param unit
         *        The unit of measure for the increase request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unit(String unit);

        /**
         * <p>
         * Specifies if the quota is a global quota.
         * </p>
         * 
         * @param globalQuota
         *        Specifies if the quota is a global quota.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalQuota(Boolean globalQuota);
    }

    static final class BuilderImpl implements Builder {
        private String serviceCode;

        private String serviceName;

        private String quotaCode;

        private String quotaName;

        private Double desiredValue;

        private String awsRegion;

        private String unit;

        private Boolean globalQuota;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceQuotaIncreaseRequestInTemplate model) {
            serviceCode(model.serviceCode);
            serviceName(model.serviceName);
            quotaCode(model.quotaCode);
            quotaName(model.quotaName);
            desiredValue(model.desiredValue);
            awsRegion(model.awsRegion);
            unit(model.unit);
            globalQuota(model.globalQuota);
        }

        public final String getServiceCode() {
            return serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        public final String getServiceName() {
            return serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        public final String getQuotaCode() {
            return quotaCode;
        }

        @Override
        public final Builder quotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
            return this;
        }

        public final void setQuotaCode(String quotaCode) {
            this.quotaCode = quotaCode;
        }

        public final String getQuotaName() {
            return quotaName;
        }

        @Override
        public final Builder quotaName(String quotaName) {
            this.quotaName = quotaName;
            return this;
        }

        public final void setQuotaName(String quotaName) {
            this.quotaName = quotaName;
        }

        public final Double getDesiredValue() {
            return desiredValue;
        }

        @Override
        public final Builder desiredValue(Double desiredValue) {
            this.desiredValue = desiredValue;
            return this;
        }

        public final void setDesiredValue(Double desiredValue) {
            this.desiredValue = desiredValue;
        }

        public final String getAwsRegion() {
            return awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        public final String getUnit() {
            return unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public final Boolean getGlobalQuota() {
            return globalQuota;
        }

        @Override
        public final Builder globalQuota(Boolean globalQuota) {
            this.globalQuota = globalQuota;
            return this;
        }

        public final void setGlobalQuota(Boolean globalQuota) {
            this.globalQuota = globalQuota;
        }

        @Override
        public ServiceQuotaIncreaseRequestInTemplate build() {
            return new ServiceQuotaIncreaseRequestInTemplate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
