/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.servicediscovery.model.AttributesCopier;
import software.amazon.awssdk.services.servicediscovery.model.HealthStatusFilter;
import software.amazon.awssdk.services.servicediscovery.model.ServiceDiscoveryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DiscoverInstancesRequest
extends ServiceDiscoveryRequest
implements ToCopyableBuilder<Builder, DiscoverInstancesRequest> {
    private static final SdkField<String> NAMESPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NamespaceName").getter(DiscoverInstancesRequest.getter(DiscoverInstancesRequest::namespaceName)).setter(DiscoverInstancesRequest.setter(Builder::namespaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NamespaceName").build()}).build();
    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ServiceName").getter(DiscoverInstancesRequest.getter(DiscoverInstancesRequest::serviceName)).setter(DiscoverInstancesRequest.setter(Builder::serviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(DiscoverInstancesRequest.getter(DiscoverInstancesRequest::maxResults)).setter(DiscoverInstancesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<Map<String, String>> QUERY_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("QueryParameters").getter(DiscoverInstancesRequest.getter(DiscoverInstancesRequest::queryParameters)).setter(DiscoverInstancesRequest.setter(Builder::queryParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QueryParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> OPTIONAL_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("OptionalParameters").getter(DiscoverInstancesRequest.getter(DiscoverInstancesRequest::optionalParameters)).setter(DiscoverInstancesRequest.setter(Builder::optionalParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionalParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> HEALTH_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HealthStatus").getter(DiscoverInstancesRequest.getter(DiscoverInstancesRequest::healthStatusAsString)).setter(DiscoverInstancesRequest.setter(Builder::healthStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_NAME_FIELD, SERVICE_NAME_FIELD, MAX_RESULTS_FIELD, QUERY_PARAMETERS_FIELD, OPTIONAL_PARAMETERS_FIELD, HEALTH_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("NamespaceName", NAMESPACE_NAME_FIELD);
            this.put("ServiceName", SERVICE_NAME_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
            this.put("QueryParameters", QUERY_PARAMETERS_FIELD);
            this.put("OptionalParameters", OPTIONAL_PARAMETERS_FIELD);
            this.put("HealthStatus", HEALTH_STATUS_FIELD);
        }
    });
    private final String namespaceName;
    private final String serviceName;
    private final Integer maxResults;
    private final Map<String, String> queryParameters;
    private final Map<String, String> optionalParameters;
    private final String healthStatus;

    private DiscoverInstancesRequest(BuilderImpl builder) {
        super(builder);
        this.namespaceName = builder.namespaceName;
        this.serviceName = builder.serviceName;
        this.maxResults = builder.maxResults;
        this.queryParameters = builder.queryParameters;
        this.optionalParameters = builder.optionalParameters;
        this.healthStatus = builder.healthStatus;
    }

    public final String namespaceName() {
        return this.namespaceName;
    }

    public final String serviceName() {
        return this.serviceName;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final boolean hasQueryParameters() {
        return this.queryParameters != null && !(this.queryParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> queryParameters() {
        return this.queryParameters;
    }

    public final boolean hasOptionalParameters() {
        return this.optionalParameters != null && !(this.optionalParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> optionalParameters() {
        return this.optionalParameters;
    }

    public final HealthStatusFilter healthStatus() {
        return HealthStatusFilter.fromValue(this.healthStatus);
    }

    public final String healthStatusAsString() {
        return this.healthStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.namespaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasQueryParameters() ? this.queryParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptionalParameters() ? this.optionalParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.healthStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiscoverInstancesRequest)) {
            return false;
        }
        DiscoverInstancesRequest other = (DiscoverInstancesRequest)((Object)obj);
        return Objects.equals(this.namespaceName(), other.namespaceName()) && Objects.equals(this.serviceName(), other.serviceName()) && Objects.equals(this.maxResults(), other.maxResults()) && this.hasQueryParameters() == other.hasQueryParameters() && Objects.equals(this.queryParameters(), other.queryParameters()) && this.hasOptionalParameters() == other.hasOptionalParameters() && Objects.equals(this.optionalParameters(), other.optionalParameters()) && Objects.equals(this.healthStatusAsString(), other.healthStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DiscoverInstancesRequest").add("NamespaceName", (Object)this.namespaceName()).add("ServiceName", (Object)this.serviceName()).add("MaxResults", (Object)this.maxResults()).add("QueryParameters", this.hasQueryParameters() ? this.queryParameters() : null).add("OptionalParameters", this.hasOptionalParameters() ? this.optionalParameters() : null).add("HealthStatus", (Object)this.healthStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NamespaceName": {
                return Optional.ofNullable(clazz.cast(this.namespaceName()));
            }
            case "ServiceName": {
                return Optional.ofNullable(clazz.cast(this.serviceName()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "QueryParameters": {
                return Optional.ofNullable(clazz.cast(this.queryParameters()));
            }
            case "OptionalParameters": {
                return Optional.ofNullable(clazz.cast(this.optionalParameters()));
            }
            case "HealthStatus": {
                return Optional.ofNullable(clazz.cast(this.healthStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DiscoverInstancesRequest, T> g) {
        return obj -> g.apply((DiscoverInstancesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceDiscoveryRequest.BuilderImpl
    implements Builder {
        private String namespaceName;
        private String serviceName;
        private Integer maxResults;
        private Map<String, String> queryParameters = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> optionalParameters = DefaultSdkAutoConstructMap.getInstance();
        private String healthStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DiscoverInstancesRequest model) {
            super(model);
            this.namespaceName(model.namespaceName);
            this.serviceName(model.serviceName);
            this.maxResults(model.maxResults);
            this.queryParameters(model.queryParameters);
            this.optionalParameters(model.optionalParameters);
            this.healthStatus(model.healthStatus);
        }

        public final String getNamespaceName() {
            return this.namespaceName;
        }

        public final void setNamespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
        }

        @Override
        public final Builder namespaceName(String namespaceName) {
            this.namespaceName = namespaceName;
            return this;
        }

        public final String getServiceName() {
            return this.serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Map<String, String> getQueryParameters() {
            if (this.queryParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.queryParameters;
        }

        public final void setQueryParameters(Map<String, String> queryParameters) {
            this.queryParameters = AttributesCopier.copy(queryParameters);
        }

        @Override
        public final Builder queryParameters(Map<String, String> queryParameters) {
            this.queryParameters = AttributesCopier.copy(queryParameters);
            return this;
        }

        public final Map<String, String> getOptionalParameters() {
            if (this.optionalParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.optionalParameters;
        }

        public final void setOptionalParameters(Map<String, String> optionalParameters) {
            this.optionalParameters = AttributesCopier.copy(optionalParameters);
        }

        @Override
        public final Builder optionalParameters(Map<String, String> optionalParameters) {
            this.optionalParameters = AttributesCopier.copy(optionalParameters);
            return this;
        }

        public final String getHealthStatus() {
            return this.healthStatus;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        @Override
        public final Builder healthStatus(HealthStatusFilter healthStatus) {
            this.healthStatus(healthStatus == null ? null : healthStatus.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DiscoverInstancesRequest build() {
            return new DiscoverInstancesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ServiceDiscoveryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DiscoverInstancesRequest> {
        public Builder namespaceName(String var1);

        public Builder serviceName(String var1);

        public Builder maxResults(Integer var1);

        public Builder queryParameters(Map<String, String> var1);

        public Builder optionalParameters(Map<String, String> var1);

        public Builder healthStatus(String var1);

        public Builder healthStatus(HealthStatusFilter var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

