/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import static java.util.stream.Collectors.toList;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Generated;

@Generated("software.amazon.awssdk:codegen")
final class NamespaceFiltersCopier {
    static List<NamespaceFilter> copy(Collection<NamespaceFilter> namespaceFiltersParam) {
        if (namespaceFiltersParam == null) {
            return null;
        }
        List<NamespaceFilter> namespaceFiltersParamCopy = namespaceFiltersParam.stream().collect(toList());
        return Collections.unmodifiableList(namespaceFiltersParamCopy);
    }

    static List<NamespaceFilter> copyFromBuilder(Collection<? extends NamespaceFilter.Builder> namespaceFiltersParam) {
        if (namespaceFiltersParam == null) {
            return null;
        }
        return copy(namespaceFiltersParam.stream().map(NamespaceFilter.Builder::build).collect(toList()));
    }
}
