/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicediscovery.transform.DnsConfigChangeMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information about changes to the resource record sets that Amazon Route 53 creates when
 * you register an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DnsConfigChange implements StructuredPojo, ToCopyableBuilder<DnsConfigChange.Builder, DnsConfigChange> {
    private final List<DnsRecord> dnsRecords;

    private DnsConfigChange(BuilderImpl builder) {
        this.dnsRecords = builder.dnsRecords;
    }

    /**
     * <p>
     * An array that contains one <code>DnsRecord</code> object for each resource record set that you want Amazon Route
     * 53 to create when you register an instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array that contains one <code>DnsRecord</code> object for each resource record set that you want
     *         Amazon Route 53 to create when you register an instance.
     */
    public List<DnsRecord> dnsRecords() {
        return dnsRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dnsRecords());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DnsConfigChange)) {
            return false;
        }
        DnsConfigChange other = (DnsConfigChange) obj;
        return Objects.equals(dnsRecords(), other.dnsRecords());
    }

    @Override
    public String toString() {
        return ToString.builder("DnsConfigChange").add("DnsRecords", dnsRecords()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DnsRecords":
            return Optional.of(clazz.cast(dnsRecords()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DnsConfigChangeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DnsConfigChange> {
        /**
         * <p>
         * An array that contains one <code>DnsRecord</code> object for each resource record set that you want Amazon
         * Route 53 to create when you register an instance.
         * </p>
         * 
         * @param dnsRecords
         *        An array that contains one <code>DnsRecord</code> object for each resource record set that you want
         *        Amazon Route 53 to create when you register an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsRecords(Collection<DnsRecord> dnsRecords);

        /**
         * <p>
         * An array that contains one <code>DnsRecord</code> object for each resource record set that you want Amazon
         * Route 53 to create when you register an instance.
         * </p>
         * 
         * @param dnsRecords
         *        An array that contains one <code>DnsRecord</code> object for each resource record set that you want
         *        Amazon Route 53 to create when you register an instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsRecords(DnsRecord... dnsRecords);
    }

    static final class BuilderImpl implements Builder {
        private List<DnsRecord> dnsRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(DnsConfigChange model) {
            dnsRecords(model.dnsRecords);
        }

        public final Collection<DnsRecord.Builder> getDnsRecords() {
            return dnsRecords != null ? dnsRecords.stream().map(DnsRecord::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dnsRecords(Collection<DnsRecord> dnsRecords) {
            this.dnsRecords = DnsRecordListCopier.copy(dnsRecords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsRecords(DnsRecord... dnsRecords) {
            dnsRecords(Arrays.asList(dnsRecords));
            return this;
        }

        public final void setDnsRecords(Collection<DnsRecord.BuilderImpl> dnsRecords) {
            this.dnsRecords = DnsRecordListCopier.copyFromBuilder(dnsRecords);
        }

        @Override
        public DnsConfigChange build() {
            return new DnsConfigChange(this);
        }
    }
}
