/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteNamespaceResponse extends ServiceDiscoveryResponse implements
        ToCopyableBuilder<DeleteNamespaceResponse.Builder, DeleteNamespaceResponse> {
    private final String operationId;

    private DeleteNamespaceResponse(BuilderImpl builder) {
        super(builder);
        this.operationId = builder.operationId;
    }

    /**
     * <p>
     * A value that you can use to determine whether the request completed successfully. To get the status of the
     * operation, see <a>GetOperation</a>.
     * </p>
     * 
     * @return A value that you can use to determine whether the request completed successfully. To get the status of
     *         the operation, see <a>GetOperation</a>.
     */
    public String operationId() {
        return operationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(operationId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteNamespaceResponse)) {
            return false;
        }
        DeleteNamespaceResponse other = (DeleteNamespaceResponse) obj;
        return Objects.equals(operationId(), other.operationId());
    }

    @Override
    public String toString() {
        return ToString.builder("DeleteNamespaceResponse").add("OperationId", operationId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "OperationId":
            return Optional.of(clazz.cast(operationId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ServiceDiscoveryResponse.Builder, CopyableBuilder<Builder, DeleteNamespaceResponse> {
        /**
         * <p>
         * A value that you can use to determine whether the request completed successfully. To get the status of the
         * operation, see <a>GetOperation</a>.
         * </p>
         * 
         * @param operationId
         *        A value that you can use to determine whether the request completed successfully. To get the status of
         *        the operation, see <a>GetOperation</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder operationId(String operationId);
    }

    static final class BuilderImpl extends ServiceDiscoveryResponse.BuilderImpl implements Builder {
        private String operationId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteNamespaceResponse model) {
            operationId(model.operationId);
        }

        public final String getOperationId() {
            return operationId;
        }

        @Override
        public final Builder operationId(String operationId) {
            this.operationId = operationId;
            return this;
        }

        public final void setOperationId(String operationId) {
            this.operationId = operationId;
        }

        @Override
        public DeleteNamespaceResponse build() {
            return new DeleteNamespaceResponse(this);
        }
    }
}
