/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery;

import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.regions.ServiceMetadata;
import software.amazon.awssdk.services.servicediscovery.model.CreatePrivateDnsNamespaceRequest;
import software.amazon.awssdk.services.servicediscovery.model.CreatePrivateDnsNamespaceResponse;
import software.amazon.awssdk.services.servicediscovery.model.CreatePublicDnsNamespaceRequest;
import software.amazon.awssdk.services.servicediscovery.model.CreatePublicDnsNamespaceResponse;
import software.amazon.awssdk.services.servicediscovery.model.CreateServiceRequest;
import software.amazon.awssdk.services.servicediscovery.model.CreateServiceResponse;
import software.amazon.awssdk.services.servicediscovery.model.DeleteNamespaceRequest;
import software.amazon.awssdk.services.servicediscovery.model.DeleteNamespaceResponse;
import software.amazon.awssdk.services.servicediscovery.model.DeleteServiceRequest;
import software.amazon.awssdk.services.servicediscovery.model.DeleteServiceResponse;
import software.amazon.awssdk.services.servicediscovery.model.DeregisterInstanceRequest;
import software.amazon.awssdk.services.servicediscovery.model.DeregisterInstanceResponse;
import software.amazon.awssdk.services.servicediscovery.model.DuplicateRequestException;
import software.amazon.awssdk.services.servicediscovery.model.GetInstanceRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetInstanceResponse;
import software.amazon.awssdk.services.servicediscovery.model.GetInstancesHealthStatusRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetInstancesHealthStatusResponse;
import software.amazon.awssdk.services.servicediscovery.model.GetNamespaceRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetNamespaceResponse;
import software.amazon.awssdk.services.servicediscovery.model.GetOperationRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetOperationResponse;
import software.amazon.awssdk.services.servicediscovery.model.GetServiceRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetServiceResponse;
import software.amazon.awssdk.services.servicediscovery.model.InstanceNotFoundException;
import software.amazon.awssdk.services.servicediscovery.model.InvalidInputException;
import software.amazon.awssdk.services.servicediscovery.model.ListInstancesRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListInstancesResponse;
import software.amazon.awssdk.services.servicediscovery.model.ListNamespacesRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListNamespacesResponse;
import software.amazon.awssdk.services.servicediscovery.model.ListOperationsRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListOperationsResponse;
import software.amazon.awssdk.services.servicediscovery.model.ListServicesRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListServicesResponse;
import software.amazon.awssdk.services.servicediscovery.model.NamespaceAlreadyExistsException;
import software.amazon.awssdk.services.servicediscovery.model.NamespaceNotFoundException;
import software.amazon.awssdk.services.servicediscovery.model.OperationNotFoundException;
import software.amazon.awssdk.services.servicediscovery.model.RegisterInstanceRequest;
import software.amazon.awssdk.services.servicediscovery.model.RegisterInstanceResponse;
import software.amazon.awssdk.services.servicediscovery.model.ResourceInUseException;
import software.amazon.awssdk.services.servicediscovery.model.ResourceLimitExceededException;
import software.amazon.awssdk.services.servicediscovery.model.ServiceAlreadyExistsException;
import software.amazon.awssdk.services.servicediscovery.model.ServiceDiscoveryException;
import software.amazon.awssdk.services.servicediscovery.model.ServiceNotFoundException;
import software.amazon.awssdk.services.servicediscovery.model.UpdateServiceRequest;
import software.amazon.awssdk.services.servicediscovery.model.UpdateServiceResponse;
import software.amazon.awssdk.services.servicediscovery.paginators.GetInstancesHealthStatusIterable;
import software.amazon.awssdk.services.servicediscovery.paginators.ListInstancesIterable;
import software.amazon.awssdk.services.servicediscovery.paginators.ListNamespacesIterable;
import software.amazon.awssdk.services.servicediscovery.paginators.ListOperationsIterable;
import software.amazon.awssdk.services.servicediscovery.paginators.ListServicesIterable;
import software.amazon.awssdk.utils.SdkAutoCloseable;

/**
 * Service client for accessing ServiceDiscovery. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * Amazon Route 53 autonaming lets you configure public or private namespaces that your microservice applications run
 * in. When instances of the service become available, you can call the autonaming API to register the instance, and
 * Amazon Route 53 automatically creates up to five DNS records and an optional health check. Clients that submit DNS
 * queries for the service receive an answer that contains up to eight healthy records.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface ServiceDiscoveryClient extends SdkClient, SdkAutoCloseable {
    String SERVICE_NAME = "servicediscovery";

    /**
     * Create a {@link ServiceDiscoveryClient} with the region loaded from the
     * {@link software.amazon.awssdk.core.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from
     * the {@link software.amazon.awssdk.core.auth.DefaultCredentialsProvider}.
     */
    static ServiceDiscoveryClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ServiceDiscoveryClient}.
     */
    static ServiceDiscoveryClientBuilder builder() {
        return new DefaultServiceDiscoveryClientBuilder();
    }

    /**
     * <p>
     * Creates a private namespace based on DNS, which will be visible only inside a specified Amazon VPC. The namespace
     * defines your service naming scheme. For example, if you name your namespace <code>example.com</code> and name
     * your service <code>backend</code>, the resulting DNS name for the service will be
     * <code>backend.example.com</code>. You can associate more than one service with the same namespace.
     * </p>
     *
     * @param createPrivateDnsNamespaceRequest
     * @return Result of the CreatePrivateDnsNamespace operation returned by the service.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws NamespaceAlreadyExistsException
     *         The namespace that you're trying to create already exists.
     * @throws ResourceLimitExceededException
     *         The resource can't be created because you've reached the limit on the number of resources.
     * @throws DuplicateRequestException
     *         This request tried to create an object that already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.CreatePrivateDnsNamespace
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/CreatePrivateDnsNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePrivateDnsNamespaceResponse createPrivateDnsNamespace(
            CreatePrivateDnsNamespaceRequest createPrivateDnsNamespaceRequest) throws InvalidInputException,
            NamespaceAlreadyExistsException, ResourceLimitExceededException, DuplicateRequestException, SdkServiceException,
            SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a private namespace based on DNS, which will be visible only inside a specified Amazon VPC. The namespace
     * defines your service naming scheme. For example, if you name your namespace <code>example.com</code> and name
     * your service <code>backend</code>, the resulting DNS name for the service will be
     * <code>backend.example.com</code>. You can associate more than one service with the same namespace.
     * </p>
     *
     * @param createPrivateDnsNamespaceRequest
     * @return Result of the CreatePrivateDnsNamespace operation returned by the service.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws NamespaceAlreadyExistsException
     *         The namespace that you're trying to create already exists.
     * @throws ResourceLimitExceededException
     *         The resource can't be created because you've reached the limit on the number of resources.
     * @throws DuplicateRequestException
     *         This request tried to create an object that already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.CreatePrivateDnsNamespace
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/CreatePrivateDnsNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePrivateDnsNamespaceResponse createPrivateDnsNamespace(
            Consumer<CreatePrivateDnsNamespaceRequest.Builder> createPrivateDnsNamespaceRequest) throws InvalidInputException,
            NamespaceAlreadyExistsException, ResourceLimitExceededException, DuplicateRequestException, SdkServiceException,
            SdkClientException, ServiceDiscoveryException {
        return createPrivateDnsNamespace(CreatePrivateDnsNamespaceRequest.builder().apply(createPrivateDnsNamespaceRequest)
                .build());
    }

    /**
     * <p>
     * Creates a public namespace based on DNS, which will be visible on the internet. The namespace defines your
     * service naming scheme. For example, if you name your namespace <code>example.com</code> and name your service
     * <code>backend</code>, the resulting DNS name for the service will be <code>backend.example.com</code>. You can
     * associate more than one service with the same namespace.
     * </p>
     *
     * @param createPublicDnsNamespaceRequest
     * @return Result of the CreatePublicDnsNamespace operation returned by the service.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws NamespaceAlreadyExistsException
     *         The namespace that you're trying to create already exists.
     * @throws ResourceLimitExceededException
     *         The resource can't be created because you've reached the limit on the number of resources.
     * @throws DuplicateRequestException
     *         This request tried to create an object that already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.CreatePublicDnsNamespace
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/CreatePublicDnsNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePublicDnsNamespaceResponse createPublicDnsNamespace(
            CreatePublicDnsNamespaceRequest createPublicDnsNamespaceRequest) throws InvalidInputException,
            NamespaceAlreadyExistsException, ResourceLimitExceededException, DuplicateRequestException, SdkServiceException,
            SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a public namespace based on DNS, which will be visible on the internet. The namespace defines your
     * service naming scheme. For example, if you name your namespace <code>example.com</code> and name your service
     * <code>backend</code>, the resulting DNS name for the service will be <code>backend.example.com</code>. You can
     * associate more than one service with the same namespace.
     * </p>
     *
     * @param createPublicDnsNamespaceRequest
     * @return Result of the CreatePublicDnsNamespace operation returned by the service.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws NamespaceAlreadyExistsException
     *         The namespace that you're trying to create already exists.
     * @throws ResourceLimitExceededException
     *         The resource can't be created because you've reached the limit on the number of resources.
     * @throws DuplicateRequestException
     *         This request tried to create an object that already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.CreatePublicDnsNamespace
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/CreatePublicDnsNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CreatePublicDnsNamespaceResponse createPublicDnsNamespace(
            Consumer<CreatePublicDnsNamespaceRequest.Builder> createPublicDnsNamespaceRequest) throws InvalidInputException,
            NamespaceAlreadyExistsException, ResourceLimitExceededException, DuplicateRequestException, SdkServiceException,
            SdkClientException, ServiceDiscoveryException {
        return createPublicDnsNamespace(CreatePublicDnsNamespaceRequest.builder().apply(createPublicDnsNamespaceRequest).build());
    }

    /**
     * <p>
     * Creates a service, which defines a template for the following entities:
     * </p>
     * <ul>
     * <li>
     * <p>
     * One to five resource record sets
     * </p>
     * </li>
     * <li>
     * <p>
     * Optionally, a health check
     * </p>
     * </li>
     * </ul>
     * <p>
     * After you create the service, you can submit a <a>RegisterInstance</a> request, and Amazon Route 53 uses the
     * values in the template to create the specified entities.
     * </p>
     *
     * @param createServiceRequest
     * @return Result of the CreateService operation returned by the service.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws ResourceLimitExceededException
     *         The resource can't be created because you've reached the limit on the number of resources.
     * @throws NamespaceNotFoundException
     *         No namespace exists with the specified ID.
     * @throws ServiceAlreadyExistsException
     *         The service can't be created because a service with the same name already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.CreateService
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/CreateService" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateServiceResponse createService(CreateServiceRequest createServiceRequest) throws InvalidInputException,
            ResourceLimitExceededException, NamespaceNotFoundException, ServiceAlreadyExistsException, SdkServiceException,
            SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a service, which defines a template for the following entities:
     * </p>
     * <ul>
     * <li>
     * <p>
     * One to five resource record sets
     * </p>
     * </li>
     * <li>
     * <p>
     * Optionally, a health check
     * </p>
     * </li>
     * </ul>
     * <p>
     * After you create the service, you can submit a <a>RegisterInstance</a> request, and Amazon Route 53 uses the
     * values in the template to create the specified entities.
     * </p>
     *
     * @param createServiceRequest
     * @return Result of the CreateService operation returned by the service.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws ResourceLimitExceededException
     *         The resource can't be created because you've reached the limit on the number of resources.
     * @throws NamespaceNotFoundException
     *         No namespace exists with the specified ID.
     * @throws ServiceAlreadyExistsException
     *         The service can't be created because a service with the same name already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.CreateService
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/CreateService" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateServiceResponse createService(Consumer<CreateServiceRequest.Builder> createServiceRequest)
            throws InvalidInputException, ResourceLimitExceededException, NamespaceNotFoundException,
            ServiceAlreadyExistsException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return createService(CreateServiceRequest.builder().apply(createServiceRequest).build());
    }

    /**
     * <p>
     * Deletes a namespace from the current account. If the namespace still contains one or more services, the request
     * fails.
     * </p>
     *
     * @param deleteNamespaceRequest
     * @return Result of the DeleteNamespace operation returned by the service.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws NamespaceNotFoundException
     *         No namespace exists with the specified ID.
     * @throws ResourceInUseException
     *         The specified resource can't be deleted because it contains other resources. For example, you can't
     *         delete a service that contains any instances.
     * @throws DuplicateRequestException
     *         This request tried to create an object that already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.DeleteNamespace
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DeleteNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNamespaceResponse deleteNamespace(DeleteNamespaceRequest deleteNamespaceRequest) throws InvalidInputException,
            NamespaceNotFoundException, ResourceInUseException, DuplicateRequestException, SdkServiceException,
            SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a namespace from the current account. If the namespace still contains one or more services, the request
     * fails.
     * </p>
     *
     * @param deleteNamespaceRequest
     * @return Result of the DeleteNamespace operation returned by the service.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws NamespaceNotFoundException
     *         No namespace exists with the specified ID.
     * @throws ResourceInUseException
     *         The specified resource can't be deleted because it contains other resources. For example, you can't
     *         delete a service that contains any instances.
     * @throws DuplicateRequestException
     *         This request tried to create an object that already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.DeleteNamespace
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DeleteNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteNamespaceResponse deleteNamespace(Consumer<DeleteNamespaceRequest.Builder> deleteNamespaceRequest)
            throws InvalidInputException, NamespaceNotFoundException, ResourceInUseException, DuplicateRequestException,
            SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return deleteNamespace(DeleteNamespaceRequest.builder().apply(deleteNamespaceRequest).build());
    }

    /**
     * <p>
     * Deletes a specified service. If the service still contains one or more registered instances, the request fails.
     * </p>
     *
     * @param deleteServiceRequest
     * @return Result of the DeleteService operation returned by the service.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws ServiceNotFoundException
     *         No service exists with the specified ID.
     * @throws ResourceInUseException
     *         The specified resource can't be deleted because it contains other resources. For example, you can't
     *         delete a service that contains any instances.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.DeleteService
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DeleteService" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteServiceResponse deleteService(DeleteServiceRequest deleteServiceRequest) throws InvalidInputException,
            ServiceNotFoundException, ResourceInUseException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified service. If the service still contains one or more registered instances, the request fails.
     * </p>
     *
     * @param deleteServiceRequest
     * @return Result of the DeleteService operation returned by the service.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws ServiceNotFoundException
     *         No service exists with the specified ID.
     * @throws ResourceInUseException
     *         The specified resource can't be deleted because it contains other resources. For example, you can't
     *         delete a service that contains any instances.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.DeleteService
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DeleteService" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteServiceResponse deleteService(Consumer<DeleteServiceRequest.Builder> deleteServiceRequest)
            throws InvalidInputException, ServiceNotFoundException, ResourceInUseException, SdkServiceException,
            SdkClientException, ServiceDiscoveryException {
        return deleteService(DeleteServiceRequest.builder().apply(deleteServiceRequest).build());
    }

    /**
     * <p>
     * Deletes the resource record sets and the health check, if any, that Amazon Route 53 created for the specified
     * instance.
     * </p>
     *
     * @param deregisterInstanceRequest
     * @return Result of the DeregisterInstance operation returned by the service.
     * @throws DuplicateRequestException
     *         This request tried to create an object that already exists.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws InstanceNotFoundException
     *         No instance exists with the specified ID.
     * @throws ResourceInUseException
     *         The specified resource can't be deleted because it contains other resources. For example, you can't
     *         delete a service that contains any instances.
     * @throws ServiceNotFoundException
     *         No service exists with the specified ID.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.DeregisterInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DeregisterInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterInstanceResponse deregisterInstance(DeregisterInstanceRequest deregisterInstanceRequest)
            throws DuplicateRequestException, InvalidInputException, InstanceNotFoundException, ResourceInUseException,
            ServiceNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the resource record sets and the health check, if any, that Amazon Route 53 created for the specified
     * instance.
     * </p>
     *
     * @param deregisterInstanceRequest
     * @return Result of the DeregisterInstance operation returned by the service.
     * @throws DuplicateRequestException
     *         This request tried to create an object that already exists.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws InstanceNotFoundException
     *         No instance exists with the specified ID.
     * @throws ResourceInUseException
     *         The specified resource can't be deleted because it contains other resources. For example, you can't
     *         delete a service that contains any instances.
     * @throws ServiceNotFoundException
     *         No service exists with the specified ID.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.DeregisterInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DeregisterInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default DeregisterInstanceResponse deregisterInstance(Consumer<DeregisterInstanceRequest.Builder> deregisterInstanceRequest)
            throws DuplicateRequestException, InvalidInputException, InstanceNotFoundException, ResourceInUseException,
            ServiceNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return deregisterInstance(DeregisterInstanceRequest.builder().apply(deregisterInstanceRequest).build());
    }

    /**
     * <p>
     * Gets information about a specified instance.
     * </p>
     *
     * @param getInstanceRequest
     * @return Result of the GetInstance operation returned by the service.
     * @throws InstanceNotFoundException
     *         No instance exists with the specified ID.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws ServiceNotFoundException
     *         No service exists with the specified ID.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.GetInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default GetInstanceResponse getInstance(GetInstanceRequest getInstanceRequest) throws InstanceNotFoundException,
            InvalidInputException, ServiceNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specified instance.
     * </p>
     *
     * @param getInstanceRequest
     * @return Result of the GetInstance operation returned by the service.
     * @throws InstanceNotFoundException
     *         No instance exists with the specified ID.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws ServiceNotFoundException
     *         No service exists with the specified ID.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.GetInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default GetInstanceResponse getInstance(Consumer<GetInstanceRequest.Builder> getInstanceRequest)
            throws InstanceNotFoundException, InvalidInputException, ServiceNotFoundException, SdkServiceException,
            SdkClientException, ServiceDiscoveryException {
        return getInstance(GetInstanceRequest.builder().apply(getInstanceRequest).build());
    }

    /**
     * <p>
     * Gets the current health status (<code>Healthy</code>, <code>Unhealthy</code>, or <code>Unknown</code>) of one or
     * more instances that are associated with a specified service.
     * </p>
     *
     * @param getInstancesHealthStatusRequest
     * @return Result of the GetInstancesHealthStatus operation returned by the service.
     * @throws InstanceNotFoundException
     *         No instance exists with the specified ID.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws ServiceNotFoundException
     *         No service exists with the specified ID.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.GetInstancesHealthStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetInstancesHealthStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetInstancesHealthStatusResponse getInstancesHealthStatus(
            GetInstancesHealthStatusRequest getInstancesHealthStatusRequest) throws InstanceNotFoundException,
            InvalidInputException, ServiceNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the current health status (<code>Healthy</code>, <code>Unhealthy</code>, or <code>Unknown</code>) of one or
     * more instances that are associated with a specified service.
     * </p>
     *
     * @param getInstancesHealthStatusRequest
     * @return Result of the GetInstancesHealthStatus operation returned by the service.
     * @throws InstanceNotFoundException
     *         No instance exists with the specified ID.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws ServiceNotFoundException
     *         No service exists with the specified ID.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.GetInstancesHealthStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetInstancesHealthStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetInstancesHealthStatusResponse getInstancesHealthStatus(
            Consumer<GetInstancesHealthStatusRequest.Builder> getInstancesHealthStatusRequest) throws InstanceNotFoundException,
            InvalidInputException, ServiceNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return getInstancesHealthStatus(GetInstancesHealthStatusRequest.builder().apply(getInstancesHealthStatusRequest).build());
    }

    /**
     * <p>
     * Gets the current health status (<code>Healthy</code>, <code>Unhealthy</code>, or <code>Unknown</code>) of one or
     * more instances that are associated with a specified service.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #getInstancesHealthStatus(software.amazon.awssdk.services.servicediscovery.model.GetInstancesHealthStatusRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicediscovery.paginators.GetInstancesHealthStatusIterable responses = client.getInstancesHealthStatusPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicediscovery.paginators.GetInstancesHealthStatusIterable responses = client
     *             .getInstancesHealthStatusPaginator(request);
     *     for (software.amazon.awssdk.services.servicediscovery.model.GetInstancesHealthStatusResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicediscovery.paginators.GetInstancesHealthStatusIterable responses = client.getInstancesHealthStatusPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #getInstancesHealthStatus(software.amazon.awssdk.services.servicediscovery.model.GetInstancesHealthStatusRequest)}
     * operation.</b>
     * </p>
     *
     * @param getInstancesHealthStatusRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InstanceNotFoundException
     *         No instance exists with the specified ID.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws ServiceNotFoundException
     *         No service exists with the specified ID.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.GetInstancesHealthStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetInstancesHealthStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetInstancesHealthStatusIterable getInstancesHealthStatusPaginator(
            GetInstancesHealthStatusRequest getInstancesHealthStatusRequest) throws InstanceNotFoundException,
            InvalidInputException, ServiceNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a namespace.
     * </p>
     *
     * @param getNamespaceRequest
     * @return Result of the GetNamespace operation returned by the service.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws NamespaceNotFoundException
     *         No namespace exists with the specified ID.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.GetNamespace
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetNamespace" target="_top">AWS
     *      API Documentation</a>
     */
    default GetNamespaceResponse getNamespace(GetNamespaceRequest getNamespaceRequest) throws InvalidInputException,
            NamespaceNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a namespace.
     * </p>
     *
     * @param getNamespaceRequest
     * @return Result of the GetNamespace operation returned by the service.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws NamespaceNotFoundException
     *         No namespace exists with the specified ID.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.GetNamespace
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetNamespace" target="_top">AWS
     *      API Documentation</a>
     */
    default GetNamespaceResponse getNamespace(Consumer<GetNamespaceRequest.Builder> getNamespaceRequest)
            throws InvalidInputException, NamespaceNotFoundException, SdkServiceException, SdkClientException,
            ServiceDiscoveryException {
        return getNamespace(GetNamespaceRequest.builder().apply(getNamespaceRequest).build());
    }

    /**
     * <p>
     * Gets information about any operation that returns an operation ID in the response, such as a
     * <code>CreateService</code> request. To get a list of operations that match specified criteria, see
     * <a>ListOperations</a>.
     * </p>
     *
     * @param getOperationRequest
     * @return Result of the GetOperation operation returned by the service.
     * @throws OperationNotFoundException
     *         No operation exists with the specified ID.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.GetOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetOperation" target="_top">AWS
     *      API Documentation</a>
     */
    default GetOperationResponse getOperation(GetOperationRequest getOperationRequest) throws OperationNotFoundException,
            SdkServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about any operation that returns an operation ID in the response, such as a
     * <code>CreateService</code> request. To get a list of operations that match specified criteria, see
     * <a>ListOperations</a>.
     * </p>
     *
     * @param getOperationRequest
     * @return Result of the GetOperation operation returned by the service.
     * @throws OperationNotFoundException
     *         No operation exists with the specified ID.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.GetOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetOperation" target="_top">AWS
     *      API Documentation</a>
     */
    default GetOperationResponse getOperation(Consumer<GetOperationRequest.Builder> getOperationRequest)
            throws OperationNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return getOperation(GetOperationRequest.builder().apply(getOperationRequest).build());
    }

    /**
     * <p>
     * Gets the settings for a specified service.
     * </p>
     *
     * @param getServiceRequest
     * @return Result of the GetService operation returned by the service.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws ServiceNotFoundException
     *         No service exists with the specified ID.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.GetService
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetService" target="_top">AWS
     *      API Documentation</a>
     */
    default GetServiceResponse getService(GetServiceRequest getServiceRequest) throws InvalidInputException,
            ServiceNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the settings for a specified service.
     * </p>
     *
     * @param getServiceRequest
     * @return Result of the GetService operation returned by the service.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws ServiceNotFoundException
     *         No service exists with the specified ID.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.GetService
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetService" target="_top">AWS
     *      API Documentation</a>
     */
    default GetServiceResponse getService(Consumer<GetServiceRequest.Builder> getServiceRequest) throws InvalidInputException,
            ServiceNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return getService(GetServiceRequest.builder().apply(getServiceRequest).build());
    }

    /**
     * <p>
     * Gets summary information about the instances that you created by using a specified service.
     * </p>
     *
     * @param listInstancesRequest
     * @return Result of the ListInstances operation returned by the service.
     * @throws ServiceNotFoundException
     *         No service exists with the specified ID.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.ListInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInstancesResponse listInstances(ListInstancesRequest listInstancesRequest) throws ServiceNotFoundException,
            InvalidInputException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets summary information about the instances that you created by using a specified service.
     * </p>
     *
     * @param listInstancesRequest
     * @return Result of the ListInstances operation returned by the service.
     * @throws ServiceNotFoundException
     *         No service exists with the specified ID.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.ListInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInstancesResponse listInstances(Consumer<ListInstancesRequest.Builder> listInstancesRequest)
            throws ServiceNotFoundException, InvalidInputException, SdkServiceException, SdkClientException,
            ServiceDiscoveryException {
        return listInstances(ListInstancesRequest.builder().apply(listInstancesRequest).build());
    }

    /**
     * <p>
     * Gets summary information about the instances that you created by using a specified service.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listInstances(software.amazon.awssdk.services.servicediscovery.model.ListInstancesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicediscovery.paginators.ListInstancesIterable responses = client.listInstancesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicediscovery.paginators.ListInstancesIterable responses = client
     *             .listInstancesPaginator(request);
     *     for (software.amazon.awssdk.services.servicediscovery.model.ListInstancesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicediscovery.paginators.ListInstancesIterable responses = client.listInstancesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listInstances(software.amazon.awssdk.services.servicediscovery.model.ListInstancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listInstancesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ServiceNotFoundException
     *         No service exists with the specified ID.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.ListInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default ListInstancesIterable listInstancesPaginator(ListInstancesRequest listInstancesRequest)
            throws ServiceNotFoundException, InvalidInputException, SdkServiceException, SdkClientException,
            ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the namespaces that were created by the current AWS account.
     * </p>
     *
     * @return Result of the ListNamespaces operation returned by the service.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.ListNamespaces
     * @see #listNamespaces(ListNamespacesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListNamespaces"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNamespacesResponse listNamespaces() throws InvalidInputException, SdkServiceException, SdkClientException,
            ServiceDiscoveryException {
        return listNamespaces(ListNamespacesRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about the namespaces that were created by the current AWS account.
     * </p>
     *
     * @param listNamespacesRequest
     * @return Result of the ListNamespaces operation returned by the service.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.ListNamespaces
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListNamespaces"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNamespacesResponse listNamespaces(ListNamespacesRequest listNamespacesRequest) throws InvalidInputException,
            SdkServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the namespaces that were created by the current AWS account.
     * </p>
     *
     * @param listNamespacesRequest
     * @return Result of the ListNamespaces operation returned by the service.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.ListNamespaces
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListNamespaces"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNamespacesResponse listNamespaces(Consumer<ListNamespacesRequest.Builder> listNamespacesRequest)
            throws InvalidInputException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return listNamespaces(ListNamespacesRequest.builder().apply(listNamespacesRequest).build());
    }

    /**
     * <p>
     * Gets information about the namespaces that were created by the current AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNamespaces(software.amazon.awssdk.services.servicediscovery.model.ListNamespacesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicediscovery.paginators.ListNamespacesIterable responses = client.listNamespacesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicediscovery.paginators.ListNamespacesIterable responses = client
     *             .listNamespacesPaginator(request);
     *     for (software.amazon.awssdk.services.servicediscovery.model.ListNamespacesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicediscovery.paginators.ListNamespacesIterable responses = client.listNamespacesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNamespaces(software.amazon.awssdk.services.servicediscovery.model.ListNamespacesRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.ListNamespaces
     * @see #listNamespacesPaginator(ListNamespacesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListNamespaces"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNamespacesIterable listNamespacesPaginator() throws InvalidInputException, SdkServiceException,
            SdkClientException, ServiceDiscoveryException {
        return listNamespacesPaginator(ListNamespacesRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about the namespaces that were created by the current AWS account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNamespaces(software.amazon.awssdk.services.servicediscovery.model.ListNamespacesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicediscovery.paginators.ListNamespacesIterable responses = client.listNamespacesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicediscovery.paginators.ListNamespacesIterable responses = client
     *             .listNamespacesPaginator(request);
     *     for (software.amazon.awssdk.services.servicediscovery.model.ListNamespacesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicediscovery.paginators.ListNamespacesIterable responses = client.listNamespacesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNamespaces(software.amazon.awssdk.services.servicediscovery.model.ListNamespacesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listNamespacesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.ListNamespaces
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListNamespaces"
     *      target="_top">AWS API Documentation</a>
     */
    default ListNamespacesIterable listNamespacesPaginator(ListNamespacesRequest listNamespacesRequest)
            throws InvalidInputException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists operations that match the criteria that you specify.
     * </p>
     *
     * @return Result of the ListOperations operation returned by the service.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.ListOperations
     * @see #listOperations(ListOperationsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOperationsResponse listOperations() throws InvalidInputException, SdkServiceException, SdkClientException,
            ServiceDiscoveryException {
        return listOperations(ListOperationsRequest.builder().build());
    }

    /**
     * <p>
     * Lists operations that match the criteria that you specify.
     * </p>
     *
     * @param listOperationsRequest
     * @return Result of the ListOperations operation returned by the service.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.ListOperations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOperationsResponse listOperations(ListOperationsRequest listOperationsRequest) throws InvalidInputException,
            SdkServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists operations that match the criteria that you specify.
     * </p>
     *
     * @param listOperationsRequest
     * @return Result of the ListOperations operation returned by the service.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.ListOperations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOperationsResponse listOperations(Consumer<ListOperationsRequest.Builder> listOperationsRequest)
            throws InvalidInputException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return listOperations(ListOperationsRequest.builder().apply(listOperationsRequest).build());
    }

    /**
     * <p>
     * Lists operations that match the criteria that you specify.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOperations(software.amazon.awssdk.services.servicediscovery.model.ListOperationsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicediscovery.paginators.ListOperationsIterable responses = client.listOperationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicediscovery.paginators.ListOperationsIterable responses = client
     *             .listOperationsPaginator(request);
     *     for (software.amazon.awssdk.services.servicediscovery.model.ListOperationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicediscovery.paginators.ListOperationsIterable responses = client.listOperationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOperations(software.amazon.awssdk.services.servicediscovery.model.ListOperationsRequest)}
     * operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.ListOperations
     * @see #listOperationsPaginator(ListOperationsRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOperationsIterable listOperationsPaginator() throws InvalidInputException, SdkServiceException,
            SdkClientException, ServiceDiscoveryException {
        return listOperationsPaginator(ListOperationsRequest.builder().build());
    }

    /**
     * <p>
     * Lists operations that match the criteria that you specify.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listOperations(software.amazon.awssdk.services.servicediscovery.model.ListOperationsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicediscovery.paginators.ListOperationsIterable responses = client.listOperationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicediscovery.paginators.ListOperationsIterable responses = client
     *             .listOperationsPaginator(request);
     *     for (software.amazon.awssdk.services.servicediscovery.model.ListOperationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicediscovery.paginators.ListOperationsIterable responses = client.listOperationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOperations(software.amazon.awssdk.services.servicediscovery.model.ListOperationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOperationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.ListOperations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOperationsIterable listOperationsPaginator(ListOperationsRequest listOperationsRequest)
            throws InvalidInputException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets settings for all the services that are associated with one or more specified namespaces.
     * </p>
     *
     * @return Result of the ListServices operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.ListServices
     * @see #listServices(ListServicesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListServices" target="_top">AWS
     *      API Documentation</a>
     */
    default ListServicesResponse listServices() throws SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return listServices(ListServicesRequest.builder().build());
    }

    /**
     * <p>
     * Gets settings for all the services that are associated with one or more specified namespaces.
     * </p>
     *
     * @param listServicesRequest
     * @return Result of the ListServices operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.ListServices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListServices" target="_top">AWS
     *      API Documentation</a>
     */
    default ListServicesResponse listServices(ListServicesRequest listServicesRequest) throws SdkServiceException,
            SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets settings for all the services that are associated with one or more specified namespaces.
     * </p>
     *
     * @param listServicesRequest
     * @return Result of the ListServices operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.ListServices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListServices" target="_top">AWS
     *      API Documentation</a>
     */
    default ListServicesResponse listServices(Consumer<ListServicesRequest.Builder> listServicesRequest)
            throws SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return listServices(ListServicesRequest.builder().apply(listServicesRequest).build());
    }

    /**
     * <p>
     * Gets settings for all the services that are associated with one or more specified namespaces.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listServices(software.amazon.awssdk.services.servicediscovery.model.ListServicesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicediscovery.paginators.ListServicesIterable responses = client.listServicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicediscovery.paginators.ListServicesIterable responses = client
     *             .listServicesPaginator(request);
     *     for (software.amazon.awssdk.services.servicediscovery.model.ListServicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicediscovery.paginators.ListServicesIterable responses = client.listServicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServices(software.amazon.awssdk.services.servicediscovery.model.ListServicesRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.ListServices
     * @see #listServicesPaginator(ListServicesRequest)
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListServices" target="_top">AWS
     *      API Documentation</a>
     */
    default ListServicesIterable listServicesPaginator() throws SdkServiceException, SdkClientException,
            ServiceDiscoveryException {
        return listServicesPaginator(ListServicesRequest.builder().build());
    }

    /**
     * <p>
     * Gets settings for all the services that are associated with one or more specified namespaces.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listServices(software.amazon.awssdk.services.servicediscovery.model.ListServicesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicediscovery.paginators.ListServicesIterable responses = client.listServicesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.servicediscovery.paginators.ListServicesIterable responses = client
     *             .listServicesPaginator(request);
     *     for (software.amazon.awssdk.services.servicediscovery.model.ListServicesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.servicediscovery.paginators.ListServicesIterable responses = client.listServicesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listServices(software.amazon.awssdk.services.servicediscovery.model.ListServicesRequest)} operation.</b>
     * </p>
     *
     * @param listServicesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.ListServices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListServices" target="_top">AWS
     *      API Documentation</a>
     */
    default ListServicesIterable listServicesPaginator(ListServicesRequest listServicesRequest) throws SdkServiceException,
            SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates one or more resource record sets and optionally a health check based on the settings in a specified
     * service. When you submit a <code>RegisterInstance</code> request, Amazon Route 53 does the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Creates a resource record set for each resource record set template in the service
     * </p>
     * </li>
     * <li>
     * <p>
     * Creates a health check based on the settings in the health check template in the service, if any
     * </p>
     * </li>
     * <li>
     * <p>
     * Associates the health check, if any, with each of the resource record sets
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * One <code>RegisterInstance</code> request must complete before you can submit another request and specify the
     * same service and instance ID.
     * </p>
     * </important>
     * <p>
     * For more information, see <a>CreateService</a>.
     * </p>
     * <p>
     * When Amazon Route 53 receives a DNS query for the specified DNS name, it returns the applicable value:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>If the health check is healthy</b>: returns all the resource record sets
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>If the health check is unhealthy</b>: returns the IP address of the last healthy instance
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>If you didn't specify a health check template</b>: returns all the resource record sets
     * </p>
     * </li>
     * </ul>
     *
     * @param registerInstanceRequest
     * @return Result of the RegisterInstance operation returned by the service.
     * @throws DuplicateRequestException
     *         This request tried to create an object that already exists.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws ResourceInUseException
     *         The specified resource can't be deleted because it contains other resources. For example, you can't
     *         delete a service that contains any instances.
     * @throws ResourceLimitExceededException
     *         The resource can't be created because you've reached the limit on the number of resources.
     * @throws ServiceNotFoundException
     *         No service exists with the specified ID.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.RegisterInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/RegisterInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterInstanceResponse registerInstance(RegisterInstanceRequest registerInstanceRequest)
            throws DuplicateRequestException, InvalidInputException, ResourceInUseException, ResourceLimitExceededException,
            ServiceNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates one or more resource record sets and optionally a health check based on the settings in a specified
     * service. When you submit a <code>RegisterInstance</code> request, Amazon Route 53 does the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Creates a resource record set for each resource record set template in the service
     * </p>
     * </li>
     * <li>
     * <p>
     * Creates a health check based on the settings in the health check template in the service, if any
     * </p>
     * </li>
     * <li>
     * <p>
     * Associates the health check, if any, with each of the resource record sets
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * One <code>RegisterInstance</code> request must complete before you can submit another request and specify the
     * same service and instance ID.
     * </p>
     * </important>
     * <p>
     * For more information, see <a>CreateService</a>.
     * </p>
     * <p>
     * When Amazon Route 53 receives a DNS query for the specified DNS name, it returns the applicable value:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>If the health check is healthy</b>: returns all the resource record sets
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>If the health check is unhealthy</b>: returns the IP address of the last healthy instance
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>If you didn't specify a health check template</b>: returns all the resource record sets
     * </p>
     * </li>
     * </ul>
     *
     * @param registerInstanceRequest
     * @return Result of the RegisterInstance operation returned by the service.
     * @throws DuplicateRequestException
     *         This request tried to create an object that already exists.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws ResourceInUseException
     *         The specified resource can't be deleted because it contains other resources. For example, you can't
     *         delete a service that contains any instances.
     * @throws ResourceLimitExceededException
     *         The resource can't be created because you've reached the limit on the number of resources.
     * @throws ServiceNotFoundException
     *         No service exists with the specified ID.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.RegisterInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/RegisterInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default RegisterInstanceResponse registerInstance(Consumer<RegisterInstanceRequest.Builder> registerInstanceRequest)
            throws DuplicateRequestException, InvalidInputException, ResourceInUseException, ResourceLimitExceededException,
            ServiceNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        return registerInstance(RegisterInstanceRequest.builder().apply(registerInstanceRequest).build());
    }

    /**
     * <p>
     * Updates the TTL setting for a specified service. You must specify all the resource record set templates (and,
     * optionally, a health check template) that you want to appear in the updated service. Any current resource record
     * set templates (or health check template) that don't appear in an <code>UpdateService</code> request are deleted.
     * </p>
     * <p>
     * When you update the TTL setting for a service, Amazon Route 53 also updates the corresponding settings in all the
     * resource record sets and health checks that were created by using the specified service.
     * </p>
     *
     * @param updateServiceRequest
     * @return Result of the UpdateService operation returned by the service.
     * @throws DuplicateRequestException
     *         This request tried to create an object that already exists.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws ServiceNotFoundException
     *         No service exists with the specified ID.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.UpdateService
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/UpdateService" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateServiceResponse updateService(UpdateServiceRequest updateServiceRequest) throws DuplicateRequestException,
            InvalidInputException, ServiceNotFoundException, SdkServiceException, SdkClientException, ServiceDiscoveryException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the TTL setting for a specified service. You must specify all the resource record set templates (and,
     * optionally, a health check template) that you want to appear in the updated service. Any current resource record
     * set templates (or health check template) that don't appear in an <code>UpdateService</code> request are deleted.
     * </p>
     * <p>
     * When you update the TTL setting for a service, Amazon Route 53 also updates the corresponding settings in all the
     * resource record sets and health checks that were created by using the specified service.
     * </p>
     *
     * @param updateServiceRequest
     * @return Result of the UpdateService operation returned by the service.
     * @throws DuplicateRequestException
     *         This request tried to create an object that already exists.
     * @throws InvalidInputException
     *         One or more specified values aren't valid. For example, when you're creating a namespace, the value of
     *         <code>Name</code> might not be a valid DNS name.
     * @throws ServiceNotFoundException
     *         No service exists with the specified ID.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws ServiceDiscoveryException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample ServiceDiscoveryClient.UpdateService
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/UpdateService" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateServiceResponse updateService(Consumer<UpdateServiceRequest.Builder> updateServiceRequest)
            throws DuplicateRequestException, InvalidInputException, ServiceNotFoundException, SdkServiceException,
            SdkClientException, ServiceDiscoveryException {
        return updateService(UpdateServiceRequest.builder().apply(updateServiceRequest).build());
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of("servicediscovery");
    }
}
