/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class UpdateServiceRequest extends ServiceDiscoveryRequest implements
        ToCopyableBuilder<UpdateServiceRequest.Builder, UpdateServiceRequest> {
    private final String id;

    private final ServiceChange service;

    private UpdateServiceRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.service = builder.service;
    }

    /**
     * <p>
     * The ID of the service that you want to update.
     * </p>
     * 
     * @return The ID of the service that you want to update.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * A complex type that contains the new settings for the service.
     * </p>
     * 
     * @return A complex type that contains the new settings for the service.
     */
    public ServiceChange service() {
        return service;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(service());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceRequest)) {
            return false;
        }
        UpdateServiceRequest other = (UpdateServiceRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(service(), other.service());
    }

    @Override
    public String toString() {
        return ToString.builder("UpdateServiceRequest").add("Id", id()).add("Service", service()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.of(clazz.cast(id()));
        case "Service":
            return Optional.of(clazz.cast(service()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ServiceDiscoveryRequest.Builder, CopyableBuilder<Builder, UpdateServiceRequest> {
        /**
         * <p>
         * The ID of the service that you want to update.
         * </p>
         * 
         * @param id
         *        The ID of the service that you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A complex type that contains the new settings for the service.
         * </p>
         * 
         * @param service
         *        A complex type that contains the new settings for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(ServiceChange service);

        /**
         * <p>
         * A complex type that contains the new settings for the service.
         * </p>
         * This is a convenience that creates an instance of the {@link ServiceChange.Builder} avoiding the need to
         * create one manually via {@link ServiceChange#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServiceChange.Builder#build()} is called immediately and its
         * result is passed to {@link #service(ServiceChange)}.
         * 
         * @param service
         *        a consumer that will call methods on {@link ServiceChange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #service(ServiceChange)
         */
        default Builder service(Consumer<ServiceChange.Builder> service) {
            return service(ServiceChange.builder().apply(service).build());
        }

        @Override
        Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig);
    }

    static final class BuilderImpl extends ServiceDiscoveryRequest.BuilderImpl implements Builder {
        private String id;

        private ServiceChange service;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceRequest model) {
            id(model.id);
            service(model.service);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final ServiceChange.Builder getService() {
            return service != null ? service.toBuilder() : null;
        }

        @Override
        public final Builder service(ServiceChange service) {
            this.service = service;
            return this;
        }

        public final void setService(ServiceChange.BuilderImpl service) {
            this.service = service != null ? service.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public UpdateServiceRequest build() {
            return new UpdateServiceRequest(this);
        }
    }
}
