/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetNamespaceResponse extends ServiceDiscoveryResponse implements
        ToCopyableBuilder<GetNamespaceResponse.Builder, GetNamespaceResponse> {
    private final Namespace namespace;

    private GetNamespaceResponse(BuilderImpl builder) {
        super(builder);
        this.namespace = builder.namespace;
    }

    /**
     * <p>
     * A complex type that contains information about the specified namespace.
     * </p>
     * 
     * @return A complex type that contains information about the specified namespace.
     */
    public Namespace namespace() {
        return namespace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetNamespaceResponse)) {
            return false;
        }
        GetNamespaceResponse other = (GetNamespaceResponse) obj;
        return Objects.equals(namespace(), other.namespace());
    }

    @Override
    public String toString() {
        return ToString.builder("GetNamespaceResponse").add("Namespace", namespace()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Namespace":
            return Optional.of(clazz.cast(namespace()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ServiceDiscoveryResponse.Builder, CopyableBuilder<Builder, GetNamespaceResponse> {
        /**
         * <p>
         * A complex type that contains information about the specified namespace.
         * </p>
         * 
         * @param namespace
         *        A complex type that contains information about the specified namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(Namespace namespace);

        /**
         * <p>
         * A complex type that contains information about the specified namespace.
         * </p>
         * This is a convenience that creates an instance of the {@link Namespace.Builder} avoiding the need to create
         * one manually via {@link Namespace#builder()}.
         *
         * When the {@link Consumer} completes, {@link Namespace.Builder#build()} is called immediately and its result
         * is passed to {@link #namespace(Namespace)}.
         * 
         * @param namespace
         *        a consumer that will call methods on {@link Namespace.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #namespace(Namespace)
         */
        default Builder namespace(Consumer<Namespace.Builder> namespace) {
            return namespace(Namespace.builder().apply(namespace).build());
        }
    }

    static final class BuilderImpl extends ServiceDiscoveryResponse.BuilderImpl implements Builder {
        private Namespace namespace;

        private BuilderImpl() {
        }

        private BuilderImpl(GetNamespaceResponse model) {
            namespace(model.namespace);
        }

        public final Namespace.Builder getNamespace() {
            return namespace != null ? namespace.toBuilder() : null;
        }

        @Override
        public final Builder namespace(Namespace namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(Namespace.BuilderImpl namespace) {
            this.namespace = namespace != null ? namespace.build() : null;
        }

        @Override
        public GetNamespaceResponse build() {
            return new GetNamespaceResponse(this);
        }
    }
}
