/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Generated;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class GetInstancesHealthStatusResponse extends ServiceDiscoveryResponse implements
        ToCopyableBuilder<GetInstancesHealthStatusResponse.Builder, GetInstancesHealthStatusResponse> {
    private final Map<String, String> status;

    private final String nextToken;

    private GetInstancesHealthStatusResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A complex type that contains the IDs and the health status of the instances that you specified in the
     * <code>GetInstancesHealthStatus</code> request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A complex type that contains the IDs and the health status of the instances that you specified in the
     *         <code>GetInstancesHealthStatus</code> request.
     */
    public Map<String, HealthStatus> status() {
        return TypeConverter.convert(status, Function.identity(), HealthStatus::fromValue, (k, v) -> true);
    }

    /**
     * <p>
     * A complex type that contains the IDs and the health status of the instances that you specified in the
     * <code>GetInstancesHealthStatus</code> request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A complex type that contains the IDs and the health status of the instances that you specified in the
     *         <code>GetInstancesHealthStatus</code> request.
     */
    public Map<String, String> statusStrings() {
        return status;
    }

    /**
     * <p>
     * If more than <code>MaxResults</code> instances match the specified criteria, you can submit another
     * <code>GetInstancesHealthStatus</code> request to get the next group of results. Specify the value of
     * <code>NextToken</code> from the previous response in the next request.
     * </p>
     * 
     * @return If more than <code>MaxResults</code> instances match the specified criteria, you can submit another
     *         <code>GetInstancesHealthStatus</code> request to get the next group of results. Specify the value of
     *         <code>NextToken</code> from the previous response in the next request.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusStrings());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetInstancesHealthStatusResponse)) {
            return false;
        }
        GetInstancesHealthStatusResponse other = (GetInstancesHealthStatusResponse) obj;
        return Objects.equals(statusStrings(), other.statusStrings()) && Objects.equals(nextToken(), other.nextToken());
    }

    @Override
    public String toString() {
        return ToString.builder("GetInstancesHealthStatusResponse").add("Status", statusStrings()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.of(clazz.cast(statusStrings()));
        case "NextToken":
            return Optional.of(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ServiceDiscoveryResponse.Builder, CopyableBuilder<Builder, GetInstancesHealthStatusResponse> {
        /**
         * <p>
         * A complex type that contains the IDs and the health status of the instances that you specified in the
         * <code>GetInstancesHealthStatus</code> request.
         * </p>
         * 
         * @param status
         *        A complex type that contains the IDs and the health status of the instances that you specified in the
         *        <code>GetInstancesHealthStatus</code> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Map<String, String> status);

        /**
         * <p>
         * If more than <code>MaxResults</code> instances match the specified criteria, you can submit another
         * <code>GetInstancesHealthStatus</code> request to get the next group of results. Specify the value of
         * <code>NextToken</code> from the previous response in the next request.
         * </p>
         * 
         * @param nextToken
         *        If more than <code>MaxResults</code> instances match the specified criteria, you can submit another
         *        <code>GetInstancesHealthStatus</code> request to get the next group of results. Specify the value of
         *        <code>NextToken</code> from the previous response in the next request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ServiceDiscoveryResponse.BuilderImpl implements Builder {
        private Map<String, String> status;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetInstancesHealthStatusResponse model) {
            status(model.status);
            nextToken(model.nextToken);
        }

        public final Map<String, String> getStatus() {
            return status;
        }

        @Override
        public final Builder status(Map<String, String> status) {
            this.status = InstanceHealthStatusMapCopier.copy(status);
            return this;
        }

        public final void setStatus(Map<String, String> status) {
            this.status = InstanceHealthStatusMapCopier.copy(status);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetInstancesHealthStatusResponse build() {
            return new GetInstancesHealthStatusResponse(this);
        }
    }
}
