/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import javax.annotation.Generated;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.services.servicediscovery.model.CreatePrivateDnsNamespaceRequest;
import software.amazon.awssdk.services.servicediscovery.model.CreatePrivateDnsNamespaceResponse;
import software.amazon.awssdk.services.servicediscovery.model.CreatePublicDnsNamespaceRequest;
import software.amazon.awssdk.services.servicediscovery.model.CreatePublicDnsNamespaceResponse;
import software.amazon.awssdk.services.servicediscovery.model.CreateServiceRequest;
import software.amazon.awssdk.services.servicediscovery.model.CreateServiceResponse;
import software.amazon.awssdk.services.servicediscovery.model.DeleteNamespaceRequest;
import software.amazon.awssdk.services.servicediscovery.model.DeleteNamespaceResponse;
import software.amazon.awssdk.services.servicediscovery.model.DeleteServiceRequest;
import software.amazon.awssdk.services.servicediscovery.model.DeleteServiceResponse;
import software.amazon.awssdk.services.servicediscovery.model.DeregisterInstanceRequest;
import software.amazon.awssdk.services.servicediscovery.model.DeregisterInstanceResponse;
import software.amazon.awssdk.services.servicediscovery.model.GetInstanceRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetInstanceResponse;
import software.amazon.awssdk.services.servicediscovery.model.GetInstancesHealthStatusRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetInstancesHealthStatusResponse;
import software.amazon.awssdk.services.servicediscovery.model.GetNamespaceRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetNamespaceResponse;
import software.amazon.awssdk.services.servicediscovery.model.GetOperationRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetOperationResponse;
import software.amazon.awssdk.services.servicediscovery.model.GetServiceRequest;
import software.amazon.awssdk.services.servicediscovery.model.GetServiceResponse;
import software.amazon.awssdk.services.servicediscovery.model.ListInstancesRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListInstancesResponse;
import software.amazon.awssdk.services.servicediscovery.model.ListNamespacesRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListNamespacesResponse;
import software.amazon.awssdk.services.servicediscovery.model.ListOperationsRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListOperationsResponse;
import software.amazon.awssdk.services.servicediscovery.model.ListServicesRequest;
import software.amazon.awssdk.services.servicediscovery.model.ListServicesResponse;
import software.amazon.awssdk.services.servicediscovery.model.RegisterInstanceRequest;
import software.amazon.awssdk.services.servicediscovery.model.RegisterInstanceResponse;
import software.amazon.awssdk.services.servicediscovery.model.UpdateServiceRequest;
import software.amazon.awssdk.services.servicediscovery.model.UpdateServiceResponse;
import software.amazon.awssdk.utils.SdkAutoCloseable;

/**
 * Service client for accessing ServiceDiscovery asynchronously. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Amazon Route 53 autonaming lets you configure public or private namespaces that your microservice applications run
 * in. When instances of the service become available, you can call the autonaming API to register the instance, and
 * Amazon Route 53 automatically creates up to five DNS records and an optional health check. Clients that submit DNS
 * queries for the service receive an answer that contains up to eight healthy records.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public interface ServiceDiscoveryAsyncClient extends SdkClient, SdkAutoCloseable {
    String SERVICE_NAME = "servicediscovery";

    /**
     * Create a {@link ServiceDiscoveryAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.core.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from
     * the {@link software.amazon.awssdk.core.auth.DefaultCredentialsProvider}.
     */
    static ServiceDiscoveryAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ServiceDiscoveryAsyncClient}.
     */
    static ServiceDiscoveryAsyncClientBuilder builder() {
        return new DefaultServiceDiscoveryAsyncClientBuilder();
    }

    /**
     * <p>
     * Creates a private namespace based on DNS, which will be visible only inside a specified Amazon VPC. The namespace
     * defines your service naming scheme. For example, if you name your namespace <code>example.com</code> and name
     * your service <code>backend</code>, the resulting DNS name for the service will be
     * <code>backend.example.com</code>. You can associate more than one service with the same namespace.
     * </p>
     *
     * @param createPrivateDnsNamespaceRequest
     * @return A Java Future containing the result of the CreatePrivateDnsNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException One or more specified values aren't valid. For example, when you're creating a
     *         namespace, the value of <code>Name</code> might not be a valid DNS name.</li>
     *         <li>NamespaceAlreadyExistsException The namespace that you're trying to create already exists.</li>
     *         <li>ResourceLimitExceededException The resource can't be created because you've reached the limit on the
     *         number of resources.</li>
     *         <li>DuplicateRequestException This request tried to create an object that already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceDiscoveryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceDiscoveryAsyncClient.CreatePrivateDnsNamespace
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/CreatePrivateDnsNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePrivateDnsNamespaceResponse> createPrivateDnsNamespace(
            CreatePrivateDnsNamespaceRequest createPrivateDnsNamespaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a private namespace based on DNS, which will be visible only inside a specified Amazon VPC. The namespace
     * defines your service naming scheme. For example, if you name your namespace <code>example.com</code> and name
     * your service <code>backend</code>, the resulting DNS name for the service will be
     * <code>backend.example.com</code>. You can associate more than one service with the same namespace.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link CreatePrivateDnsNamespaceRequest.Builder} avoiding
     * the need to create one manually via {@link CreatePrivateDnsNamespaceRequest#builder()}
     *
     * @param createPrivateDnsNamespaceRequest
     *        a {@link Consumer} that will call methods on {@link CreatePrivateDnsNamespaceRequest.Builder}.
     * @return A Java Future containing the result of the CreatePrivateDnsNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException One or more specified values aren't valid. For example, when you're creating a
     *         namespace, the value of <code>Name</code> might not be a valid DNS name.</li>
     *         <li>NamespaceAlreadyExistsException The namespace that you're trying to create already exists.</li>
     *         <li>ResourceLimitExceededException The resource can't be created because you've reached the limit on the
     *         number of resources.</li>
     *         <li>DuplicateRequestException This request tried to create an object that already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceDiscoveryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceDiscoveryAsyncClient.CreatePrivateDnsNamespace
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/CreatePrivateDnsNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePrivateDnsNamespaceResponse> createPrivateDnsNamespace(
            Consumer<CreatePrivateDnsNamespaceRequest.Builder> createPrivateDnsNamespaceRequest) {
        return createPrivateDnsNamespace(CreatePrivateDnsNamespaceRequest.builder().apply(createPrivateDnsNamespaceRequest)
                .build());
    }

    /**
     * <p>
     * Creates a public namespace based on DNS, which will be visible on the internet. The namespace defines your
     * service naming scheme. For example, if you name your namespace <code>example.com</code> and name your service
     * <code>backend</code>, the resulting DNS name for the service will be <code>backend.example.com</code>. You can
     * associate more than one service with the same namespace.
     * </p>
     *
     * @param createPublicDnsNamespaceRequest
     * @return A Java Future containing the result of the CreatePublicDnsNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException One or more specified values aren't valid. For example, when you're creating a
     *         namespace, the value of <code>Name</code> might not be a valid DNS name.</li>
     *         <li>NamespaceAlreadyExistsException The namespace that you're trying to create already exists.</li>
     *         <li>ResourceLimitExceededException The resource can't be created because you've reached the limit on the
     *         number of resources.</li>
     *         <li>DuplicateRequestException This request tried to create an object that already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceDiscoveryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceDiscoveryAsyncClient.CreatePublicDnsNamespace
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/CreatePublicDnsNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePublicDnsNamespaceResponse> createPublicDnsNamespace(
            CreatePublicDnsNamespaceRequest createPublicDnsNamespaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a public namespace based on DNS, which will be visible on the internet. The namespace defines your
     * service naming scheme. For example, if you name your namespace <code>example.com</code> and name your service
     * <code>backend</code>, the resulting DNS name for the service will be <code>backend.example.com</code>. You can
     * associate more than one service with the same namespace.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link CreatePublicDnsNamespaceRequest.Builder} avoiding
     * the need to create one manually via {@link CreatePublicDnsNamespaceRequest#builder()}
     *
     * @param createPublicDnsNamespaceRequest
     *        a {@link Consumer} that will call methods on {@link CreatePublicDnsNamespaceRequest.Builder}.
     * @return A Java Future containing the result of the CreatePublicDnsNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException One or more specified values aren't valid. For example, when you're creating a
     *         namespace, the value of <code>Name</code> might not be a valid DNS name.</li>
     *         <li>NamespaceAlreadyExistsException The namespace that you're trying to create already exists.</li>
     *         <li>ResourceLimitExceededException The resource can't be created because you've reached the limit on the
     *         number of resources.</li>
     *         <li>DuplicateRequestException This request tried to create an object that already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceDiscoveryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceDiscoveryAsyncClient.CreatePublicDnsNamespace
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/CreatePublicDnsNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreatePublicDnsNamespaceResponse> createPublicDnsNamespace(
            Consumer<CreatePublicDnsNamespaceRequest.Builder> createPublicDnsNamespaceRequest) {
        return createPublicDnsNamespace(CreatePublicDnsNamespaceRequest.builder().apply(createPublicDnsNamespaceRequest).build());
    }

    /**
     * <p>
     * Creates a service, which defines a template for the following entities:
     * </p>
     * <ul>
     * <li>
     * <p>
     * One to five resource record sets
     * </p>
     * </li>
     * <li>
     * <p>
     * Optionally, a health check
     * </p>
     * </li>
     * </ul>
     * <p>
     * After you create the service, you can submit a <a>RegisterInstance</a> request, and Amazon Route 53 uses the
     * values in the template to create the specified entities.
     * </p>
     *
     * @param createServiceRequest
     * @return A Java Future containing the result of the CreateService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException One or more specified values aren't valid. For example, when you're creating a
     *         namespace, the value of <code>Name</code> might not be a valid DNS name.</li>
     *         <li>ResourceLimitExceededException The resource can't be created because you've reached the limit on the
     *         number of resources.</li>
     *         <li>NamespaceNotFoundException No namespace exists with the specified ID.</li>
     *         <li>ServiceAlreadyExistsException The service can't be created because a service with the same name
     *         already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceDiscoveryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceDiscoveryAsyncClient.CreateService
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/CreateService" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateServiceResponse> createService(CreateServiceRequest createServiceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a service, which defines a template for the following entities:
     * </p>
     * <ul>
     * <li>
     * <p>
     * One to five resource record sets
     * </p>
     * </li>
     * <li>
     * <p>
     * Optionally, a health check
     * </p>
     * </li>
     * </ul>
     * <p>
     * After you create the service, you can submit a <a>RegisterInstance</a> request, and Amazon Route 53 uses the
     * values in the template to create the specified entities.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link CreateServiceRequest.Builder} avoiding the need to
     * create one manually via {@link CreateServiceRequest#builder()}
     *
     * @param createServiceRequest
     *        a {@link Consumer} that will call methods on {@link CreateServiceRequest.Builder}.
     * @return A Java Future containing the result of the CreateService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException One or more specified values aren't valid. For example, when you're creating a
     *         namespace, the value of <code>Name</code> might not be a valid DNS name.</li>
     *         <li>ResourceLimitExceededException The resource can't be created because you've reached the limit on the
     *         number of resources.</li>
     *         <li>NamespaceNotFoundException No namespace exists with the specified ID.</li>
     *         <li>ServiceAlreadyExistsException The service can't be created because a service with the same name
     *         already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceDiscoveryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceDiscoveryAsyncClient.CreateService
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/CreateService" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateServiceResponse> createService(Consumer<CreateServiceRequest.Builder> createServiceRequest) {
        return createService(CreateServiceRequest.builder().apply(createServiceRequest).build());
    }

    /**
     * <p>
     * Deletes a namespace from the current account. If the namespace still contains one or more services, the request
     * fails.
     * </p>
     *
     * @param deleteNamespaceRequest
     * @return A Java Future containing the result of the DeleteNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException One or more specified values aren't valid. For example, when you're creating a
     *         namespace, the value of <code>Name</code> might not be a valid DNS name.</li>
     *         <li>NamespaceNotFoundException No namespace exists with the specified ID.</li>
     *         <li>ResourceInUseException The specified resource can't be deleted because it contains other resources.
     *         For example, you can't delete a service that contains any instances.</li>
     *         <li>DuplicateRequestException This request tried to create an object that already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceDiscoveryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceDiscoveryAsyncClient.DeleteNamespace
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DeleteNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNamespaceResponse> deleteNamespace(DeleteNamespaceRequest deleteNamespaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a namespace from the current account. If the namespace still contains one or more services, the request
     * fails.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DeleteNamespaceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteNamespaceRequest#builder()}
     *
     * @param deleteNamespaceRequest
     *        a {@link Consumer} that will call methods on {@link DeleteNamespaceRequest.Builder}.
     * @return A Java Future containing the result of the DeleteNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException One or more specified values aren't valid. For example, when you're creating a
     *         namespace, the value of <code>Name</code> might not be a valid DNS name.</li>
     *         <li>NamespaceNotFoundException No namespace exists with the specified ID.</li>
     *         <li>ResourceInUseException The specified resource can't be deleted because it contains other resources.
     *         For example, you can't delete a service that contains any instances.</li>
     *         <li>DuplicateRequestException This request tried to create an object that already exists.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceDiscoveryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceDiscoveryAsyncClient.DeleteNamespace
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DeleteNamespace"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteNamespaceResponse> deleteNamespace(
            Consumer<DeleteNamespaceRequest.Builder> deleteNamespaceRequest) {
        return deleteNamespace(DeleteNamespaceRequest.builder().apply(deleteNamespaceRequest).build());
    }

    /**
     * <p>
     * Deletes a specified service. If the service still contains one or more registered instances, the request fails.
     * </p>
     *
     * @param deleteServiceRequest
     * @return A Java Future containing the result of the DeleteService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException One or more specified values aren't valid. For example, when you're creating a
     *         namespace, the value of <code>Name</code> might not be a valid DNS name.</li>
     *         <li>ServiceNotFoundException No service exists with the specified ID.</li>
     *         <li>ResourceInUseException The specified resource can't be deleted because it contains other resources.
     *         For example, you can't delete a service that contains any instances.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceDiscoveryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceDiscoveryAsyncClient.DeleteService
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DeleteService" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteServiceResponse> deleteService(DeleteServiceRequest deleteServiceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a specified service. If the service still contains one or more registered instances, the request fails.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DeleteServiceRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteServiceRequest#builder()}
     *
     * @param deleteServiceRequest
     *        a {@link Consumer} that will call methods on {@link DeleteServiceRequest.Builder}.
     * @return A Java Future containing the result of the DeleteService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException One or more specified values aren't valid. For example, when you're creating a
     *         namespace, the value of <code>Name</code> might not be a valid DNS name.</li>
     *         <li>ServiceNotFoundException No service exists with the specified ID.</li>
     *         <li>ResourceInUseException The specified resource can't be deleted because it contains other resources.
     *         For example, you can't delete a service that contains any instances.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceDiscoveryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceDiscoveryAsyncClient.DeleteService
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DeleteService" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteServiceResponse> deleteService(Consumer<DeleteServiceRequest.Builder> deleteServiceRequest) {
        return deleteService(DeleteServiceRequest.builder().apply(deleteServiceRequest).build());
    }

    /**
     * <p>
     * Deletes the resource record sets and the health check, if any, that Amazon Route 53 created for the specified
     * instance.
     * </p>
     *
     * @param deregisterInstanceRequest
     * @return A Java Future containing the result of the DeregisterInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DuplicateRequestException This request tried to create an object that already exists.</li>
     *         <li>InvalidInputException One or more specified values aren't valid. For example, when you're creating a
     *         namespace, the value of <code>Name</code> might not be a valid DNS name.</li>
     *         <li>InstanceNotFoundException No instance exists with the specified ID.</li>
     *         <li>ResourceInUseException The specified resource can't be deleted because it contains other resources.
     *         For example, you can't delete a service that contains any instances.</li>
     *         <li>ServiceNotFoundException No service exists with the specified ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceDiscoveryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceDiscoveryAsyncClient.DeregisterInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DeregisterInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterInstanceResponse> deregisterInstance(DeregisterInstanceRequest deregisterInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the resource record sets and the health check, if any, that Amazon Route 53 created for the specified
     * instance.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link DeregisterInstanceRequest.Builder} avoiding the
     * need to create one manually via {@link DeregisterInstanceRequest#builder()}
     *
     * @param deregisterInstanceRequest
     *        a {@link Consumer} that will call methods on {@link DeregisterInstanceRequest.Builder}.
     * @return A Java Future containing the result of the DeregisterInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DuplicateRequestException This request tried to create an object that already exists.</li>
     *         <li>InvalidInputException One or more specified values aren't valid. For example, when you're creating a
     *         namespace, the value of <code>Name</code> might not be a valid DNS name.</li>
     *         <li>InstanceNotFoundException No instance exists with the specified ID.</li>
     *         <li>ResourceInUseException The specified resource can't be deleted because it contains other resources.
     *         For example, you can't delete a service that contains any instances.</li>
     *         <li>ServiceNotFoundException No service exists with the specified ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceDiscoveryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceDiscoveryAsyncClient.DeregisterInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/DeregisterInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeregisterInstanceResponse> deregisterInstance(
            Consumer<DeregisterInstanceRequest.Builder> deregisterInstanceRequest) {
        return deregisterInstance(DeregisterInstanceRequest.builder().apply(deregisterInstanceRequest).build());
    }

    /**
     * <p>
     * Gets information about a specified instance.
     * </p>
     *
     * @param getInstanceRequest
     * @return A Java Future containing the result of the GetInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InstanceNotFoundException No instance exists with the specified ID.</li>
     *         <li>InvalidInputException One or more specified values aren't valid. For example, when you're creating a
     *         namespace, the value of <code>Name</code> might not be a valid DNS name.</li>
     *         <li>ServiceNotFoundException No service exists with the specified ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceDiscoveryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceDiscoveryAsyncClient.GetInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetInstanceResponse> getInstance(GetInstanceRequest getInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a specified instance.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link GetInstanceRequest.Builder} avoiding the need to
     * create one manually via {@link GetInstanceRequest#builder()}
     *
     * @param getInstanceRequest
     *        a {@link Consumer} that will call methods on {@link GetInstanceRequest.Builder}.
     * @return A Java Future containing the result of the GetInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InstanceNotFoundException No instance exists with the specified ID.</li>
     *         <li>InvalidInputException One or more specified values aren't valid. For example, when you're creating a
     *         namespace, the value of <code>Name</code> might not be a valid DNS name.</li>
     *         <li>ServiceNotFoundException No service exists with the specified ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceDiscoveryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceDiscoveryAsyncClient.GetInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetInstance" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetInstanceResponse> getInstance(Consumer<GetInstanceRequest.Builder> getInstanceRequest) {
        return getInstance(GetInstanceRequest.builder().apply(getInstanceRequest).build());
    }

    /**
     * <p>
     * Gets the current health status (<code>Healthy</code>, <code>Unhealthy</code>, or <code>Unknown</code>) of one or
     * more instances that are associated with a specified service.
     * </p>
     *
     * @param getInstancesHealthStatusRequest
     * @return A Java Future containing the result of the GetInstancesHealthStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InstanceNotFoundException No instance exists with the specified ID.</li>
     *         <li>InvalidInputException One or more specified values aren't valid. For example, when you're creating a
     *         namespace, the value of <code>Name</code> might not be a valid DNS name.</li>
     *         <li>ServiceNotFoundException No service exists with the specified ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceDiscoveryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceDiscoveryAsyncClient.GetInstancesHealthStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetInstancesHealthStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInstancesHealthStatusResponse> getInstancesHealthStatus(
            GetInstancesHealthStatusRequest getInstancesHealthStatusRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the current health status (<code>Healthy</code>, <code>Unhealthy</code>, or <code>Unknown</code>) of one or
     * more instances that are associated with a specified service.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link GetInstancesHealthStatusRequest.Builder} avoiding
     * the need to create one manually via {@link GetInstancesHealthStatusRequest#builder()}
     *
     * @param getInstancesHealthStatusRequest
     *        a {@link Consumer} that will call methods on {@link GetInstancesHealthStatusRequest.Builder}.
     * @return A Java Future containing the result of the GetInstancesHealthStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InstanceNotFoundException No instance exists with the specified ID.</li>
     *         <li>InvalidInputException One or more specified values aren't valid. For example, when you're creating a
     *         namespace, the value of <code>Name</code> might not be a valid DNS name.</li>
     *         <li>ServiceNotFoundException No service exists with the specified ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceDiscoveryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceDiscoveryAsyncClient.GetInstancesHealthStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetInstancesHealthStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetInstancesHealthStatusResponse> getInstancesHealthStatus(
            Consumer<GetInstancesHealthStatusRequest.Builder> getInstancesHealthStatusRequest) {
        return getInstancesHealthStatus(GetInstancesHealthStatusRequest.builder().apply(getInstancesHealthStatusRequest).build());
    }

    /**
     * <p>
     * Gets information about a namespace.
     * </p>
     *
     * @param getNamespaceRequest
     * @return A Java Future containing the result of the GetNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException One or more specified values aren't valid. For example, when you're creating a
     *         namespace, the value of <code>Name</code> might not be a valid DNS name.</li>
     *         <li>NamespaceNotFoundException No namespace exists with the specified ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceDiscoveryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceDiscoveryAsyncClient.GetNamespace
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetNamespace" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetNamespaceResponse> getNamespace(GetNamespaceRequest getNamespaceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a namespace.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link GetNamespaceRequest.Builder} avoiding the need to
     * create one manually via {@link GetNamespaceRequest#builder()}
     *
     * @param getNamespaceRequest
     *        a {@link Consumer} that will call methods on {@link GetNamespaceRequest.Builder}.
     * @return A Java Future containing the result of the GetNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException One or more specified values aren't valid. For example, when you're creating a
     *         namespace, the value of <code>Name</code> might not be a valid DNS name.</li>
     *         <li>NamespaceNotFoundException No namespace exists with the specified ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceDiscoveryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceDiscoveryAsyncClient.GetNamespace
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetNamespace" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetNamespaceResponse> getNamespace(Consumer<GetNamespaceRequest.Builder> getNamespaceRequest) {
        return getNamespace(GetNamespaceRequest.builder().apply(getNamespaceRequest).build());
    }

    /**
     * <p>
     * Gets information about any operation that returns an operation ID in the response, such as a
     * <code>CreateService</code> request. To get a list of operations that match specified criteria, see
     * <a>ListOperations</a>.
     * </p>
     *
     * @param getOperationRequest
     * @return A Java Future containing the result of the GetOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OperationNotFoundException No operation exists with the specified ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceDiscoveryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceDiscoveryAsyncClient.GetOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetOperation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetOperationResponse> getOperation(GetOperationRequest getOperationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about any operation that returns an operation ID in the response, such as a
     * <code>CreateService</code> request. To get a list of operations that match specified criteria, see
     * <a>ListOperations</a>.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link GetOperationRequest.Builder} avoiding the need to
     * create one manually via {@link GetOperationRequest#builder()}
     *
     * @param getOperationRequest
     *        a {@link Consumer} that will call methods on {@link GetOperationRequest.Builder}.
     * @return A Java Future containing the result of the GetOperation operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>OperationNotFoundException No operation exists with the specified ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceDiscoveryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceDiscoveryAsyncClient.GetOperation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetOperation" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetOperationResponse> getOperation(Consumer<GetOperationRequest.Builder> getOperationRequest) {
        return getOperation(GetOperationRequest.builder().apply(getOperationRequest).build());
    }

    /**
     * <p>
     * Gets the settings for a specified service.
     * </p>
     *
     * @param getServiceRequest
     * @return A Java Future containing the result of the GetService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException One or more specified values aren't valid. For example, when you're creating a
     *         namespace, the value of <code>Name</code> might not be a valid DNS name.</li>
     *         <li>ServiceNotFoundException No service exists with the specified ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceDiscoveryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceDiscoveryAsyncClient.GetService
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetService" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetServiceResponse> getService(GetServiceRequest getServiceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the settings for a specified service.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link GetServiceRequest.Builder} avoiding the need to
     * create one manually via {@link GetServiceRequest#builder()}
     *
     * @param getServiceRequest
     *        a {@link Consumer} that will call methods on {@link GetServiceRequest.Builder}.
     * @return A Java Future containing the result of the GetService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException One or more specified values aren't valid. For example, when you're creating a
     *         namespace, the value of <code>Name</code> might not be a valid DNS name.</li>
     *         <li>ServiceNotFoundException No service exists with the specified ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceDiscoveryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceDiscoveryAsyncClient.GetService
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/GetService" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetServiceResponse> getService(Consumer<GetServiceRequest.Builder> getServiceRequest) {
        return getService(GetServiceRequest.builder().apply(getServiceRequest).build());
    }

    /**
     * <p>
     * Gets summary information about the instances that you created by using a specified service.
     * </p>
     *
     * @param listInstancesRequest
     * @return A Java Future containing the result of the ListInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceNotFoundException No service exists with the specified ID.</li>
     *         <li>InvalidInputException One or more specified values aren't valid. For example, when you're creating a
     *         namespace, the value of <code>Name</code> might not be a valid DNS name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceDiscoveryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceDiscoveryAsyncClient.ListInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListInstancesResponse> listInstances(ListInstancesRequest listInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets summary information about the instances that you created by using a specified service.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ListInstancesRequest.Builder} avoiding the need to
     * create one manually via {@link ListInstancesRequest#builder()}
     *
     * @param listInstancesRequest
     *        a {@link Consumer} that will call methods on {@link ListInstancesRequest.Builder}.
     * @return A Java Future containing the result of the ListInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ServiceNotFoundException No service exists with the specified ID.</li>
     *         <li>InvalidInputException One or more specified values aren't valid. For example, when you're creating a
     *         namespace, the value of <code>Name</code> might not be a valid DNS name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceDiscoveryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceDiscoveryAsyncClient.ListInstances
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListInstancesResponse> listInstances(Consumer<ListInstancesRequest.Builder> listInstancesRequest) {
        return listInstances(ListInstancesRequest.builder().apply(listInstancesRequest).build());
    }

    /**
     * <p>
     * Gets information about the namespaces that were created by the current AWS account.
     * </p>
     *
     * @param listNamespacesRequest
     * @return A Java Future containing the result of the ListNamespaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException One or more specified values aren't valid. For example, when you're creating a
     *         namespace, the value of <code>Name</code> might not be a valid DNS name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceDiscoveryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceDiscoveryAsyncClient.ListNamespaces
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListNamespaces"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNamespacesResponse> listNamespaces(ListNamespacesRequest listNamespacesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about the namespaces that were created by the current AWS account.
     * </p>
     *
     * @return A Java Future containing the result of the ListNamespaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException One or more specified values aren't valid. For example, when you're creating a
     *         namespace, the value of <code>Name</code> might not be a valid DNS name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceDiscoveryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceDiscoveryAsyncClient.ListNamespaces
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListNamespaces"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNamespacesResponse> listNamespaces() {
        return listNamespaces(ListNamespacesRequest.builder().build());
    }

    /**
     * <p>
     * Gets information about the namespaces that were created by the current AWS account.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ListNamespacesRequest.Builder} avoiding the need to
     * create one manually via {@link ListNamespacesRequest#builder()}
     *
     * @param listNamespacesRequest
     *        a {@link Consumer} that will call methods on {@link ListNamespacesRequest.Builder}.
     * @return A Java Future containing the result of the ListNamespaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException One or more specified values aren't valid. For example, when you're creating a
     *         namespace, the value of <code>Name</code> might not be a valid DNS name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceDiscoveryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceDiscoveryAsyncClient.ListNamespaces
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListNamespaces"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListNamespacesResponse> listNamespaces(Consumer<ListNamespacesRequest.Builder> listNamespacesRequest) {
        return listNamespaces(ListNamespacesRequest.builder().apply(listNamespacesRequest).build());
    }

    /**
     * <p>
     * Lists operations that match the criteria that you specify.
     * </p>
     *
     * @param listOperationsRequest
     * @return A Java Future containing the result of the ListOperations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException One or more specified values aren't valid. For example, when you're creating a
     *         namespace, the value of <code>Name</code> might not be a valid DNS name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceDiscoveryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceDiscoveryAsyncClient.ListOperations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOperationsResponse> listOperations(ListOperationsRequest listOperationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists operations that match the criteria that you specify.
     * </p>
     *
     * @return A Java Future containing the result of the ListOperations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException One or more specified values aren't valid. For example, when you're creating a
     *         namespace, the value of <code>Name</code> might not be a valid DNS name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceDiscoveryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceDiscoveryAsyncClient.ListOperations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOperationsResponse> listOperations() {
        return listOperations(ListOperationsRequest.builder().build());
    }

    /**
     * <p>
     * Lists operations that match the criteria that you specify.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ListOperationsRequest.Builder} avoiding the need to
     * create one manually via {@link ListOperationsRequest#builder()}
     *
     * @param listOperationsRequest
     *        a {@link Consumer} that will call methods on {@link ListOperationsRequest.Builder}.
     * @return A Java Future containing the result of the ListOperations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidInputException One or more specified values aren't valid. For example, when you're creating a
     *         namespace, the value of <code>Name</code> might not be a valid DNS name.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceDiscoveryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceDiscoveryAsyncClient.ListOperations
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListOperations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListOperationsResponse> listOperations(Consumer<ListOperationsRequest.Builder> listOperationsRequest) {
        return listOperations(ListOperationsRequest.builder().apply(listOperationsRequest).build());
    }

    /**
     * <p>
     * Gets settings for all the services that are associated with one or more specified namespaces.
     * </p>
     *
     * @param listServicesRequest
     * @return A Java Future containing the result of the ListServices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceDiscoveryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceDiscoveryAsyncClient.ListServices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListServices" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListServicesResponse> listServices(ListServicesRequest listServicesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets settings for all the services that are associated with one or more specified namespaces.
     * </p>
     *
     * @return A Java Future containing the result of the ListServices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceDiscoveryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceDiscoveryAsyncClient.ListServices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListServices" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListServicesResponse> listServices() {
        return listServices(ListServicesRequest.builder().build());
    }

    /**
     * <p>
     * Gets settings for all the services that are associated with one or more specified namespaces.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link ListServicesRequest.Builder} avoiding the need to
     * create one manually via {@link ListServicesRequest#builder()}
     *
     * @param listServicesRequest
     *        a {@link Consumer} that will call methods on {@link ListServicesRequest.Builder}.
     * @return A Java Future containing the result of the ListServices operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceDiscoveryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceDiscoveryAsyncClient.ListServices
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/ListServices" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListServicesResponse> listServices(Consumer<ListServicesRequest.Builder> listServicesRequest) {
        return listServices(ListServicesRequest.builder().apply(listServicesRequest).build());
    }

    /**
     * <p>
     * Creates one or more resource record sets and optionally a health check based on the settings in a specified
     * service. When you submit a <code>RegisterInstance</code> request, Amazon Route 53 does the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Creates a resource record set for each resource record set template in the service
     * </p>
     * </li>
     * <li>
     * <p>
     * Creates a health check based on the settings in the health check template in the service, if any
     * </p>
     * </li>
     * <li>
     * <p>
     * Associates the health check, if any, with each of the resource record sets
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * One <code>RegisterInstance</code> request must complete before you can submit another request and specify the
     * same service and instance ID.
     * </p>
     * </important>
     * <p>
     * For more information, see <a>CreateService</a>.
     * </p>
     * <p>
     * When Amazon Route 53 receives a DNS query for the specified DNS name, it returns the applicable value:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>If the health check is healthy</b>: returns all the resource record sets
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>If the health check is unhealthy</b>: returns the IP address of the last healthy instance
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>If you didn't specify a health check template</b>: returns all the resource record sets
     * </p>
     * </li>
     * </ul>
     *
     * @param registerInstanceRequest
     * @return A Java Future containing the result of the RegisterInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DuplicateRequestException This request tried to create an object that already exists.</li>
     *         <li>InvalidInputException One or more specified values aren't valid. For example, when you're creating a
     *         namespace, the value of <code>Name</code> might not be a valid DNS name.</li>
     *         <li>ResourceInUseException The specified resource can't be deleted because it contains other resources.
     *         For example, you can't delete a service that contains any instances.</li>
     *         <li>ResourceLimitExceededException The resource can't be created because you've reached the limit on the
     *         number of resources.</li>
     *         <li>ServiceNotFoundException No service exists with the specified ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceDiscoveryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceDiscoveryAsyncClient.RegisterInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/RegisterInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterInstanceResponse> registerInstance(RegisterInstanceRequest registerInstanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates one or more resource record sets and optionally a health check based on the settings in a specified
     * service. When you submit a <code>RegisterInstance</code> request, Amazon Route 53 does the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Creates a resource record set for each resource record set template in the service
     * </p>
     * </li>
     * <li>
     * <p>
     * Creates a health check based on the settings in the health check template in the service, if any
     * </p>
     * </li>
     * <li>
     * <p>
     * Associates the health check, if any, with each of the resource record sets
     * </p>
     * </li>
     * </ul>
     * <important>
     * <p>
     * One <code>RegisterInstance</code> request must complete before you can submit another request and specify the
     * same service and instance ID.
     * </p>
     * </important>
     * <p>
     * For more information, see <a>CreateService</a>.
     * </p>
     * <p>
     * When Amazon Route 53 receives a DNS query for the specified DNS name, it returns the applicable value:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>If the health check is healthy</b>: returns all the resource record sets
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>If the health check is unhealthy</b>: returns the IP address of the last healthy instance
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>If you didn't specify a health check template</b>: returns all the resource record sets
     * </p>
     * </li>
     * </ul>
     * <br/>
     * This is a convenience which creates an instance of the {@link RegisterInstanceRequest.Builder} avoiding the need
     * to create one manually via {@link RegisterInstanceRequest#builder()}
     *
     * @param registerInstanceRequest
     *        a {@link Consumer} that will call methods on {@link RegisterInstanceRequest.Builder}.
     * @return A Java Future containing the result of the RegisterInstance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DuplicateRequestException This request tried to create an object that already exists.</li>
     *         <li>InvalidInputException One or more specified values aren't valid. For example, when you're creating a
     *         namespace, the value of <code>Name</code> might not be a valid DNS name.</li>
     *         <li>ResourceInUseException The specified resource can't be deleted because it contains other resources.
     *         For example, you can't delete a service that contains any instances.</li>
     *         <li>ResourceLimitExceededException The resource can't be created because you've reached the limit on the
     *         number of resources.</li>
     *         <li>ServiceNotFoundException No service exists with the specified ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceDiscoveryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceDiscoveryAsyncClient.RegisterInstance
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/RegisterInstance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<RegisterInstanceResponse> registerInstance(
            Consumer<RegisterInstanceRequest.Builder> registerInstanceRequest) {
        return registerInstance(RegisterInstanceRequest.builder().apply(registerInstanceRequest).build());
    }

    /**
     * <p>
     * Updates the TTL setting for a specified service. You must specify all the resource record set templates (and,
     * optionally, a health check template) that you want to appear in the updated service. Any current resource record
     * set templates (or health check template) that don't appear in an <code>UpdateService</code> request are deleted.
     * </p>
     * <p>
     * When you update the TTL setting for a service, Amazon Route 53 also updates the corresponding settings in all the
     * resource record sets and health checks that were created by using the specified service.
     * </p>
     *
     * @param updateServiceRequest
     * @return A Java Future containing the result of the UpdateService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DuplicateRequestException This request tried to create an object that already exists.</li>
     *         <li>InvalidInputException One or more specified values aren't valid. For example, when you're creating a
     *         namespace, the value of <code>Name</code> might not be a valid DNS name.</li>
     *         <li>ServiceNotFoundException No service exists with the specified ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceDiscoveryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceDiscoveryAsyncClient.UpdateService
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/UpdateService" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateServiceResponse> updateService(UpdateServiceRequest updateServiceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the TTL setting for a specified service. You must specify all the resource record set templates (and,
     * optionally, a health check template) that you want to appear in the updated service. Any current resource record
     * set templates (or health check template) that don't appear in an <code>UpdateService</code> request are deleted.
     * </p>
     * <p>
     * When you update the TTL setting for a service, Amazon Route 53 also updates the corresponding settings in all the
     * resource record sets and health checks that were created by using the specified service.
     * </p>
     * <br/>
     * This is a convenience which creates an instance of the {@link UpdateServiceRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateServiceRequest#builder()}
     *
     * @param updateServiceRequest
     *        a {@link Consumer} that will call methods on {@link UpdateServiceRequest.Builder}.
     * @return A Java Future containing the result of the UpdateService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>DuplicateRequestException This request tried to create an object that already exists.</li>
     *         <li>InvalidInputException One or more specified values aren't valid. For example, when you're creating a
     *         namespace, the value of <code>Name</code> might not be a valid DNS name.</li>
     *         <li>ServiceNotFoundException No service exists with the specified ID.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ServiceDiscoveryException Base class for all service exceptions. Unknown exceptions will be thrown as
     *         an instance of this type.</li>
     *         </ul>
     * @sample ServiceDiscoveryAsyncClient.UpdateService
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/servicediscovery-2017-03-14/UpdateService" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateServiceResponse> updateService(Consumer<UpdateServiceRequest.Builder> updateServiceRequest) {
        return updateService(UpdateServiceRequest.builder().apply(updateServiceRequest).build());
    }
}
