/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.servicediscovery.model.ServiceChange;
import software.amazon.awssdk.services.servicediscovery.transform.DnsConfigChangeUnmarshaller;
import software.amazon.awssdk.services.servicediscovery.transform.HealthCheckConfigUnmarshaller;

public class ServiceChangeUnmarshaller
implements Unmarshaller<ServiceChange, JsonUnmarshallerContext> {
    private static final ServiceChangeUnmarshaller INSTANCE = new ServiceChangeUnmarshaller();

    public ServiceChange unmarshall(JsonUnmarshallerContext context) throws Exception {
        ServiceChange.Builder serviceChangeBuilder = ServiceChange.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    serviceChangeBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("DnsConfig", targetDepth)) {
                    context.nextToken();
                    serviceChangeBuilder.dnsConfig(DnsConfigChangeUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("HealthCheckConfig", targetDepth)) {
                    context.nextToken();
                    serviceChangeBuilder.healthCheckConfig(HealthCheckConfigUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ServiceChange)serviceChangeBuilder.build();
    }

    public static ServiceChangeUnmarshaller getInstance() {
        return INSTANCE;
    }
}

