/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.servicediscovery.model.HealthCheckConfig;

public class HealthCheckConfigUnmarshaller
implements Unmarshaller<HealthCheckConfig, JsonUnmarshallerContext> {
    private static final HealthCheckConfigUnmarshaller INSTANCE = new HealthCheckConfigUnmarshaller();

    public HealthCheckConfig unmarshall(JsonUnmarshallerContext context) throws Exception {
        HealthCheckConfig.Builder healthCheckConfigBuilder = HealthCheckConfig.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Type", targetDepth)) {
                    context.nextToken();
                    healthCheckConfigBuilder.type((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ResourcePath", targetDepth)) {
                    context.nextToken();
                    healthCheckConfigBuilder.resourcePath((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("FailureThreshold", targetDepth)) {
                    context.nextToken();
                    healthCheckConfigBuilder.failureThreshold((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (HealthCheckConfig)healthCheckConfigBuilder.build();
    }

    public static HealthCheckConfigUnmarshaller getInstance() {
        return INSTANCE;
    }
}

