/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.services.servicediscovery.model.ServiceDiscoveryRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePrivateDnsNamespaceRequest
extends ServiceDiscoveryRequest
implements ToCopyableBuilder<Builder, CreatePrivateDnsNamespaceRequest> {
    private final String name;
    private final String creatorRequestId;
    private final String description;
    private final String vpc;

    private CreatePrivateDnsNamespaceRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.creatorRequestId = builder.creatorRequestId;
        this.description = builder.description;
        this.vpc = builder.vpc;
    }

    public String name() {
        return this.name;
    }

    public String creatorRequestId() {
        return this.creatorRequestId;
    }

    public String description() {
        return this.description;
    }

    public String vpc() {
        return this.vpc;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorRequestId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpc());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePrivateDnsNamespaceRequest)) {
            return false;
        }
        CreatePrivateDnsNamespaceRequest other = (CreatePrivateDnsNamespaceRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.creatorRequestId(), other.creatorRequestId()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.vpc(), other.vpc());
    }

    public String toString() {
        return ToString.builder((String)"CreatePrivateDnsNamespaceRequest").add("Name", (Object)this.name()).add("CreatorRequestId", (Object)this.creatorRequestId()).add("Description", (Object)this.description()).add("Vpc", (Object)this.vpc()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "CreatorRequestId": {
                return Optional.ofNullable(clazz.cast(this.creatorRequestId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Vpc": {
                return Optional.ofNullable(clazz.cast(this.vpc()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ServiceDiscoveryRequest.BuilderImpl
    implements Builder {
        private String name;
        private String creatorRequestId;
        private String description;
        private String vpc;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePrivateDnsNamespaceRequest model) {
            super(model);
            this.name(model.name);
            this.creatorRequestId(model.creatorRequestId);
            this.description(model.description);
            this.vpc(model.vpc);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getCreatorRequestId() {
            return this.creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getVpc() {
            return this.vpc;
        }

        @Override
        public final Builder vpc(String vpc) {
            this.vpc = vpc;
            return this;
        }

        public final void setVpc(String vpc) {
            this.vpc = vpc;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePrivateDnsNamespaceRequest build() {
            return new CreatePrivateDnsNamespaceRequest(this);
        }
    }

    public static interface Builder
    extends ServiceDiscoveryRequest.Builder,
    CopyableBuilder<Builder, CreatePrivateDnsNamespaceRequest> {
        public Builder name(String var1);

        public Builder creatorRequestId(String var1);

        public Builder description(String var1);

        public Builder vpc(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

