/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicediscovery.transform.NamespacePropertiesMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A complex type that contains information that is specific to the namespace type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NamespaceProperties implements StructuredPojo,
        ToCopyableBuilder<NamespaceProperties.Builder, NamespaceProperties> {
    private final DnsProperties dnsProperties;

    private NamespaceProperties(BuilderImpl builder) {
        this.dnsProperties = builder.dnsProperties;
    }

    /**
     * <p>
     * A complex type that contains the ID for the hosted zone that Route 53 creates when you create a namespace.
     * </p>
     * 
     * @return A complex type that contains the ID for the hosted zone that Route 53 creates when you create a
     *         namespace.
     */
    public DnsProperties dnsProperties() {
        return dnsProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dnsProperties());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NamespaceProperties)) {
            return false;
        }
        NamespaceProperties other = (NamespaceProperties) obj;
        return Objects.equals(dnsProperties(), other.dnsProperties());
    }

    @Override
    public String toString() {
        return ToString.builder("NamespaceProperties").add("DnsProperties", dnsProperties()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DnsProperties":
            return Optional.ofNullable(clazz.cast(dnsProperties()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NamespacePropertiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, NamespaceProperties> {
        /**
         * <p>
         * A complex type that contains the ID for the hosted zone that Route 53 creates when you create a namespace.
         * </p>
         * 
         * @param dnsProperties
         *        A complex type that contains the ID for the hosted zone that Route 53 creates when you create a
         *        namespace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsProperties(DnsProperties dnsProperties);

        /**
         * <p>
         * A complex type that contains the ID for the hosted zone that Route 53 creates when you create a namespace.
         * </p>
         * This is a convenience that creates an instance of the {@link DnsProperties.Builder} avoiding the need to
         * create one manually via {@link DnsProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link DnsProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #dnsProperties(DnsProperties)}.
         * 
         * @param dnsProperties
         *        a consumer that will call methods on {@link DnsProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dnsProperties(DnsProperties)
         */
        default Builder dnsProperties(Consumer<DnsProperties.Builder> dnsProperties) {
            return dnsProperties(DnsProperties.builder().applyMutation(dnsProperties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DnsProperties dnsProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(NamespaceProperties model) {
            dnsProperties(model.dnsProperties);
        }

        public final DnsProperties.Builder getDnsProperties() {
            return dnsProperties != null ? dnsProperties.toBuilder() : null;
        }

        @Override
        public final Builder dnsProperties(DnsProperties dnsProperties) {
            this.dnsProperties = dnsProperties;
            return this;
        }

        public final void setDnsProperties(DnsProperties.BuilderImpl dnsProperties) {
            this.dnsProperties = dnsProperties != null ? dnsProperties.build() : null;
        }

        @Override
        public NamespaceProperties build() {
            return new NamespaceProperties(this);
        }
    }
}
