/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.servicediscovery.transform.HealthCheckCustomConfigMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class HealthCheckCustomConfig implements StructuredPojo,
        ToCopyableBuilder<HealthCheckCustomConfig.Builder, HealthCheckCustomConfig> {
    private final Integer failureThreshold;

    private HealthCheckCustomConfig(BuilderImpl builder) {
        this.failureThreshold = builder.failureThreshold;
    }

    /**
     * Returns the value of the FailureThreshold property for this object.
     * 
     * @return The value of the FailureThreshold property for this object.
     */
    public Integer failureThreshold() {
        return failureThreshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(failureThreshold());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HealthCheckCustomConfig)) {
            return false;
        }
        HealthCheckCustomConfig other = (HealthCheckCustomConfig) obj;
        return Objects.equals(failureThreshold(), other.failureThreshold());
    }

    @Override
    public String toString() {
        return ToString.builder("HealthCheckCustomConfig").add("FailureThreshold", failureThreshold()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FailureThreshold":
            return Optional.ofNullable(clazz.cast(failureThreshold()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HealthCheckCustomConfigMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, HealthCheckCustomConfig> {
        /**
         * Sets the value of the FailureThreshold property for this object.
         *
         * @param failureThreshold
         *        The new value for the FailureThreshold property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureThreshold(Integer failureThreshold);
    }

    static final class BuilderImpl implements Builder {
        private Integer failureThreshold;

        private BuilderImpl() {
        }

        private BuilderImpl(HealthCheckCustomConfig model) {
            failureThreshold(model.failureThreshold);
        }

        public final Integer getFailureThreshold() {
            return failureThreshold;
        }

        @Override
        public final Builder failureThreshold(Integer failureThreshold) {
            this.failureThreshold = failureThreshold;
            return this;
        }

        public final void setFailureThreshold(Integer failureThreshold) {
            this.failureThreshold = failureThreshold;
        }

        @Override
        public HealthCheckCustomConfig build() {
            return new HealthCheckCustomConfig(this);
        }
    }
}
