/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicediscovery.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetServiceResponse extends ServiceDiscoveryResponse implements
        ToCopyableBuilder<GetServiceResponse.Builder, GetServiceResponse> {
    private final Service service;

    private GetServiceResponse(BuilderImpl builder) {
        super(builder);
        this.service = builder.service;
    }

    /**
     * <p>
     * A complex type that contains information about the service.
     * </p>
     * 
     * @return A complex type that contains information about the service.
     */
    public Service service() {
        return service;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(service());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetServiceResponse)) {
            return false;
        }
        GetServiceResponse other = (GetServiceResponse) obj;
        return Objects.equals(service(), other.service());
    }

    @Override
    public String toString() {
        return ToString.builder("GetServiceResponse").add("Service", service()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Service":
            return Optional.ofNullable(clazz.cast(service()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends ServiceDiscoveryResponse.Builder, CopyableBuilder<Builder, GetServiceResponse> {
        /**
         * <p>
         * A complex type that contains information about the service.
         * </p>
         * 
         * @param service
         *        A complex type that contains information about the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder service(Service service);

        /**
         * <p>
         * A complex type that contains information about the service.
         * </p>
         * This is a convenience that creates an instance of the {@link Service.Builder} avoiding the need to create one
         * manually via {@link Service#builder()}.
         *
         * When the {@link Consumer} completes, {@link Service.Builder#build()} is called immediately and its result is
         * passed to {@link #service(Service)}.
         * 
         * @param service
         *        a consumer that will call methods on {@link Service.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #service(Service)
         */
        default Builder service(Consumer<Service.Builder> service) {
            return service(Service.builder().applyMutation(service).build());
        }
    }

    static final class BuilderImpl extends ServiceDiscoveryResponse.BuilderImpl implements Builder {
        private Service service;

        private BuilderImpl() {
        }

        private BuilderImpl(GetServiceResponse model) {
            super(model);
            service(model.service);
        }

        public final Service.Builder getService() {
            return service != null ? service.toBuilder() : null;
        }

        @Override
        public final Builder service(Service service) {
            this.service = service;
            return this;
        }

        public final void setService(Service.BuilderImpl service) {
            this.service = service != null ? service.build() : null;
        }

        @Override
        public GetServiceResponse build() {
            return new GetServiceResponse(this);
        }
    }
}
