/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.servicecatalog.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.servicecatalog.model.ServiceCatalogRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisassociateBudgetFromResourceRequest
extends ServiceCatalogRequest
implements ToCopyableBuilder<Builder, DisassociateBudgetFromResourceRequest> {
    private static final SdkField<String> BUDGET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BudgetName").getter(DisassociateBudgetFromResourceRequest.getter(DisassociateBudgetFromResourceRequest::budgetName)).setter(DisassociateBudgetFromResourceRequest.setter(Builder::budgetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BudgetName").build()}).build();
    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceId").getter(DisassociateBudgetFromResourceRequest.getter(DisassociateBudgetFromResourceRequest::resourceId)).setter(DisassociateBudgetFromResourceRequest.setter(Builder::resourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUDGET_NAME_FIELD, RESOURCE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("BudgetName", BUDGET_NAME_FIELD);
            this.put("ResourceId", RESOURCE_ID_FIELD);
        }
    });
    private final String budgetName;
    private final String resourceId;

    private DisassociateBudgetFromResourceRequest(BuilderImpl builder) {
        super(builder);
        this.budgetName = builder.budgetName;
        this.resourceId = builder.resourceId;
    }

    public final String budgetName() {
        return this.budgetName;
    }

    public final String resourceId() {
        return this.resourceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.budgetName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateBudgetFromResourceRequest)) {
            return false;
        }
        DisassociateBudgetFromResourceRequest other = (DisassociateBudgetFromResourceRequest)((Object)obj);
        return Objects.equals(this.budgetName(), other.budgetName()) && Objects.equals(this.resourceId(), other.resourceId());
    }

    public final String toString() {
        return ToString.builder((String)"DisassociateBudgetFromResourceRequest").add("BudgetName", (Object)this.budgetName()).add("ResourceId", (Object)this.resourceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BudgetName": {
                return Optional.ofNullable(clazz.cast(this.budgetName()));
            }
            case "ResourceId": {
                return Optional.ofNullable(clazz.cast(this.resourceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DisassociateBudgetFromResourceRequest, T> g) {
        return obj -> g.apply((DisassociateBudgetFromResourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ServiceCatalogRequest.BuilderImpl
    implements Builder {
        private String budgetName;
        private String resourceId;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateBudgetFromResourceRequest model) {
            super(model);
            this.budgetName(model.budgetName);
            this.resourceId(model.resourceId);
        }

        public final String getBudgetName() {
            return this.budgetName;
        }

        public final void setBudgetName(String budgetName) {
            this.budgetName = budgetName;
        }

        @Override
        public final Builder budgetName(String budgetName) {
            this.budgetName = budgetName;
            return this;
        }

        public final String getResourceId() {
            return this.resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateBudgetFromResourceRequest build() {
            return new DisassociateBudgetFromResourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ServiceCatalogRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisassociateBudgetFromResourceRequest> {
        public Builder budgetName(String var1);

        public Builder resourceId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

