/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securitylake.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provide expiration lifecycle details of Amazon Security Lake object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataLakeLifecycleExpiration implements SdkPojo, Serializable,
        ToCopyableBuilder<DataLakeLifecycleExpiration.Builder, DataLakeLifecycleExpiration> {
    private static final SdkField<Integer> DAYS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("days")
            .getter(getter(DataLakeLifecycleExpiration::days)).setter(setter(Builder::days))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("days").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DAYS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer days;

    private DataLakeLifecycleExpiration(BuilderImpl builder) {
        this.days = builder.days;
    }

    /**
     * <p>
     * Number of days before data expires in the Amazon Security Lake object.
     * </p>
     * 
     * @return Number of days before data expires in the Amazon Security Lake object.
     */
    public final Integer days() {
        return days;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(days());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataLakeLifecycleExpiration)) {
            return false;
        }
        DataLakeLifecycleExpiration other = (DataLakeLifecycleExpiration) obj;
        return Objects.equals(days(), other.days());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataLakeLifecycleExpiration").add("Days", days()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "days":
            return Optional.ofNullable(clazz.cast(days()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataLakeLifecycleExpiration, T> g) {
        return obj -> g.apply((DataLakeLifecycleExpiration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataLakeLifecycleExpiration> {
        /**
         * <p>
         * Number of days before data expires in the Amazon Security Lake object.
         * </p>
         * 
         * @param days
         *        Number of days before data expires in the Amazon Security Lake object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder days(Integer days);
    }

    static final class BuilderImpl implements Builder {
        private Integer days;

        private BuilderImpl() {
        }

        private BuilderImpl(DataLakeLifecycleExpiration model) {
            days(model.days);
        }

        public final Integer getDays() {
            return days;
        }

        public final void setDays(Integer days) {
            this.days = days;
        }

        @Override
        public final Builder days(Integer days) {
            this.days = days;
            return this;
        }

        @Override
        public DataLakeLifecycleExpiration build() {
            return new DataLakeLifecycleExpiration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
