/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubAsyncClient;
import software.amazon.awssdk.services.securityhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.securityhub.model.ConfigurationPolicyAssociationSummary;
import software.amazon.awssdk.services.securityhub.model.ListConfigurationPolicyAssociationsRequest;
import software.amazon.awssdk.services.securityhub.model.ListConfigurationPolicyAssociationsResponse;

public class ListConfigurationPolicyAssociationsPublisher
implements SdkPublisher<ListConfigurationPolicyAssociationsResponse> {
    private final SecurityHubAsyncClient client;
    private final ListConfigurationPolicyAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListConfigurationPolicyAssociationsPublisher(SecurityHubAsyncClient client, ListConfigurationPolicyAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListConfigurationPolicyAssociationsPublisher(SecurityHubAsyncClient client, ListConfigurationPolicyAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListConfigurationPolicyAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListConfigurationPolicyAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ConfigurationPolicyAssociationSummary> configurationPolicyAssociationSummaries() {
        Function<ListConfigurationPolicyAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.configurationPolicyAssociationSummaries() != null) {
                return response.configurationPolicyAssociationSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListConfigurationPolicyAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListConfigurationPolicyAssociationsResponseFetcher
    implements AsyncPageFetcher<ListConfigurationPolicyAssociationsResponse> {
        private ListConfigurationPolicyAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListConfigurationPolicyAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListConfigurationPolicyAssociationsResponse> nextPage(ListConfigurationPolicyAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListConfigurationPolicyAssociationsPublisher.this.client.listConfigurationPolicyAssociations(ListConfigurationPolicyAssociationsPublisher.this.firstRequest);
            }
            return ListConfigurationPolicyAssociationsPublisher.this.client.listConfigurationPolicyAssociations((ListConfigurationPolicyAssociationsRequest)((Object)ListConfigurationPolicyAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

