/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityhub.SecurityHubAsyncClient;
import software.amazon.awssdk.services.securityhub.internal.UserAgentUtils;
import software.amazon.awssdk.services.securityhub.model.AggregatorV2;
import software.amazon.awssdk.services.securityhub.model.ListAggregatorsV2Request;
import software.amazon.awssdk.services.securityhub.model.ListAggregatorsV2Response;

public class ListAggregatorsV2Publisher
implements SdkPublisher<ListAggregatorsV2Response> {
    private final SecurityHubAsyncClient client;
    private final ListAggregatorsV2Request firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAggregatorsV2Publisher(SecurityHubAsyncClient client, ListAggregatorsV2Request firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAggregatorsV2Publisher(SecurityHubAsyncClient client, ListAggregatorsV2Request firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAggregatorsV2ResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAggregatorsV2Response> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AggregatorV2> aggregatorsV2() {
        Function<ListAggregatorsV2Response, Iterator> getIterator = response -> {
            if (response != null && response.aggregatorsV2() != null) {
                return response.aggregatorsV2().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAggregatorsV2ResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAggregatorsV2ResponseFetcher
    implements AsyncPageFetcher<ListAggregatorsV2Response> {
        private ListAggregatorsV2ResponseFetcher() {
        }

        public boolean hasNextPage(ListAggregatorsV2Response previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAggregatorsV2Response> nextPage(ListAggregatorsV2Response previousPage) {
            if (previousPage == null) {
                return ListAggregatorsV2Publisher.this.client.listAggregatorsV2(ListAggregatorsV2Publisher.this.firstRequest);
            }
            return ListAggregatorsV2Publisher.this.client.listAggregatorsV2((ListAggregatorsV2Request)((Object)ListAggregatorsV2Publisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

